<?php
namespace Internetgalerie\IgSimplesubscribe\Domain\Repository;

use FriendsOfTYPO3\TtAddress\Domain\Repository\AddressRepository as FriendsOfTYPO3AddressRepository;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Query\Restriction\HiddenRestriction;
use TYPO3\CMS\Core\Utility\GeneralUtility;

// use TYPO3\TtAddress\Domain\Repository\AddressRepository as FriendsOfTYPO3AddressRepository;

/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

/**
 * The repository for Addresses
 */
class AddressRepository extends FriendsOfTYPO3AddressRepository
{
    /**
     * Initialize object
     *
     * @return void
     */
    public function initializeObject()
    {
        $query = $this->createQuery();
        $querySettings = $query->getQuerySettings();

        $querySettings->setIgnoreEnableFields(true);
        $querySettings->setRespectSysLanguage(false);
        //$querySettings->setLanguageOverlayMode(false);
        $querySettings->setEnableFieldsToBeIgnored(['disabled']);
        $this->setDefaultQuerySettings(clone $querySettings);
    }

    /**
     * Need this function because findByUid is handled differently in the base class for repositories,
     * hidden records are returned too with this function
     *
     * @param int $uid
     *
     * @return \Internetgalerie\IgSimplesubscribe\Domain\Model\Address
     */
    public function findHiddenByUid($uid)
    {
        $query = $this->createQuery();
        $querySettings = $query->getQuerySettings();

        $querySettings->setIgnoreEnableFields(true);
        $querySettings->setRespectSysLanguage(false);
        //$querySettings->setLanguageOverlayMode(false);
        $querySettings->setEnableFieldsToBeIgnored(['disabled']);
        $query->setQuerySettings($querySettings);

        $query->matching($query->logicalOr(
            $query->equals('uid', $uid),
            $query->equals('l10nParent', $uid)
        ));
        return $query->execute()->getFirst();
    }

    public function countInLastHour()
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tt_address');

        $queryBuilder->getRestrictions()->removeByType(HiddenRestriction::class);

        $res = $queryBuilder->selectLiteral('COUNT(*) AS count')
            ->from('tt_address')
            ->where($queryBuilder->expr()->gte('crdate', time() - 3600))
            ->executeQuery()
            ->fetchAssociative();

        return $res['count'];
    }
}
