<?php

if (!isset($GLOBALS['TCA']['tt_address']['ctrl']['type'])) {
	if (isset($GLOBALS['TCA']['tt_address']['ctrl']['dynamicConfigFile']) && file_exists($GLOBALS['TCA']['tt_address']['ctrl']['dynamicConfigFile'])) {
		require_once($GLOBALS['TCA']['tt_address']['ctrl']['dynamicConfigFile']);
	}
	// no type field defined, so we define it here. This will only happen the first time the extension is installed!!
	$GLOBALS['TCA']['tt_address']['ctrl']['type'] = 'tx_extbase_type';
	$tempColumnstx_igsimplesubscribe_tt_address = [];
	$tempColumnstx_igsimplesubscribe_tt_address[$GLOBALS['TCA']['tt_address']['ctrl']['type']] = [
		'exclude' => 1,
		'label'   => 'LLL:EXT:ig_simplesubscribe/Resources/Private/Language/locallang_db.xlf:tx_igsimplesubscribe.tx_extbase_type',
		'config' => [
			'type' => 'select',
			'renderType' => 'selectSingle',
			'items' => [
				[
					'label' => 'Address',
					'value' => 'Tx_IgSimplesubscribe_Address'
				]
			],
			'default' => 'Tx_IgSimplesubscribe_Address',
			'size' => 1,
			'maxitems' => 1,
		]
	];
	\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('tt_address', $tempColumnstx_igsimplesubscribe_tt_address, 1);
}

\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addToAllTCAtypes(
	'tt_address',
	$GLOBALS['TCA']['tt_address']['ctrl']['type'],
	'',
	'after:' . $GLOBALS['TCA']['tt_address']['ctrl']['label']
);

$tmp_ig_simplesubscribe_columns = [
	'localgender' => [
		'exclude' => 1,
		'label' => 'LLL:EXT:ig_simplesubscribe/Resources/Private/Language/locallang_db.xlf:tx_igsimplesubscribe_domain_model_address.localgender',
		'config' => [
			'type' => 'input',
			'size' => 30,
			'eval' => 'trim'
		],
	],
	'password' => [
		'exclude' => 1,
		'label' => 'LLL:EXT:ig_simplesubscribe/Resources/Private/Language/locallang_db.xlf:tx_igsimplesubscribe_domain_model_address.password',
		'config' => [
			'type' => 'input',
			'size' => 30,
			'eval' => 'trim'
		],
	],
	'link_hash' => [
		'exclude' => 1,
		'label' => 'Link Hash',
		'config' => [
				  'type' => 'passthrough'
		],
	],
    'accepted' => [
        'exclude' => 1,
        'label' => 'Accepted',
        'config' => [
            'type' => 'check',
        ],
    ],

    'ip_address' => [
        'label' => 'IP Address',
        'config' => [
            'type' => 'input',
            'size' => 30,
            'max' => 255,
        ]
    ],
    'browser' => [
        'label' => 'Browser',
        'config' => [
            'type' => 'input',
            'size' => 30,
            'max' => 255,
        ]
    ],
    'speciality' => [
        'exclude' => 0,
        'label' => 'Spezialität',
        'config' => [
            'type' => 'input',
            'size' => 30,
        ],
    ],
    'language' => [
        'exclude' => 0,
        'label' => 'Sprache',
        'config' => [
            'type' => 'input',
            'size' => 30,
        ],
    ]
];

\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('tt_address',$tmp_ig_simplesubscribe_columns);

/* inherit and extend the show items from the parent class */

if(isset($GLOBALS['TCA']['tt_address']['types']['0']['showitem'])) {
	$GLOBALS['TCA']['tt_address']['types']['Tx_IgSimplesubscribe_Address']['showitem'] = $GLOBALS['TCA']['tt_address']['types']['0']['showitem'];
} elseif(is_array($GLOBALS['TCA']['tt_address']['types'])) {
	// use first entry in types array
	$tt_address_type_definition = reset($GLOBALS['TCA']['tt_address']['types']);
	$GLOBALS['TCA']['tt_address']['types']['Tx_IgSimplesubscribe_Address']['showitem'] = $tt_address_type_definition['showitem'];
} else {
	$GLOBALS['TCA']['tt_address']['types']['Tx_IgSimplesubscribe_Address']['showitem'] = '';
}
$GLOBALS['TCA']['tt_address']['types']['Tx_IgSimplesubscribe_Address']['showitem'] .= ',--div--;LLL:EXT:ig_simplesubscribe/Resources/Private/Language/locallang_db.xlf:tx_igsimplesubscribe_domain_model_address,';
$GLOBALS['TCA']['tt_address']['types']['Tx_IgSimplesubscribe_Address']['showitem'] .= 'speciality, language, localgender, password, link_hash, ip_address, browser';

$GLOBALS['TCA']['tt_address']['columns'][$GLOBALS['TCA']['tt_address']['ctrl']['type']]['config']['items'][] = [
	'label' => 'LLL:EXT:ig_simplesubscribe/Resources/Private/Language/locallang_db.xlf:tt_address.tx_extbase_type.Tx_IgSimplesubscribe_Address',
	'value' => 'Tx_IgSimplesubscribe_Address'
];
