<?php
use \TYPO3\CMS\Extbase\Utility\LocalizationUtility;

/**
 * Mögliche Feldtypen und zugehörige Eigenschaften:
 * - text
 * - select => defaultOption (bool), options (Array of values), in locallang you need to define fieldname_value as key for the label (E.g. gender_m, gender_f and gender_g)
 * - upload => extensions (Array of values)
 * - checkbox => (Not used yet)
 */
return [
    'gender' => [
        'type' => 'select',
        'defaultOption' => true, // Default option is an empty option at the beginning. It is filled with the label with key 'gender' in locallang
        'options' => [
            'm', // Locallang: gender_m
            'f', // Locallang: gender_f
            'g', // Locallang: gender_g
        ],
    ],
    'name' => [
        'type' => 'text',
    ],
    'first_name' => [
        'type' => 'text',
    ],
    'middle_name' => [
        'type' => 'text',
    ],
    'last_name' => [
        'type' => 'text',
    ],
    'birthday' => [
        'type' => 'date',
    ],
    'title' => [
        'type' => 'text',
    ],
    'address' => [
        'type' => 'text',
    ],
    'latitude' => [
        'type' => 'text',
    ],
    'longitude' => [
        'type' => 'text',
    ],
    'building' => [
        'type' => 'text',
    ],
    'room' => [
        'type' => 'text',
    ],
    'phone' => [
        'type' => 'text',
    ],
    'fax' => [
        'type' => 'text',
    ],
    'mobile' => [
        'type' => 'text',
    ],
    'www' => [
        'type' => 'text',
    ],
    'skype' => [
        'type' => 'text',
    ],
    'twitter' => [
        'type' => 'text',
    ],
    'facebook' => [
        'type' => 'text',
    ],
    'linked_in' => [
        'type' => 'text',
    ],
    'email' => [
        'type' => 'text',
        'validate' => 'notEmpty,email,unique',
    ],
    'username' => [
        'type' => 'text',
        'validate' => 'notEmpty,email,unique',
    ],
    'password' => [
        'type' => 'text',
        'validate' => 'notEmpty,password',
    ],
    'company' => [
        'type' => 'text',
    ],
    'position' => [
        'type' => 'text',
    ],
    'city' => [
        'type' => 'text',
    ],
    'zip' => [
        'type' => 'text',
    ],
    'region' => [
        'type' => 'text',
    ],
    'country' => [
        'type' => 'text',
    ],
    'image' => [
        'type' => 'upload',
        'extensions' => [
            'jpg',
            'jpeg',
            'png',
            'gif',
            'svg',
        ],
    ],
    'description' => [
        'type' => 'text',
    ],
    'categories' => [
        'type' => 'multiselect',
        'validate' => 'notEmpty',
    ],
];
