<?php
defined('TYPO3') or die();

$tempColumns = [
    'loop' => [
        'exclude' => true,
        'label' => 'LLL:EXT:ig_video_extender/Resources/Private/Language/locallang.xlf:sys_file_reference.loop',
        'config' => [
            'type' => 'check',
            'renderType' => 'checkboxToggle',
            'default' => 0,
        ],
    ],
    'controls' => [
        'exclude' => true,
        'label' => 'LLL:EXT:ig_video_extender/Resources/Private/Language/locallang.xlf:sys_file_reference.controls',
        'config' => [
            'type' => 'check',
            'renderType' => 'checkboxToggle',
            'default' => 1,
        ],
    ],
    'media_poster' => [
        'label' => 'LLL:EXT:ig_video_extender/Resources/Private/Language/locallang.xlf:sys_file_reference.poster',
    ]
];
if ((new \TYPO3\CMS\Core\Information\Typo3Version())->getMajorVersion() < 12) {
    $tempColumns['media_poster']['config'] = TYPO3\CMS\Core\Utility\ExtensionManagementUtility::getFileFieldTCAConfig(
        'image',
        [
            'maxitems' => 1,
        ],
        $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext']
    );
} else {
    $tempColumns['media_poster']['config'] = [
        'type' => 'file',
        'maxitems' => 1,
        'allowed' => 'common-image-types',
    ];
}
TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('sys_file_reference', $tempColumns);

$GLOBALS['TCA']['sys_file_reference']['palettes']['videoOverlayPalette']['showitem'] = ' title,description,--linebreak--,autoplay,loop,controls,--linebreak--,media_poster ';
