<?php

namespace Internetgalerie\IgVideoExtender\Resource\Rendering;

use TYPO3\CMS\Core\Resource\FileInterface;
use TYPO3\CMS\Core\Resource\FileReference;
use TYPO3\CMS\Core\Resource\Rendering\VideoTagRenderer as CoreVideoTagRenderer;

/**
 * Class VideoTagRenderer
 */
class VideoTagRenderer extends CoreVideoTagRenderer
{
    /**
     * Render for given File(Reference) HTML output
     *
     * @param FileInterface $file
     * @param int|string $width TYPO3 known format; examples: 220, 200m or 200c
     * @param int|string $height TYPO3 known format; examples: 220, 200m or 200c
     * @param array $options controls = TRUE/FALSE (default TRUE), autoplay = TRUE/FALSE (default FALSE), loop = TRUE/FALSE (default FALSE)
     * @param bool $usedPathsRelativeToCurrentScript See $file->getPublicUrl()
     * @return string
     */
    public function render(FileInterface $file, $width, $height, array $options = [], $usedPathsRelativeToCurrentScript = false)
    {
        if (!isset($options['loop']) && $file instanceof FileReference) {
            $loop = $file->getProperty('loop');
            if ($loop !== null) {
                $options['loop'] = $loop;
            }
        }
        if (!isset($options['controls']) && $file instanceof FileReference) {
            $controls = $file->getProperty('controls');
            if ($controls !== null) {
                $options['controls'] = $controls;
            }
        }
        return parent::render($file, $width, $height, $options, $usedPathsRelativeToCurrentScript);
    }
}
