<?php

namespace Internetgalerie\IgWidgets\Widgets;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Dashboard\Widgets\AdditionalCssInterface;
use TYPO3\CMS\Dashboard\Widgets\ButtonProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\ListDataProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetConfigurationInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetInterface;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use TYPO3\CMS\Backend\View\BackendViewFactory;
use TYPO3\CMS\Dashboard\Widgets\RequestAwareWidgetInterface;
use Psr\Http\Message\ServerRequestInterface;

class FeUsersWidget implements WidgetInterface, RequestAwareWidgetInterface
{

    private ServerRequestInterface $request;

    public function __construct(
        private readonly WidgetConfigurationInterface $configuration,
        private readonly BackendViewFactory $backendViewFactory,
        private readonly array $options = []
    ) {
    }

    public function setRequest(ServerRequestInterface $request): void
    {
        $this->request = $request;
    }

    public function renderWidgetContent(): string
    {
        $view = $this->backendViewFactory->create($this->request, ['typo3/cms-dashboard', 'internetgalerie/ig-widgets']);

        $stats = [];
        //$title=$this->getLanguageService()->sL('LLL:EXT:core/Resources/Private/Language/locallang_core.xlf:labels.path');
        $title = $this->getLanguageService()->sL('LLL:EXT:frontend/Resources/Private/Language/locallang_tca.xlf:fe_users');
        $stats[] = $this->getStats('fe_users', 'disable', $title, $this->options['days'] ?? 30);
        if(isset($GLOBALS['TCA']['tt_address']))
        {
            $title = LocalizationUtility::translate('label.address', 'ttAddress');
            $stats[] = $this->getStats('tt_address', 'hidden', $title, $this->options['days'] ?? 30);
        }
        $view->assignMultiple(
            [
            'stats' => $stats,
            'options' => $this->options,
            'configuration' => $this->configuration,
            ]
        );
        return $view->render($this->options['template'] ?? 'IgWidgets/Widget/FeUsersWidget');
    }
    public function getStats($table, $disable, $title, $days)
    {
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tt_address');
        $queries= [
            // Total Active
            'active' => 'SELECT COUNT(1) AS total FROM ' . $table . ' where deleted=0 AND ' . $disable . '=0',
            //Total new (more or less):
            'new' => 'SELECT COUNT(1) AS total FROM ' . $table . ' where deleted=0 AND ' . $disable . '=0 AND crdate> UNIX_TIMESTAMP()- ' . intval($GLOBALS['EXEC_TIME'] - (int)$days * 86400),
            //Total deleted/unsubscribe (more or less):
            'deleted' => 'SELECT COUNT(1) AS total FROM ' . $table . ' where (deleted=1 OR ' . $disable . '=1) AND tstamp<>crdate AND tstamp> ' . intval($GLOBALS['EXEC_TIME'] - (int)$days * 86400),
        ];
        $feUsersStats = [
            'title' => $title,
        ];
        foreach($queries as $name => $query) {
            $stmt = $conn->prepare($query);
            $res = $stmt->executeQuery([]);
            $row = $res->fetchAssociative();
            $feUsersStats[$name] = (int)$row['total'];
        }

        return $feUsersStats;
    }
    /**
     * @return LanguageService
     */
    protected function getLanguageService()
    {
        return $GLOBALS['LANG'];
    }
    /**
     * This method returns the options of the widget as set in the registration.
     */
    public function getOptions(): array
    {
        return $this->options;
    }

}