<?php

namespace Internetgalerie\IgWidgets\ViewHelpers;

use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class CookieViewHelper extends AbstractViewHelper
{
    public function initializeArguments()
    {
        $this->registerArgument('cookies', 'array', 'ig_widgets cookies', true);
    }

    public function render(): string
    {
        $cookieArray = [];
        foreach ($this->arguments['cookies'] as $key => $value) {
            $cookieArray[] = [
                'identifier' => $key,
                'label' => str_replace("igwidgets_", "", $key),
                'value' => $value
            ];
        }
        return $cookieArray;
    }
}
