<?php

declare(strict_types=1);

namespace Internetgalerie\IgWidgets\Widgets;

use TYPO3\CMS\Core\Page\JavaScriptModuleInstruction;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Dashboard\Widgets\AdditionalCssInterface;
use TYPO3\CMS\Dashboard\Widgets\ButtonProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\ChartDataProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\EventDataInterface;
use TYPO3\CMS\Dashboard\Widgets\ListDataProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\JavaScriptInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetConfigurationInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetInterface;
use TYPO3\CMS\Backend\View\BackendViewFactory;
use TYPO3\CMS\Dashboard\Widgets\RequestAwareWidgetInterface;
use Psr\Http\Message\ServerRequestInterface;

/**
 * Concrete Doughnut Chart widget implementation
 *
 * Shows a widget with a doughnut chart. The data for this chart will be provided by the data provider you will set.
 * You can add a button to the widget by defining a button provider.
 *
 * There are no options available for this widget
 *
 * @see ChartDataProviderInterface
 * @see ButtonProviderInterface
 */
class LineChartWidget implements WidgetInterface, RequestAwareWidgetInterface, EventDataInterface, AdditionalCssInterface, JavaScriptInterface 
{

    private ServerRequestInterface $request;

    public function __construct(
        private readonly WidgetConfigurationInterface $configuration,
        private readonly ChartDataProviderInterface $dataProvider,
        private readonly BackendViewFactory $backendViewFactory,
        private readonly ?ButtonProviderInterface $buttonProvider = null,
        private readonly array $options = []
    ) {
    }

    public function setRequest(ServerRequestInterface $request): void
    {
        $this->request = $request;
    }
            
    public function renderWidgetContent(): string
    {
        $view = $this->backendViewFactory->create($this->request, ['typo3/cms-dashboard', 'internetgalerie/ig-widgets']);
        $view->assignMultiple(
            [
            'button' => $this->buttonProvider,
            'options' => $this->options,
            'configuration' => $this->configuration,
            ]
        );
        return $view->render('Widget/ChartWidget');
    }

    public function getEventData(): array
    {
        return [
            'graphConfig' => [
                'type' => 'line',
                'options' => [
                    'maintainAspectRatio' => false,
                    'scales' => [
                        'y' => [
                            'ticks' => [
                                // 'suggestedMin' => 0,
                                'beginAtZero' => true,
                                'precision' => 0,
                            ],
                        ],
                        /*
                        'x' => [
                            'ticks' => [
                                'maxTicksLimit' => 15,
                            ],
                        ],
                        */

                    ],
                    'plugins' => [
                        'legend' => [
                            'display' => true,
                            'position' => 'bottom',
                        ],
                    ],
                    /*
                    'legend' => [
                        'display' => true,
                        'position' => 'bottom',
                    ],
                    */
                ],
                'data' => $this->dataProvider->getChartData(),
            ],
        ];
    }

    public function getCssFiles(): array
    {
        return [];//['EXT:dashboard/Resources/Public/Css/Contrib/chart.css'];
    }

    public function getJavaScriptModuleInstructions(): array
    {
        return [
            JavaScriptModuleInstruction::create('@typo3/dashboard/contrib/chartjs.js'),
            JavaScriptModuleInstruction::create('@typo3/dashboard/chart-initializer.js'),
        ];
    }
    
    /**
     * This method returns the options of the widget as set in the registration.
     */
    public function getOptions(): array
    {
        return $this->options;
    }
}
