<?php

declare(strict_types=1);

namespace Internetgalerie\IgWidgets\Widgets\Provider;


use TYPO3\CMS\Backend\Routing\UriBuilder;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Dashboard\Widgets\ButtonProviderInterface;

/**
 * Provides a button for the footer of a widget
 */
class RouteButtonProvider implements ButtonProviderInterface
{
    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $target;

    /**
     * @var string
     */
    private $route;

    /**
     * @var string
     */
    private $moduleName;

    /**
     * @var int
     */
    private $pageId;

    /**
     * @var array
     */
    private $arguments = [];

    public function __construct(string $title, string $route, string $moduleName=null, int $pageId=null, array $arguments=[], string $target = '')
    {
        $this->title = $title;
        $this->target = $target;
        $this->route = $route;
        $this->moduleName = $moduleName ?? $route;
        $this->pageId = $pageId;
        $this->arguments = $arguments;
    }

    public function getTitle(): string
    {
        return $this->title;
    }
    public function getHasAccess(): bool
    {
        return $GLOBALS['BE_USER']->check('modules', $this->moduleName);
    }

    public function getRoute(): string
    {
        return $this->route;
    }
    public function getJumpLink(): string
    {
        $uriBuilder = GeneralUtility::makeInstance(UriBuilder::class);
        $moduleParts = explode('_', $this->moduleName);
        $url = (string)$uriBuilder->buildUriFromRoute($this->route, $this->arguments);
        return 'top.jump(' . GeneralUtility::quoteJSvalue($url) . ',' . GeneralUtility::quoteJSvalue($this->moduleName) . ',' . GeneralUtility::quoteJSvalue($moduleParts[0]) . ', ' . (int)$this->pageId . ');';
    }

    public function getLink(): string
    {
        return 'javascript:' . $this->getJumpLink();
    }
    public function getClick(): string
    {
        return $this->getJumpLink() . ';return false;';
    }


    public function getTarget(): string
    {
        return $this->target;
    }
}
