<?php
declare(strict_types=1);

namespace Internetgalerie\IgWidgets\Widgets\Provider;


use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\IndexedSearch\Domain\Repository\AdministrationRepository;

class SearchKeywordsProvider implements TableProviderInterface
{
    /**
     * @var AdministrationRepository
     */
    protected $administrationRepository;

    /**
     * @var int Current page id
     */
    protected $pageUid = 0;

    /**
     * @var int
     */
    private $limit;

    /**
     * @var int
     */
    private $days = 0;

    /**
     * @var array
     */
    private $entries = null;
    public function __construct(int $limit, int $days, int $pageUid)
    {
        $this->limit = $limit ?: 10;
        $this->days = $days;
        $this->pageUid = $pageUid;
    }
    
    public function getHeader(): array
    {
        return [];
    }
    public function getFooter(): array
    {
        $this->initStat();
       
        return [
            'title' => 'Anzahl Stichworte',
            'count' => count($this->entries),
        ];
    }
    
    public function getEntries(  ): array
    {
        $items=[];
        //$queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igshop2_domain_model_product');
        $this->initStat();
        $limit=$this->limit;
        foreach($this->entries as $row) {
            $limit--;
            if(!$limit ) {
                break;
            }
                
            $items[] = [
                'title' => $row['word'],
                'count' => $row['c'],
            ];
        }
        return $items;
    }

    public function getLimit(): int
    {
        return $this->limit;
    }

    public function getDays(): int
    {
        return $this->days;
    }

    public function getPageUid(): int
    {
        return $this->pageUid;
    }



    public function initStat( )
    {
        if($this->entries !== null ) {
            return;
        }
        $expressionBuilder = GeneralUtility::makeInstance(ConnectionPool::class)
            ->getQueryBuilderForTable('index_stat_word')
            ->expr();
        /*
        $dutationWhere = [
            'all' => '',
            'last24hours' => $expressionBuilder->gt('tstamp', $GLOBALS['EXEC_TIME'] - 86400),
            'last30days' => $expressionBuilder->gt('tstamp', $GLOBALS['EXEC_TIME'] - 30 * 86400),
        ];

        */
        $this->administrationRepository = GeneralUtility::makeInstance(AdministrationRepository::class);
        $dutationWhere=(int)$this->days>0 ? $expressionBuilder->gt('tstamp', $GLOBALS['EXEC_TIME'] - (int)$this->day * 86400) : '';
        $this->entries = $this->administrationRepository->getGeneralSearchStatistic($dutationWhere, $this->pageUid);
    }
    public function setOptions( array $options)
    {
        if(isset($options['days']) ) {
            $this->days = (int) $options['days'];
        }
    }
}