<?php
declare(strict_types=1);

namespace Internetgalerie\IgWidgets\Widgets\Provider;

use TYPO3\CMS\Backend\Routing\UriBuilder;
use TYPO3\CMS\Belog\Domain\Model\Constraint;
use TYPO3\CMS\Belog\Domain\Repository\LogEntryRepository;
use TYPO3\CMS\Core\Authentication\BackendUserAuthentication;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class SysHistoryProvider implements TableProviderInterface
{
    /**
     * @var AdministrationRepository
     */
    protected $administrationRepository;

    /**
     * @var int Current page id
     */
    protected $pageUid = 0;

    /**
     * @var int
     */
    private $limit;

    /**
     * @var int
     */
    private $days = 0;

    /**
     * @var array
     */
    private $entries = null;

    public function __construct(int $limit, int $days, int $pageUid)
    {
        $this->limit = $limit ?: 6;
        $this->days = $days;
        $this->pageUid = $pageUid;
    }
    
    public function getHeader(): array
    {
        return [];
    }
    public function getFooter(): array
    {
        return [];
    }
    
    public function getEntries(  ): array
    {
        $this->initStat();
        return $this->entries;
    }

    public function getLimit(): int
    {
        return $this->limit;
    }

    public function getDays(): int
    {
        return $this->days;
    }

    public function getPageUid(): int
    {
        return $this->pageUid;
    }



    public function initStat( )
    {
        if($this->entries !== null ) {
            return;
        }
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('sys_history');
        $this->entries = [];

        //$andWhere = $this->days > 0  ? ' AND tstamp> UNIX_TIMESTAMP()- ' . (int) ( 86400 * $this->days ) : '';
        /*
        $constraint = GeneralUtility::makeInstance(Constraint::class);
        $constraint->setNumber( $this->limit );
        $constraint->setUserOrGroup( 'us-' . $this->getBackendUser()->user['uid']);
        if(  $this->days > 0 ) {
            $constraint->setStartTimestamp( time() - 86400 * $this->days );
        }
        $constraint->setAction(1);
       
        $this->logEntryRepository = GeneralUtility::makeInstance( LogEntryRepository::class );
        $logEntries= $this->logEntryRepository->findByConstraint($constraint);
        $this->entries = [];

        foreach ($logEntries as $entry) {
            $this->entries[] = $entry;
        }
        return;
        */
        $sql = "SELECT group_concat(tablename) AS tables, max(tstamp) AS tstamp,CASE WHEN tablename='pages' THEN recuid ELSE (SELECT pid FROM tt_content WHERE tt_content.uid=recuid) END AS pageid FROM sys_history WHERE tablename IN ('pages','tt_content') AND userid = " . $this->getBackendUser()->user['uid']  . ' GROUP BY pageid ORDER BY tstamp DESC LIMIT ' . (int) $this->limit;
        $stmt = $conn->prepare($sql);
        $res = $stmt->executeQuery([]);

        while( $row = $res->fetchAssociative() ) {
            $pid = (int)$row['pageid'];
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('pages');
            $page = $queryBuilder
                ->select('*')
                ->from('pages')
                ->where(
                    $queryBuilder->expr()->eq('uid', $pid)
                )
                ->executeQuery()
                ->fetchAssociative();
            if($page) {
                $detail = $page['title'] .' ['.$row['pageid'].']';
            
                $uriBuilder = GeneralUtility::makeInstance(UriBuilder::class);
                $url = (string)$uriBuilder->buildUriFromRoute('web_layout', ['id' => $row['pageid']]);
                $link= 'top.jump(' . GeneralUtility::quoteJSvalue($url) . ",'web_layout','web', " . (int) $row['pageid'] . ');';


                $this->entries[] = array_merge(
                    $row,
                    [
                        'detail' => $detail,
                        'link' => $link,
                        'page' => $page,
                    ]
                );
            }
        }
        
    }
    public function setOptions( array $options)
    {
        if(isset($options['days']) ) {
            $this->days = (int) $options['days'];
        }
    }
    protected function getBackendUser(): BackendUserAuthentication
    {
        return $GLOBALS['BE_USER'];
    }

}
