<?php
declare(strict_types=1);

namespace Internetgalerie\IgWidgets;

use Internetgalerie\IgWidgets\Widgets\TableWidget;
use Internetgalerie\IgWidgets\Widgets\LineChartWidget;
use Internetgalerie\IgWidgets\Widgets\Provider\FormlogProvider;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
use Symfony\Component\DependencyInjection\Reference;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Backend\View\BackendViewFactory;

return function (ContainerConfigurator $configurator, ContainerBuilder $containerBuilder) {
    // check if formlog is available
    if (class_exists(FormlogProvider::class)) {
        $services = $configurator->services();

        $services->set('dashboard.widget.formlog-line-chart')
                 ->class(LineChartWidget::class)
                 ->arg('$dataProvider', new Reference(FormlogProvider::class))
                 ->arg('$backendViewFactory', new Reference(BackendViewFactory::class))
            /*->arg('$options', [
            
                'template' => 'IgWidgets/Widget/FormlogWidget',
                'days' => 365,
            ])
            */
                 ->tag('dashboard.widget', [
                     'identifier' => 'ig_widgets-formlog-line-chart',
                     'groupNames' => 'frontend',
                     'title' => 'LLL:EXT:ig_widgets/Resources/Private/Language/locallang.xlf:widgets.ig_widgets-formlog.title',
                     'description' => 'LLL:EXT:ig_widgets/Resources/Private/Language/locallang.xlf:widgets.ig_widgets-formlog.description',
                     'iconIdentifier' => 'content-widget-chart-pie',
                     'height' => 'medium',
                 ])
            ;
    }
};