<?php

namespace Internetgalerie\IgWidgets\Widgets;

use Internetgalerie\IgWidgets\Utility\CookieUtility;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Dashboard\Widgets\AdditionalCssInterface;
use TYPO3\CMS\Dashboard\Widgets\AdditionalJavaScriptInterface;
use TYPO3\CMS\Dashboard\Widgets\ButtonProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetConfigurationInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetInterface;
use TYPO3\CMS\Backend\View\BackendViewFactory;
use TYPO3\CMS\Dashboard\Widgets\RequestAwareWidgetInterface;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Core\Information\Typo3Version;

class CookieHelperWidget implements WidgetInterface, RequestAwareWidgetInterface, AdditionalJavaScriptInterface, AdditionalCssInterface
{
    public function __construct(
        private readonly WidgetConfigurationInterface $configuration,
        private readonly BackendViewFactory $backendViewFactory,
        private readonly array $options = []
    ) {
    }

    public function setRequest(ServerRequestInterface $request): void
    {
        $this->request = $request;
    }

    public function getJsFiles(): array
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);

        $typo3Version = new Typo3Version();
        if ($typo3Version->getMajorVersion() > 11) {
            $pageRenderer->loadJavaScriptModule('@Internetgalerie/IgWidgets/daterangepicker.js');
            $pageRenderer->loadJavaScriptModule('@Internetgalerie/IgWidgets/select2/select2.js');
        } else {
            $pageRenderer->loadRequireJsModule('TYPO3/CMS/IgWidgets/daterangepicker');
            $pageRenderer->loadRequireJsModule('TYPO3/CMS/IgWidgets/select2/select2');
        }

        return [
            'EXT:ig_widgets/Resources/Public/JavaScript/CookieHelperWidget.js'
        ];
    }

    public function getCssFiles(): array
    {
        return [
            'EXT:ig_widgets/Resources/Public/Css/daterangepicker.css',
            'EXT:ig_widgets/Resources/Public/Css/CookieHelperWidget.css',
            'EXT:ig_widgets/Resources/Public/Css/select2/select2.min.css',
        ];
    }

    public function renderWidgetContent(): string
    {
        $view = $this->backendViewFactory->create($this->request, ['typo3/cms-dashboard', 'internetgalerie/ig-widgets']);

        $this->cookieUtility = GeneralUtility::makeInstance(CookieUtility::class);

        $view->assignMultiple(
            [
                'options' => $this->options,
                'configuration' => $this->configuration,
                'defaultCookies' => $this->cookieUtility->getDefault(),
                'autoCookies' => $this->cookieUtility->getAuto(),
                'autoCookiesConf' => $this->cookieUtility->getAutoConf(),
            ]
        );
        return $view->render($this->options['template']);
    }
    /**
     * This method returns the options of the widget as set in the registration.
     */
    public function getOptions(): array
    {
        return $this->options;
    }
}
