<?php

declare(strict_types=1);

namespace Internetgalerie\IgWidgets\Widgets\Provider;


use TYPO3\CMS\Backend\Routing\UriBuilder;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\VersionNumberUtility;
use TYPO3\CMS\Dashboard\Widgets\ButtonProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\ElementAttributesInterface;

/**
 * Provides a button to indexed search for the footer 
 */
class IndexedSearchButtonProvider implements ButtonProviderInterface, ElementAttributesInterface
{

    public function __construct(private readonly string $title, private readonly string $target = '') {}

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getLink(): string
    {
        return '';
    }

    public function getTarget(): string
    {
        return $this->target;
    }

    public function getElementAttributes(): array
    {
        if (!ExtensionManagementUtility::isLoaded('indexed_search')) {
            return [];
        }

        if (VersionNumberUtility::convertVersionNumberToInteger(VersionNumberUtility::getNumericTypo3Version()) >= 13000000) {
            $module = 'manage_search_index';
        } else {
            $module = 'web_IndexedSearchIsearch';
        }
        return [
            'data-dispatch-action' => 'TYPO3.ModuleMenu.showModule',
            //'data-dispatch-args-list' => 'manage_search_index,id=20'
            'data-dispatch-args-list' =>  $module . ','
                . http_build_query(['id' => '20', 'action' => 'index']),
            //    . http_build_query(['action' => 'statisticDetails']),
            //'data-dispatch-args-list' => 'manage_search-index,&'
            //. http_build_query(['id' => '20', 'action' => 'statisticDetails']),
            // 'data-page-hash-required' => '1',
        ];
    }

    public function getHasAccess(): bool
    {
        return $GLOBALS['BE_USER']->check('modules', 'manage_search_index');
    }

}
