<?php

namespace Internetgalerie\IgWidgets\Utility;

use TYPO3\CMS\Core\SingletonInterface;

class CookieUtility implements SingletonInterface
{

    protected $baseName = 'igwidgets_';
    protected $defaultCookieNames = ['igwidgets_default_from_to'];

    protected $relevantCookies = [];
    protected $defaultCookies = [];
    protected $autoCookies = [];
    protected $autoCookiesConf = [];
    public function __construct()
    {
        $this->init();
    }
    public function init()
    {
        foreach ($_COOKIE as $key => $cookieValue) {
            if (str_contains($key, $this->baseName)) {
                if (!str_contains($key, '_conf')) {
                    if (in_array($key, $this->defaultCookieNames)) {
                        $this->defaultCookies[$key] = explode(' - ', $cookieValue);
                    } else {
                        $this->autoCookies[$key] = $cookieValue;
                    }
                } else {
                    $this->autoCookiesConf[str_replace($this->baseName, '', $key)] = (array) json_decode($cookieValue);
                }
                $this->relevantCookies[$key] = $cookieValue;
            }
        }
        $this->sortArrays();
    }
    public function addDefaultCookieNames($name)
    {
        if (!in_array($this->baseName . $name, $this->defaultCookieNames)) {
            $this->defaultCookieNames[] = $this->baseName . $name;
        }
        $this->init();
    }
    public function get($find)
    {
        if (!str_contains($find, $this->baseName)) {
            $find = $this->baseName . $find;
        }
        if ($this->relevantCookies[$find] ?? false) {
            return $this->relevantCookies[$find];
        }
        return false;
    }
    public function getRelevant()
    {
        return $this->relevantCookies;
    }
    public function getDefault()
    {
        return $this->defaultCookies;
    }
    public function getAuto()
    {
        return $this->autoCookies;
    }
    public function getAutoConf()
    {
        return $this->autoCookiesConf;
    }
    public function setBaseName($name){
        $this->baseName = $name;
    }
    public function set($name, $value = 0)
    {
        if (!($_COOKIE[$this->baseName . $name] ?? false)) {
            if (is_array($value)) {
                $value = json_encode($value);
            }
            setcookie($this->baseName . $name, $value);
        }
        $this->init();
    }
    public function sortArrays()
    {
        ksort($this->relevantCookies);
        ksort($this->defaultCookies);
        ksort($this->autoCookies);
        ksort($this->autoCookiesConf);
    }
}
