<?php
declare(strict_types=1);

namespace Internetgalerie\IgWidgets\Widgets\Provider;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Dashboard\WidgetApi;
use TYPO3\CMS\Dashboard\Widgets\ChartDataProviderInterface;
use TYPO3\CMS\Core\Localization\LanguageService;

class FormlogProvider implements TableProviderInterface, ChartDataProviderInterface
{
    /**
     * @var int Current page id
     */
    protected $pageUid = 0;

    /**
     * @var int
     */
    private $limit;

    /**
     * @var int
     */
    private $days = 0;

    /**
     * @var array
     */
    private $entries = null;

    public function __construct(int $limit, int $days, int $pageUid)
    {
        $this->limit = $limit ?: 12;
        $this->days = $days;
        $this->pageUid = $pageUid;
    }
    
    public function getHeader(): array
    {
        return [];
    }
    public function getFooter(): array
    {
        $this->initStat(SORT_DESC);
        $total = 0;
        foreach( $this->entries as $row ) {
            $total += $row['count'];
        }
        
        return [
            'title' => 'Anzahl Stichworte',
            'count' => $total,
        ];
    }
    
    public function getEntries(  ): array
    {
        $items=[];
        //$queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igshop2_domain_model_product');
        $this->initStat(SORT_DESC);
        return $this->entries;
        $limit=$this->limit;
        foreach($this->entries as $row) {
            $limit--;
            if(!$limit ) {
                break;
            }
                
            $items[] = [
                'title' => $row['word'],
                'count' => $row['count'],
            ];
        }
        return $items;
    }

    public function getLimit(): int
    {
        return $this->limit;
    }

    public function getDays(): int
    {
        return $this->days;
    }

    public function getPageUid(): int
    {
        return $this->pageUid;
    }



    public function initStat($orderByDirection = SORT_DESC): void
    {
        if($this->entries !== null ) {
            return;
        }
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_formlog_entries');
        $schemaManager = $conn->createSchemaManager();//$conn->getSchemaManager();
        if ($schemaManager->tablesExist(['tx_igformlog_entries']) == true) {
            $tablename = 'tx_igformlog_entries';
        } elseif ($schemaManager->tablesExist(['tx_formlog_entries']) == true) {
            $tablename = 'tx_formlog_entries';
        } else {
            return;
        }
            
        $sql = 'SELECT SUM(1) AS total,EXTRACT( YEAR_MONTH FROM FROM_UNIXTIME(crdate)) AS yearmonth FROM ' . $tablename . ' GROUP BY yearmonth  ORDER BY yearmonth' . ( $orderByDirection==SORT_DESC ? ' DESC' : '') .' LIMIT '. (int) $this->limit;
        $stmt = $conn->prepare($sql);
        $res = $stmt->executeQuery([]);
        $this->entries = [];
        while($row = $res->fetchAssociative() ) {
            $year = (int) ($row['yearmonth']/100);
            $month = (int) ($row['yearmonth']%100);
            $this->entries[] = [
                'title' => $year .'-' . ($month<19 ? '0' : '') . $month,
                'count' => $row['total'],
            ];
        }
    }

    public function setOptions(array $options): void
    {
        if(isset($options['days']) ) {
            $this->days = (int) $options['days'];
        }
    }
    /**
     * @inheritDoc
     */
    public function getChartData(): array
    {
        $this->initStat(SORT_DESC);
        $labels=[];
        $data=[];
        foreach($this->entries as $row) {
            $labels[] = $row['title'];
            $data[] = $row['count'];

        }
        return [
            'labels' => array_reverse($labels),
            'datasets' => [
                [
                    //'backgroundColor' => WidgetApi::getDefaultChartColors(),
                    'borderColor' => WidgetApi::getDefaultChartColors()[0],
                    'label' => $this->getLanguageService()->sL('LLL:EXT:ig_widgets/Resources/Private/Language/locallang.xlf:widgets.ig_widgets-formlog.chart.legend'),
                    'data' => array_reverse($data),
                    'fill' => false,

                ]
            ],
        ];
    }

    protected function getLanguageService(): LanguageService
    {
        return $GLOBALS['LANG'];
    }

}
