require(['jquery', 'TYPO3/CMS/IgWidgets/daterangepicker', 'TYPO3/CMS/IgWidgets/select2/select2'], function($, daterangepicker) {
    var isLoaded = false;
    //not firefox
    $(window).on('load', function() {
        $('select.cookie').select2();
        isLoaded = true;
    });

    // on load does not work in firefox
    $(document).on('mouseover', '.cookie-helper-container', function() {
        if (isLoaded == false) {
            $('select.cookie').select2();
            isLoaded = true;
        }
    });

    $(document).on('change', '.dashboard-item .cookie-helper-container .cookie', function(e) {
        var name = $(e.target).data('name');
        document.cookie = 'igwidgets_' + name + '=' + $(e.target).val();
    });

    $(document).on('click', '.dashboard-item .addFilter', function(e) {
        location.reload();
    });

    $(document).on('click', '.dashboard-item .deleteFilter', function(e) {
        $('.dashboard-item .cookie').each(function(index) {
            var name = $(this).data('name');
            document.cookie = 'igwidgets_' + name + '=';
            if (document.cookie.indexOf('igwidgets_' + name + '_conf=')) {
                document.cookie = 'igwidgets_' + name + '_conf=';
            }
        });
        document.cookie = 'igwidgets_default_from_to=';
        location.reload();
    });

    $(document).on('focus', '.dashboard-item #date-from-to', function(e) {
        $(this).daterangepicker({
            locale: {
                format: 'DD.MM.YYYY'
            }
        });
        $(this).on('apply.daterangepicker', function(ev, picker) {
            document.cookie = 'igwidgets_default_from_to=' + picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format('YYYY-MM-DD');
        });
    });
});
