<?php
declare(strict_types=1);

namespace Internetgalerie\IgWidgets\Widgets\Provider;

use TYPO3\CMS\Beuser\Domain\Repository\BackendUserRepository;
use TYPO3\CMS\Beuser\Domain\Repository\BackendUserSessionRepository;
use TYPO3\CMS\Dashboard\Widgets\ListDataProviderInterface;

class UsersOnlineDataProvider implements TableProviderInterface
{
    /**
     * @var int Current page id
     */
    protected $pageUid = 0;

    /**
     * @var int
     */
    private $limit = 10;
    /**
     * @var int
     */
    private $days = 0;

    /**
     * @var BackendUserRepository
     */
    private $backendUserRepository;
    /**
     * @var BackendUserSessionRepository
     */
    private $backendUserSessionRepository;

    public function __construct(BackendUserRepository $backendUserRepository, BackendUserSessionRepository $backendUserSessionRepository)
    {
        $this->backendUserRepository = $backendUserRepository;
        $this->backendUserSessionRepository = $backendUserSessionRepository;
    }
    public function getLimit(): int
    {
        return $this->limit;
    }

    public function getHeader(): array
    {
        return [];
    }
    public function getFooter(): array
    {
        return [];
    }
    
    public function getEntries(  ): array
    {
        $this->initStat();
        return $this->entries;
    }
    public function initStat( )
    {
        $onlineUsersAndSessions = [];
        $onlineUsers = $this->backendUserRepository->findOnline();
        if (!empty($onlineUsers)) {
            foreach ($onlineUsers as $onlineUser) {
                $onlineUsersAndSessions[] = [
                    'backendUser' => $onlineUser,
                'sessions' => $this->backendUserSessionRepository->findByBackendUser($onlineUser)
                ];
            }
        }

        $this->entries = $onlineUsersAndSessions;
    }
    public function setOptions( array $options)
    {
    }

    public function getDays(): int
    {
        return $this->days;
    }
    public function getPageUid(): int
    {
        return $this->pageUid;
    }

}
