<?php

namespace Internetgalerie\IgWidgets\Widgets;

use Internetgalerie\IgWidgets\Widgets\Provider\TableProviderInterface;
use TYPO3\CMS\Backend\Routing\UriBuilder;
use TYPO3\CMS\Core\Authentication\BackendUserAuthentication;
use TYPO3\CMS\Core\Routing\RouteNotFoundException;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Dashboard\Widgets\AdditionalCssInterface;
use TYPO3\CMS\Dashboard\Widgets\ButtonProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\ListDataProviderInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetConfigurationInterface;
use TYPO3\CMS\Dashboard\Widgets\WidgetInterface;
use TYPO3\CMS\Backend\View\BackendViewFactory;
use TYPO3\CMS\Dashboard\Widgets\RequestAwareWidgetInterface;
use Psr\Http\Message\ServerRequestInterface;
//use TYPO3\CMS\Dashboard\Widgets\ChartDataProviderInterface;

class TableWidget implements WidgetInterface, RequestAwareWidgetInterface, AdditionalCssInterface
{

    private ServerRequestInterface $request;

    public function __construct(
        private readonly WidgetConfigurationInterface $configuration,
        private readonly TableProviderInterface $dataProvider,
        private readonly BackendViewFactory $backendViewFactory,
        private readonly ?ButtonProviderInterface $buttonProvider,
        private readonly array $options = []
    ) {
        /*
        $this->options =  array_merge(
            [
                'template' => 'Widgets/IgWidgetsTableWidget',
            ],
            $options
        );
        */
    }

    public function setRequest(ServerRequestInterface $request): void
    {
        $this->request = $request;
    }

    public function getCssFiles(): array
    {
        return [
            'EXT:ig_widgets/Resources/Public/Css/tableWidget.css',
        ];
    }

    public function renderWidgetContent(): string
    {
        
        $view = $this->backendViewFactory->create($this->request, ['typo3/cms-dashboard', 'internetgalerie/ig-widgets']);
        $this->dataProvider->setOptions($this->options);

        $pageUid = $this->dataProvider->getPageUid();
        $pageUid = $this->dataProvider->getPageUid();
        //$url='/typo3/index.php?route=%2Fmodule%2Fweb%2FIndexedSearchIsearch';
        $uriBuilder = GeneralUtility::makeInstance(UriBuilder::class);
        if ($this->options['routeName'] ?? false) {
            try {
                $url = (string)$uriBuilder->buildUriFromRoute($this->options['routeName'], ['id' => $pageUid]);
                $detailAction = 'top.jump(' . GeneralUtility::quoteJSvalue($url) . ',' . GeneralUtility::quoteJSvalue($this->options['routeName']) . ',' . GeneralUtility::quoteJSvalue('web') . ', ' . (int)$pageUid . ');';
            } catch(RouteNotFoundException $e) {
                $detailAction = null;
                return '';
            }
        } else {
            $detailAction = null;
        }
        //$url = (string)$uriBuilder->buildUriFromRoute('module/web/list', []);
        //$url = (string)$uriBuilder->buildUriFromRoute('system_reports', []);

        $view->assignMultiple(
            [
            'limit' => $this->dataProvider->getLimit(),
            'entries' => $this->dataProvider->getEntries(),
            'footer' => $this->dataProvider->getFooter(),
            'options' => $this->options,
            'detailAction' => $detailAction,
            'days' => $this->dataProvider->getDays(),
            'button' => $this->buttonProvider,
            'configuration' => $this->configuration,
             'dateFormat' => $GLOBALS['TYPO3_CONF_VARS']['SYS']['ddmmyy'],
            'timeFormat' => $GLOBALS['TYPO3_CONF_VARS']['SYS']['hhmm'],
            ]
        );
        return $view->render($this->options['template']);
    }

    /**
     * This method returns the options of the widget as set in the registration.
     */
    public function getOptions(): array
    {
        return $this->options;
    }
}