<?php

if( in_array('force',$argv)) {
    $debug = 0;
}else{
    $debug = 1;
}

$root = glob('fileadmin/layout/css/*');

if(!$root){
    exit;
}

foreach ($root as $entry) {
    if(is_dir($entry)){
        $folder = glob($entry.'/*.scss');
        foreach ($folder as $file) {
            lessToScssReplacement($file,$debug);
        }
    } else{
        if(pathinfo($entry, PATHINFO_EXTENSION) == 'scss'){
            lessToScssReplacement($entry,$debug);
        }
    }
    
}
function lessToScssReplacement($file,$debug){

    $match = '';
    
    // every line in $filterArray is replaced with a line in $matchReplace
    $filterArray = [
        '/\.media-queries\([^\{]/m',
        '/\#globale-anpassungen\(\).*\{/m',
        '/\{#globale-anpassungen\},/m',
        '/\@include ul_background-color\;/m',
        '/(\#|\.)(.*)\(\).*\{/m',
        '/\.media-queries\(\{(\#|\.)(.*)\},(.*)\)\;/m',
        '/\#font-sizes(.*)\([^0]/m',
        '/\#font-sizes(.*)(\d\.\d)/m',
        '/\#font-sizes\,/m',
        '/\@mixin calcFontSize\((.*)\)\,/m',
        '/\.calcFontSize\((.*)\)\,/m',
        '/(.*\/100)\,/m',
        '/\@.*\when\s*\((.*)\=(.*)\).*\{/m',
        '/\@.*\when not.*\((.*)\=(.*)\).*\{/m'
    ];
    // $1,$2,$3 are replaced with $match[0][1], [0][2], [0][3]
    $matchReplace = [
        '@include globale-anpassungen(' . "\n",
        '@mixin globale-anpassungen($seitenabstand:"",$verticalelementabstand:"",$l2_seitenabstand:"",$verticalelementabstand_klein:""){' . "\n",
        '', //to remove line altogether
        '', //to remove line altogether
        '@mixin $2($seitenabstand:"",$verticalelementabstand:""){' . "\n",
        '@include $2($3);' . "\n",
        '@mixin font-sizes(' . "\n",
        '@include font-sizes($2);' . "\n",
        '@include font-sizes(1);' . "\n",
        '@include calcFontSize($1);',
        '@include calcFontSize($1);',
        '$1;',
        '@if($1 == $2){' . "\n",
        '@else{' . "\n",
    ];
    $reading = fopen($file, 'r');
    if($debug === 0){
        $writing = fopen($file.'.tmp', 'w');
    } else {
        echo 'Changes: '. $file."\n";
    }
    if ($reading) {
        while (($line = fgets($reading)) !== false) {
            $hasMatch = false;
            foreach ($filterArray as $key => $filter) {
                preg_match_all($filter, $line, $match, PREG_SET_ORDER, 0);
                if($match && $hasMatch == false){
                    $newLine = setNewLine($matchReplace[$key], $match);
                    $hasMatch = true;
                }
                if($debug && $match){
                    echo 'Filter: '.$filter."\n";
                    echo 'From: '.$line."\n";
                    echo 'To:         '.$newLine."\n\n";
                }
            }
            if($hasMatch == true){
                $line = $newLine;
            }
            if($debug === 0){
                fputs($writing, $line);
            }
        }
    
        fclose($reading);
        if($debug === 0){
            fclose($writing);
            unlink($file);
            rename($file.'.tmp', $file);
        }
    }
}

function setNewLine($line, $match){
    foreach ($match[0] as $key => $value) {
        $line = str_replace('$'.$key,$value,$line);
    }
    return $line;
}