<?php
declare(strict_types = 1);

namespace TYPO3\igconfig\PageTitle;

use GeorgRinger\News\Domain\Model\News;
use TYPO3\CMS\Core\PageTitle\AbstractPageTitleProvider;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * Generate page title based on properties of the news model
 */
class NewsTitleProvider extends AbstractPageTitleProvider
{
    private const DEFAULT_PROPERTIES = 'title';
    private const DEFAULT_GLUE = '" "';

    /**
     * @param News $news
     * @param array $configuration
     */
    public function setTitleByNews(News $news, array $configuration = []): void
    {
        $title = '';
        $fields = GeneralUtility::trimExplode(',', $configuration['properties'] ?? self::DEFAULT_PROPERTIES, true);

        // do not set the (seo/browset) page title if noPageTitle is set
        if ($configuration['noPageTitle'] == 1) {
            return;
        }

        foreach ($fields as $field) {
            $getter = 'get' . ucfirst($field);
            $value = $news->$getter();
            if ($value) {
                $title = $value;
                break;
            }
        }
        if ($title) {
            $this->title = $title;
        }
    }

    public function setTitle(string $title): void
    {
        $this->title = $title;
    }
}
