<?php
declare(strict_types = 1);

namespace TYPO3\igconfig\PageTitle;

use GeorgRinger\News\Domain\Repository\NewsRepository;
use TYPO3\CMS\Core\PageTitle\AbstractPageTitleProvider;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * This class will take care of the seo title that can be set in the backend
 * @internal this class is not part of TYPO3's Core API.
 */
class IgconfigPageTitleProvider extends AbstractPageTitleProvider
{

    public function getTitle(): string
    {
        //     $get = $this->request->getQueryParams()['tx_news_pi1'] ?? [];
        $get = $_GET['tx_news_pi1'] ?? [];
        if (is_array($get) && isset($get['news']) && $get['news'] > 0) {
            // is doctrine faster? or is object cached for detail view
            $newsRepository = GeneralUtility::makeInstance(NewsRepository::class);
            $news = $newsRepository->findByUid($get['news']);
            if($news) {
                return (string)$news->getTitle();
            }
        }
        return parent::getTitle();
    }
}
