<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Anrede extends AbstractEntity
{
    /**
     * anName
     *
     * @var string
     */
    protected $anName = '';

    /**
     * hideInLetterAddress
     *
     * @var bool
     */
    protected $hideInLetterAddress = false;

    /**
     * letterFormalDe
     *
     * @var string
     */
    protected $letterFormalDe = '';

    /**
     * letterFormalFr
     *
     * @var string
     */
    protected $letterFormalFr = '';

    /**
     * letterFormalIt
     *
     * @var string
     */
    protected $letterFormalIt = '';

    /**
     * letterInformalDe
     *
     * @var string
     */
    protected $letterInformalDe = '';

    /**
     * letterInformalFr
     *
     * @var string
     */
    protected $letterInformalFr = '';

    /**
     * letterInformalIt
     *
     * @var string
     */
    protected $letterInformalIt = '';
    
    /**
     * anNameFr
     *
     * @var string
     */
    protected $anNameFr = '';

    /**
     * anNameIt
     *
     * @var string
     */
    protected $anNameIt = '';

    public function __toString(): string
    {
        return $this->getAnName();
    }



    /**
     * Returns the hideInLetterAddress
     *
     * @return bool
     */
    public function getHideInLetterAddress()
    {
        return $this->hideInLetterAddress;
    }

    /**
     * Sets the hideInLetterAddress
     *
     * @param bool $hideInLetterAddress
     */
    public function setHideInLetterAddress($hideInLetterAddress): void
    {
        $this->hideInLetterAddress = $hideInLetterAddress;
    }

    
    /**
     * Returns the anName
     *
     * @return string
     */
    public function getAnName()
    {
        return $this->anName;
    }

    /**
     * Sets the anName
     *
     * @param string $anName
     */
    public function setAnName($anName): void
    {
        $this->anName = $anName;
    }

    /**
     * Returns the letterFormalDe
     *
     * @return string
     */
    public function getLetterFormalDe()
    {
        return $this->letterFormalDe;
    }

    /**
     * Sets the letterFormalDe
     *
     * @param string $letterFormalDe
     */
    public function setLetterFormalDe($letterFormalDe): void
    {
        $this->letterFormalDe = $letterFormalDe;
    }

    /**
     * Returns the letterFormalFr
     *
     * @return string
     */
    public function getLetterFormalFr()
    {
        return $this->letterFormalFr;
    }

    /**
     * Sets the letterFormalFr
     *
     * @param string $letterFormalFr
     */
    public function setLetterFormalFr($letterFormalFr): void
    {
        $this->letterFormalFr = $letterFormalFr;
    }

    /**
     * Returns the letterFormalIt
     *
     * @return string
     */
    public function getLetterFormalIt()
    {
        return $this->letterFormalIt;
    }

    /**
     * Sets the letterFormalIt
     *
     * @param string $letterFormalIt
     */
    public function setLetterFormalIt($letterFormalIt): void
    {
        $this->letterFormalIt = $letterFormalIt;
    }








    /**
     * Returns the letterInformalDe
     *
     * @return string
     */
    public function getLetterInformalDe()
    {
        return $this->letterInformalDe;
    }

    /**
     * Sets the letterInformalDe
     *
     * @param string $letterInformalDe
     */
    public function setLetterInformalDe($letterInformalDe): void
    {
        $this->letterInformalDe = $letterInformalDe;
    }

    /**
     * Returns the letterInformalFr
     *
     * @return string
     */
    public function getLetterInformalFr()
    {
        return $this->letterInformalFr;
    }

    /**
     * Sets the letterInformalFr
     *
     * @param string $letterInformalFr
     */
    public function setLetterInformalFr($letterInformalFr): void
    {
        $this->letterInformalFr = $letterInformalFr;
    }

    /**
     * Returns the letterInformalIt
     *
     * @return string
     */
    public function getLetterInformalIt()
    {
        return $this->letterInformalIt;
    }

    /**
     * Sets the letterInformalIt
     *
     * @param string $letterInformalIt
     */
    public function setLetterInformalIt($letterInformalIt): void
    {
        $this->letterInformalIt = $letterInformalIt;
    }


    /**
     * Returns the anNameFr
     *
     * @return string
     */
    public function getAnNameFr()
    {
        return $this->anNameFr;
    }

    /**
     * Sets the anNameFr
     *
     * @param string $anNameFr
     */
    public function setAnNameFr($anNameFr): void
    {
        $this->anNameFr = $anNameFr;
    }

    /**
     * Returns the anNameIt
     *
     * @return string
     */
    public function getAnNameIt()
    {
        return $this->anNameIt;
    }

    /**
     * Sets the anNameIt
     *
     * @param string $anNameIt
     */
    public function setAnNameIt($anNameIt): void
    {
        $this->anNameIt = $anNameIt;
    }
    public function getBriefanrede(string $lang): string
    {
        return $this->getLetterFormal($lang);
    }
    
    /**
     * Salutaion for Letter (formal: e.g. Sie)
     */
    public function getLetterFormal(string $lang): string
    {
        if ($lang == 'F' || $lang == 'FR' || $lang == 'fr') {
            return $this->letterFormalFr;
        }
        if ($lang == 'I' || $lang == 'IT' || $lang == 'it') {
            return $this->letterFormalIt;
        }
        return $this->letterFormalDe;
    }

    /**
     * Salutaion for Letter (informal: e.g Du)
     */
    public function getLetterInformal(string $lang): string
    {
        if ($lang == 'F' || $lang == 'FR' || $lang == 'fr') {
            return $this->letterInformalFr;
        }
        if ($lang == 'I' || $lang == 'IT' || $lang == 'it') {
            return $this->letterInformalIt;
        }
        return $this->letterInformalDe;
    }


    /**
     * Returns the Briefanrede
     *
     * @param string $lang
     * @return string
     */
    public function getAnrede($lang)
    {
        if ($lang == 'F' || $lang == 'FR' || $lang == 'fr') {
            return $this->anNameFr;
        }
        if ($lang == 'I' || $lang == 'IT' || $lang == 'it') {
            return $this->anNameIt;
        }
        return $this->anName;
    }
}
