<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Api extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * verband
     *
     * @var Verband
     */
    protected $verband = null;


    /**
     * apiKey
     *
     * @var string
     */
    protected $apiKey = '';

    /**
     * acl
     *
     * @var string
     */
    protected $acl = '';

    public function __toString(): string
    {
        $str = $this->getName();
        return $str;
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the verband
     *
     * @return Verband
     */
    public function getVerband()
    {
        return $this->verband;
    }

    /**
     * Sets the verband
     */
    public function setVerband(Verband $verband): void
    {
        $this->verband = $verband;
    }

    /**
     * Returns the apiKey
     *
     * @return string
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }

    /**
     * Sets the apiKey
     *
     * @param string $apiKey
     */
    public function setApiKey($apiKey): void
    {
        $this->apiKey = $apiKey;
    }

    /**
     * Returns the acl
     *
     * @return string
     */
    public function getAcl()
    {
        return $this->acl;
    }

    /**
     * Sets the acl
     *
     * @param string $acl
     */
    public function setAcl($acl): void
    {
        $this->acl = $acl;
    }
}
