<?php

declare(strict_types=1);

namespace Internetgalerie\IgsCrm\Domain\Model;

use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Card extends AbstractEntity
{
    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * period
     *
     * @var string
     */
    protected $period = '';

    /**
     * field1Label
     *
     * @var string
     */
    protected $field1Label = '';

    /**
     * field1Value
     *
     * @var string
     */
    protected $field1Value = '';

    /**
     * field2Label
     *
     * @var string
     */
    protected $field2Label = '';

    /**
     * field2Value
     *
     * @var string
     */
    protected $field2Value = '';

    /**
     * field3Label
     *
     * @var string
     */
    protected $field3Label = '';

    /**
     * field3Value
     *
     * @var string
     */
    protected $field3Value = '';

    /**
     * backText
     *
     * @var string
     */
    protected $backText = '';

    /**
     * backgroundImageOdd
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    protected ?FileReference $backgroundImageOdd = null;

    /**
     * backgroundImageEven
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    protected ?FileReference $backgroundImageEven = null;

    /**
     * letterTitle
     *
     * @var string
     */
    protected $letterTitle = '';

    /**
     * letterText
     *
     * @var string
     */
    protected $letterText = '';

    /**
     * letterNewTitle
     *
     * @var string
     */
    protected $letterNewTitle = '';

    /**
     * letterNewText
     *
     * @var string
     */
    protected $letterNewText = '';

    /**
     * verband
     *
     * @var Verband
     */
    protected $verband = null;


    protected bool $enableWallet = false;


    protected string $letterClosing = '';

    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     */
    public function setTitle($title): void
    {
        $this->title = $title;
    }

    /**
     * Returns the period
     *
     * @return string
     */
    public function getPeriod()
    {
        return $this->period;
    }

    /**
     * Sets the period
     *
     * @param string $period
     */
    public function setPeriod($period): void
    {
        $this->period = $period;
    }

    /**
     * Returns the field1Label
     *
     * @return string
     */
    public function getField1Label()
    {
        return $this->field1Label;
    }

    /**
     * Sets the field1Label
     *
     * @param string $field1Label
     */
    public function setField1Label($field1Label): void
    {
        $this->field1Label = $field1Label;
    }

    /**
     * Returns the field1Value
     *
     * @return string
     */
    public function getField1Value()
    {
        return $this->field1Value;
    }

    /**
     * Sets the field1Value
     *
     * @param string $field1Value
     */
    public function setField1Value($field1Value): void
    {
        $this->field1Value = $field1Value;
    }

    /**
     * Returns the field2Label
     *
     * @return string
     */
    public function getField2Label()
    {
        return $this->field2Label;
    }

    /**
     * Sets the field2Label
     *
     * @param string $field2Label
     */
    public function setField2Label($field2Label): void
    {
        $this->field2Label = $field2Label;
    }

    /**
     * Returns the field2Value
     *
     * @return string
     */
    public function getField2Value()
    {
        return $this->field2Value;
    }

    /**
     * Sets the field2Value
     *
     * @param string $field2Value
     */
    public function setField2Value($field2Value): void
    {
        $this->field2Value = $field2Value;
    }

    /**
     * Returns the field3Label
     *
     * @return string
     */
    public function getField3Label()
    {
        return $this->field3Label;
    }

    /**
     * Sets the field3Label
     *
     * @param string $field3Label
     */
    public function setField3Label($field3Label): void
    {
        $this->field3Label = $field3Label;
    }

    /**
     * Returns the field3Value
     *
     * @return string
     */
    public function getField3Value()
    {
        return $this->field3Value;
    }

    /**
     * Sets the field3Value
     *
     * @param string $field3Value
     */
    public function setField3Value($field3Value): void
    {
        $this->field3Value = $field3Value;
    }

    /**
     * Returns the backText
     *
     * @return string
     */
    public function getBackText()
    {
        return $this->backText;
    }

    /**
     * Sets the backText
     *
     * @param string $backText
     */
    public function setBackText($backText): void
    {
        $this->backText = $backText;
    }

    /**
     * Returns the backgroundImage
     */
    public function getBackgroundImage(): ?FileReference
    {
        // period is used and we are in an even year
        if ($this->period && $this->period % 2 == 0) {
            return $this->backgroundImageEven ?? $this->backgroundImageOdd;
        }
        return $this->backgroundImageOdd ?? $this->backgroundImageEven;
    }
    /**
     * Returns the backgroundImageOdd
     */
    public function getBackgroundImageOdd(): ?FileReference
    {
        return $this->backgroundImageOdd;
    }

    /**
     * Sets the backgroundImageOdd
     */
    public function setBackgroundImageOdd(?FileReference $backgroundImageOdd): void
    {
        $this->backgroundImageOdd = $backgroundImageOdd;
    }



    /**
     * Returns the backgroundImageEven
     */
    public function getBackgroundImageEven(): ?FileReference
    {
        return $this->backgroundImageEven;
    }

    /**
     * Sets the backgroundImageEven
     */
    public function setBackgroundImageEven(?FileReference $backgroundImageEven): void
    {
        $this->backgroundImageEven = $backgroundImageEven;
    }

    /**
     * Returns the letterTitle
     *
     * @return string
     */
    public function getLetterTitle()
    {
        return $this->letterTitle;
    }

    /**
     * Sets the letterTitle
     *
     * @param string $letterTitle
     */
    public function setLetterTitle($letterTitle): void
    {
        $this->letterTitle = $letterTitle;
    }

    /**
     * Returns the letterText
     *
     * @return string
     */
    public function getLetterText()
    {
        return $this->letterText;
    }

    /**
     * Sets the letterText
     *
     * @param string $letterText
     */
    public function setLetterText($letterText): void
    {
        $this->letterText = $letterText;
    }

    /**
     * Returns the letterNewTitle
     *
     * @return string
     */
    public function getLetterNewTitle()
    {
        return $this->letterNewTitle;
    }

    /**
     * Sets the letterNewTitle
     *
     * @param string $letterNewTitle
     */
    public function setLetterNewTitle($letterNewTitle): void
    {
        $this->letterNewTitle = $letterNewTitle;
    }

    /**
     * Returns the letterNewText
     *
     * @return string
     */
    public function getLetterNewText()
    {
        return $this->letterNewText;
    }

    /**
     * Sets the letterNewText
     *
     * @param string $letterNewText
     */
    public function setLetterNewText($letterNewText): void
    {
        $this->letterNewText = $letterNewText;
    }

    /**
     * Returns the verband
     *
     * @return Verband
     */
    public function getVerband()
    {
        return $this->verband;
    }

    /**
     * Sets the verband
     */
    public function setVerband(Verband $verband): void
    {
        $this->verband = $verband;
    }

    public function getEnableWallet(): bool
    {
        return $this->enableWallet;
    }

    public function setEnableWallet(bool $enableWallet): void
    {
        $this->enableWallet = $enableWallet;
    }


    public function setLetterClosing($letterClosing): void
    {
        $this->letterClosing = $letterClosing;
    }

    public function getLetterClosing()
    {
        return $this->letterClosing;
    }
}
