<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class CategoryOrganisation extends AbstractEntity
{
    /**
     * coName
     *
     * @var string
     */
    protected $coName = '';

    /**
     * limit_to_type
     *
     * @var string
     */
    protected $limitToType = '';

    /**
     * icon
     *
     * @var FileReference
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    protected $icon = null;

    /**
     * image
     *
     * @var ObjectStorage<FileReference>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    protected $image = null;

    
    
    /**
     * Returns the coName
     *
     * @return string
     */
    public function getCoName()
    {
        return $this->coName;
    }

    /**
     * Sets the coName
     *
     * @param string $coName
     */
    public function setCoName($coName): void
    {
        $this->coName = $coName;
    }

    /**
     * Returns the limitToType
     *
     * @return string
     */
    public function getLimitToType()
    {
        return $this->limitToType;
    }

    /**
     * Sets the limitToType
     *
     * @param string $limitToType
     */
    public function setLimitToType($limitToType): void
    {
        $this->limitToType = $limitToType;
    }

    /**
     * Returns the icon
     *
     * @return FileReference
     */
    public function getIcon()
    {
        return $this->icon;
    }
    /**
     * Sets the icon
     */
    public function setIcon(FileReference $icon = null): void
    {
        $this->icon = $icon;
    }
    


    /**
     * Adds a FileReference
     */
    public function addImage(FileReference $image): void
    {
        $this->image->attach($image);
    }

    /**
     * Removes a FileReference
     *
     * @param FileReference $imageToRemove The FileReference to be removed
     */
    public function removeImage(FileReference $imageToRemove): void
    {
        $this->image->detach($imageToRemove);
    }

    /**
     * Returns the image
     *
     * @return ObjectStorage<FileReference> $image
     */
    public function getImage()
    {
        return $this->image;
    }
}
