<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use DateTime;
use Internetgalerie\IgAcl\Domain\Model\AbstractEntityWithAcl;
use Internetgalerie\IgAcl\Domain\Model\AclObjectInterface;
use Internetgalerie\IgCrmTemplate\Domain\Model\AddressInterface;
use Internetgalerie\IgDatapoolFe\Domain\Repository\CountryRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ContactContactRepository;
use Internetgalerie\IgsCrm\Domain\Repository\PersonRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\LazyLoadingProxy;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Contact extends AbstractEntityWithAcl implements AddressInterface, AclObjectInterface
{
    public const MARKER_TITLE = '###TITLE###';
    public const MARKER_LASTNAME = '###LASTNAME###';
    public const MARKER_FIRSTNAME = '###FIRSTNAME###';

    /**
     * meCertificates
     *
     * @var ObjectStorage<ContactCertificate>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    public $meCertificates = null;

    /**
     * Berufsbilder des Lernenden
     *
     * @var Person
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $meBerufsbildner = null;


    /**
     * Kommunikationssprache
     *
     * @var Language
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $meLanguageid = null;

    /**
     * Kommunikationssprache Fallback
     *
     * @var Language
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $fallbackLanguage = null;

    /**
     * meAnredeId
     *
     * @var Anrede
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $meAnredeId = null;

    /**
     * meKantonId
     *
     * @var Kanton
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $meKantonId = null;

    /**
     * mePhoneNumberId
     *
     * @var ObjectStorage<Phonenumber>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    public $mePhoneNumberId = null;

    /**
     * meEmailaddressId
     *
     * @var ObjectStorage<Emailaddress>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    public $meEmailaddressId = null;

    /**
     * messages
     *
     * @var ObjectStorage<Message>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    public $messages = null;



    /**
     * organisationCategory
     *
     * @var ObjectStorage<CategoryOrganisation>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $organisationCategory = null;


    /**
     * meTagId
     *
     * @var ObjectStorage<Tag>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $meTagId = null;



    /**
     * Lehrbetrieb
     *
     * @var Organisation
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $meLehrbetrieb = null;

    /**
     * meContactVerband
     *
     * @var ObjectStorage<ContactVerband>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $meContactVerband = null;

    /**
     * contactTag
     *
     * @var ContactTag
     */
    public $contactTag = null;

    /**
     * mustReviewed
     *
     * @var boolean
     */
    protected $mustReviewed = false;

    /**
     * type
     *
     * @var string
     */
    protected $type;

    /**
     * tstamp
     *
     * @var integer
     */
    protected $tstamp = 0;

    /**
     * hidden
     *
     * @var bool
     */
    protected $hidden = 0;
    /**
     * meLastname
     *
     * @var string
     */
    protected $meLastname = '';

    /**
     * meFirstname
     *
     * @var string
     */
    protected $meFirstname = '';

    /**
     * meAddon
     *
     * @var string
     */
    protected $meAddon = '';

    /**
     * addonIntern
     *
     * @var string
     */
    protected $addonIntern = '';

    /**
     * meBriefanrede
     *
     * @var string
     */
    protected $meBriefanrede = '';

    /**
     * meIsFamily
     *
     * @var boolean
     */
    protected $meIsFamily = false;

    /**
     * meFamily
     *
     * @var Person
     */
    protected $meFamily = null;

    /**
     * meInvoiceTo
     *
     * @var Person
     */
    protected $meInvoiceTo = null;

    /**
     * meIsSammelinvoice
     *
     * @var boolean
     */
    protected $meIsSammelinvoice = false;

    /**
     * meAddress
     *
     * @var string
     */
    protected $meAddress = '';

    /**
     * mePobox
     *
     * @var string
     */
    protected $mePobox = '';

    /**
     * meZip
     *
     * @var string
     */
    protected $meZip = '';

    /**
     * meCity
     *
     * @var string
     */
    protected $meCity = '';

    /**
     * meTitleAbrev
     *
     * @var string
     */
    protected $meTitleAbrev = '';

    /**
     * meTitelName
     *
     * @var string
     */
    protected $meTitelName = '';

    /**
     * meTitleTitle
     *
     * @var string
     */
    protected $meTitleTitle = '';

    /**
     * meRemark
     *
     * @var string
     */
    protected $meRemark = '';

    /**
     * meCountryAbrev
     *
     * @var string
     */
    protected $meCountryAbrev = '';

    /**
     * meTitel
     *
     * @var string
     */
    protected $meTitel = '';

    /**
     * meMap
     *
     * @var string
     */
    protected $meMap = '';

    /**
     * meSsmafpersonYear
     *
     * @var integer
     */
    protected $meSsmafpersonYear = 0;

    /**
     * meDiplomName
     *
     * @var string
     */
    protected $meDiplomName = '';

    /**
     * mePatentVorhanden
     *
     * @var boolean
     */
    protected $mePatentVorhanden = false;

    /**
     * mePatentYear
     *
     * @var integer
     */
    protected $mePatentYear;

    /**
     * frontendUser
     *
     * @var FrontendUser
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    protected $frontendUser;

    /**
     * meAccount
     *
     * @var string
     */
    protected $meAccount = '';

    /**
     * mePassword
     *
     * @var string
     */
    protected $mePassword = '';

    /**
     * hash
     *
     * @var string
     */
    protected $hash = '';

    /**
     * meAmoid
     *
     * @var integer
     */
    protected $meAmoid = 0;

    /**
     * meAddressid
     *
     * @var integer
     */
    protected $meAddressid = 0;

    /**
     * meTitleNr
     *
     * @var integer
     */
    protected $meTitleNr = 0;

    /**
     * meShortname
     *
     * @var string
     */
    protected $meShortname = '';

    /**
     * meYearOfBirth
     *
     * @var integer
     */
    protected $meYearOfBirth;

    /**
     * meErhaeltInvoice
     *
     * @var boolean
     */
    protected $meErhaeltInvoice = false;

    /**
     * meComment
     *
     * @var string
     */
    protected $meComment = '';

    /**
     * meInvoicesadresse
     *
     * @var integer
     */
    protected $meInvoicesadresse = 0;

    /**
     * meDateOfBirth
     *
     * @var DateTime
     */
    protected $meDateOfBirth = null;


    /**
     * meVerstorben
     *
     * @var boolean
     */
    protected $meVerstorben = false;

    /**
     * meDiplomJahr
     *
     * @var integer
     */
    protected $meDiplomJahr;

    /**
     * meStatus
     *
     * @var integer
     */
    protected $meStatus = 0;

    /**
     * meMailAlias
     *
     * @var string
     */
    protected $meMailAlias = '';

    /**
     * meMailGeosuisse
     *
     * @var string
     */
    protected $meMailGeosuisse = '';

    /**
     * meMailIgs
     *
     * @var string
     */
    protected $meMailIgs = '';

    /**
     * meExtraFirma
     *
     * @var string
     */
    protected $meExtraFirma = '';

    /**
     * mFirma
     *
     * @var string
     */
    protected $meFirma = '';

    /**
     * mFirmaAddress
     *
     * @var string
     */
    protected $meFirmaAddress = '';

    /**
     * mFirmaZip
     *
     * @var string
     */
    protected $meFirmaZip = '';

    /**
     * mFirmaCity
     *
     * @var string
     */
    protected $meFirmaCity = '';

    /**
     * mFirmaCountryAbrev
     *
     * @var string
     */
    protected $meFirmaCountryAbrev = '';

    /**
     * meEmail
     *
     * @var string
     */
    protected $meEmail = '';

    /**
     * phone
     *
     * @var string
     */
    protected $phone = '';

    /**
     * fax
     *
     * @var string
     */
    protected $fax = '';

    /**
     * meUrl
     *
     * @var string
     */
    protected $meUrl = '';

    /**
     * meImportId
     *
     * @var integer
     */
    protected $meImportId = 0;

    /**
     * meImportSource
     *
     * @var string
     */
    protected $meImportSource = '';

    /**
     * meImportExternalId
     *
     * @var string
     */
    protected $meImportExternalId = '';

    /**
     * extraSorting
     *
     * @var int
     */
    protected $extraSorting = 100;

    /**
     * meExtraText1
     *
     * @var string
     */
    protected $meExtraText1 = '';

    /**
     * meExtraText2
     *
     * @var string
     */
    protected $meExtraText2 = '';

    /**
     * meExtraText3
     *
     * @var string
     */
    protected $meExtraText3 = '';

    /**
     * meExtraText4
     *
     * @var string
     */
    protected $meExtraText4 = '';

    /**
     * meExtraText5
     *
     * @var string
     */
    protected $meExtraText5 = '';



    /**
     * meExtraField1
     *
     * @var string
     */
    protected $meExtraField1 = '';

    /**
     * meExtraField2
     *
     * @var string
     */
    protected $meExtraField2 = '';

    /**
     * meExtraField3
     *
     * @var string
     */
    protected $meExtraField3 = '';



    /**
     * meBildungspass
     *
     * @var boolean
     */
    protected $meBildungspass = false;

    /**
     * meGeosummit
     *
     * @var boolean
     */
    protected $meGeosummit = false;

    /**
     * meNewsletterTest
     *
     * @var boolean
     */
    protected $meNewsletterTest = false;

    /**
     * meStatusOrganisation
     *
     * @var string
     */
    protected $meStatusOrganisation = '';

    /**
     * meTodestag
     *
     * @var DateTime
     */
    protected $meTodestag = null;




    /**
     * meIsLernende
     *
     * @var boolean
     */
    protected $meIsLernende = false;


    /**
     * meIsBerufsbildner
     *
     * @var boolean
     */
    protected $meIsBerufsbildner = false;

    /**
     * meKlasse
     *
     * @var string
     */
    protected $meKlasse = '';

    /**
     * meExternIdNamespace
     *
     * @var string
     */
    protected $meExternIdNamespace = '';

    /**
     * meExternId
     *
     * @var string
     */
    protected $meExternId = '';

    /**
     * meBmTyp
     *
     * @var string
     */
    protected $meBmTyp = '';

    /**
     * meHeimatort
     *
     * @var string
     */
    protected $meHeimatort = '';

    /**
     * meLbTyp
     *
     * @var string
     */
    protected $meLbTyp = '';

    /**
     * meBranche
     *
     * @var string
     */
    protected $meBranche = '';

    /**
     * meAddress2
     *
     * @var string
     */
    protected $meAddress2 = '';

    /**
     * meAddress3
     *
     * @var string
     */
    protected $meAddress3 = '';

    /**
     * meFirmaAddress2
     *
     * @var string
     */
    protected $meFirmaAddress2 = '';

    /**
     * meFirmaAddress3
     *
     * @var string
     */
    protected $meFirmaAddress3 = '';

    /**
     * meOk
     *
     * @var bool
     */
    protected $meOk = false;


    /**
     * meProfession
     *
     * @var string
     */
    protected $meProfession = '';

    /**
     * @var array
     */
    protected $contactContactByOrganisation = null;

    /**
     * @var array
     */
    protected $contactContactByContact = null;

    /**
     * @var QueryResultInterface
     */
    protected $country = null;

    /**
     * __construct
     */
    public function __construct()
    {
        parent::__construct();
        //Do not remove the next line: It would break the functionality
        $this->organisationCategory = new ObjectStorage();
        $this->initStorageObjects();
    }

    public function __toString(): string
    {
        return (string) $this->getName();
    }


    public function getClass()
    {
        return self::class;
    }
    public function setUid($uid = null)
    {
        return $this->uid = $uid;
    }

    public function setType(string $type): void
    {
        $this->type = $type;
    }
    public function getType()
    {
        return $this->type;
    }
    /*
    public function getArgumentName()
    {
        return strtolower($this->type);
    }
    */
    /**
     * Returns the tstamp
     *
     * @return integer
     */
    public function getTstamp()
    {
        return $this->tstamp;
    }


    public function getTstampIso()
    {
        return strftime('%Y-%m-%d %H:%M:%S', $this->tstamp);
    }

    /**
     * Sets the tstamp
     *
     * @param integer $tstamp
     */
    public function setTstamp($tstamp): void
    {
        $this->tstamp = $tstamp;
    }
    /**
     * Returns the last change timestamp
     *
     * @return bool
     */
    public function getHidden()
    {
        return $this->hidden;
    }
    public function getDisabled()
    {
        return $this->hidden;
    }

    /**
     * Set the value of Hidden
     *
     * @return self
     */
    public function setHidden(bool $hidden)
    {
        $this->hidden = $hidden;
        return $this;
    }

    public function replaceTagName(string $value): string
    {
        return trim(
            str_replace('  ', ' ', str_replace([self::MARKER_LASTNAME, self::MARKER_FIRSTNAME, self::MARKER_TITLE],
                [$this->getMeLastname(), $this->getMeFirstname(), $this->getMeTitel()],
                $value
            ))
        );
    }
    public function removeTagName(string $value): string
    {
        return trim(
            str_replace('  ', ' ', str_replace([self::MARKER_LASTNAME, self::MARKER_FIRSTNAME, self::MARKER_TITLE],
                '',
                $value
            ))
        );
    }
    


    /**
     * Returns the meLastname
     *
     * @return string
     */
    public function getMeLastname()
    {
        return $this->meLastname;
    }
    public function getLastname()
    {
        return $this->meLastname;
    }


    public function getLastnameFirstname()
    {
        return $this->meLastname . ', ' . $this->meFirstname;
    }
    public function getLastnameFirstnameSpace()
    {
        return $this->meLastname . ' ' . $this->meFirstname;
    }

    public function getName()
    {
        if ($this->meLastname) {
            return $this->meFirstname . ' ' . $this->meLastname;
        }
        if ($this->meFirma) {
            return $this->meFirma;
        }
        return $this->meShortname;
    }

    public function getTitelName()
    {
        if ($this->meLastname) {
            return ($this->meTitel ? $this->meTitel . ' ' : '') . $this->meFirstname . ' ' . $this->meLastname;
        }
        if ($this->meFirma) {
            return $this->meFirma;
        }
        return $this->meShortname;
    }

    public function getHasAddress()
    {
        if ($this->meLastname && $this->meFirstname && $this->meZip && $this->meCity) {
            return true;
        }
        return false;
    }
    public function getQrDebitorAdresse()
    {
        return [
            'name' => $this->getName(),
            'address' => $this->getAddress(),
            'zip' => $this->getZip(),
            'city' => $this->getCity(),
            'country' => $this->getCountryPostalCode(),
        ];
    }
    public function getPostalAddress()
    {
        if ($this->getIsOrganisation()) {
            $address[] = $this->getOrganisationName();
            $contactPerson = $this->getContactPerson();
            if ($contactPerson) {
                $address[] = $contactPerson->getAnrede() . ' ' . $contactPerson->getName();
            }
        } else {
            if ($this->getLetterAddressSalutation()) {
                $address[] = $this->getLetterAddressSalutation();
            }
            $address[] = $this->getName();
        }
        if ($this->getAddon()) {
            $address[] = $this->getAddon();
        }
        if ($this->getPoboxText()) {
            $address[] = $this->getPoboxText();
        }
        if ($this->getAddress()) {
            $address[] = $this->getAddress();
        }
        if ($this->getAddress2()) {
            $address[] = $this->getAddress2();
        }
        if ($this->getAddress3()) {
            $address[] = $this->getAddress3();
        }
        $countryPostalCode = $this->getCountryPostalCode();
        if ($countryPostalCode === 'CH' || $countryPostalCode === 'Fl') {
            $countryPostalCode = '';
        }
        $address[] = ($countryPostalCode ? $countryPostalCode . '-' : '') . $this->getZip() . ' ' . $this->getCity();
        $this->postalAddress = implode("\n", $address);
        return $this->postalAddress;
    }
    
    /**
     * Sets the meLastname
     *
     * @param string $meLastname
     */
    public function setMeLastname($meLastname): void
    {
        $this->meLastname = $meLastname;
    }

    /**
     * Returns the meFirstname
     *
     * @return string
     */
    public function getMeFirstname()
    {
        return $this->meFirstname;
    }
    public function getFirstname()
    {
        return $this->meFirstname;
    }

    /**
     * Sets the meFirstname
     *
     * @param string $meFirstname
     */
    public function setMeFirstname($meFirstname): void
    {
        $this->meFirstname = $meFirstname;
    }

    /**
     * Returns the meAddon
     *
     * @return string
     */
    public function getMeAddon()
    {
        return $this->meAddon;
    }
    public function getAddon()
    {
        return $this->meAddon;
    }

    /**
     * Sets the meAddon
     *
     * @param string $meAddon
     */
    public function setMeAddon($meAddon): void
    {
        $this->meAddon = $meAddon;
    }


    /**
     * Returns the addonIntern
     *
     * @return string
     */
    public function getAddonIntern()
    {
        return $this->addonIntern;
    }

    /**
     * Sets the addonIntern
     *
     * @param string $addonIntern
     */
    public function setAddonIntern($addonIntern): void
    {
        $this->addonIntern = $addonIntern;
    }


    /**
     * Returns the meAddress
     *
     * @return string
     */
    public function getMeAddress()
    {
        return $this->meAddress;
    }
    public function getAddress()
    {
        return $this->meAddress;
    }

    /**
     * Sets the meAddress
     *
     * @param string $meAddress
     */
    public function setMeAddress($meAddress): void
    {
        $this->meAddress = $meAddress;
    }

    /**
     * Returns the mePobox
     *
     * @return string
     */
    public function getMePobox()
    {
        return $this->mePobox;
    }
    public function getPobox()
    {
        return $this->mePobox;
    }
    /**
     * Returns the mePobox
     *
     * @return string
     */
    public function getPoboxText()
    {
        if ($this->mePobox == '' || $this->mePobox === null) {
            return '';
        }
        return $this->mePobox;
        //return strpos($this->mePobox,' ')>0 || $this->mePobox=='Postfach' ? $this->mePobox : 'Postfach ' . $this->mePobox;
    }

    /**
     * Sets the mePobox
     *
     * @param string $mePobox
     */
    public function setMePobox($mePobox): void
    {
        $this->mePobox = $mePobox;
    }

    /**
     * Returns the meZip
     *
     * @return string
     */
    public function getMeZip()
    {
        return trim($this->meZip);
    }
    public function getZip()
    {
        return trim($this->meZip);
    }

    /**
     * Sets the meZip
     *
     * @param string $meZip
     */
    public function setMeZip($meZip): void
    {
        $this->meZip = $meZip;
    }

    /**
     * Returns the meCity
     *
     * @return string
     */
    public function getMeCity()
    {
        return $this->meCity;
    }
    public function getCity()
    {
        return $this->meCity;
    }

    /**
     * Sets the meCity
     *
     * @param string $meCity
     */
    public function setMeCity($meCity): void
    {
        $this->meCity = $meCity;
    }




    /**
     * Returns the meMap
     *
     * @return string
     */
    public function getMeMap()
    {
        return $this->meMap;
    }
    public function getMap()
    {
        return $this->meMap;
    }

    /**
     * Sets the meMap
     *
     * @param string $meMap
     */
    public function setMeMap($meMap): void
    {
        $this->meMap = $meMap;
    }





    
    /**
     * Returns the meTitleAbrev
     *
     * @return string
     */
    public function getMeTitleAbrev()
    {
        return $this->meTitleAbrev;
    }

    /**
     * Sets the meTitleAbrev
     *
     * @param string $meTitleAbrev
     */
    public function setMeTitleAbrev($meTitleAbrev): void
    {
        $this->meTitleAbrev = $meTitleAbrev;
    }

    /**
     * Returns the meTitelName
     *
     * @return string
     */
    public function getMeTitelName()
    {
        return $this->meTitelName;
    }

    /**
     * Sets the meTitelName
     *
     * @param string $meTitelName
     */
    public function setMeTitelName($meTitelName): void
    {
        $this->meTitelName = $meTitelName;
    }

    /**
     * Returns the meTitleTitle
     *
     * @return string
     */
    public function getMeTitleTitle()
    {
        return $this->meTitleTitle;
    }

    /**
     * Sets the meTitleTitle
     *
     * @param string $meTitleTitle
     */
    public function setMeTitleTitle($meTitleTitle): void
    {
        $this->meTitleTitle = $meTitleTitle;
    }

    /**
     * Returns the meRemark
     *
     * @return string
     */
    public function getMeRemark()
    {
        return $this->meRemark;
    }

    /**
     * Sets the meRemark
     *
     * @param string $meRemark
     */
    public function setMeRemark($meRemark): void
    {
        $this->meRemark = $meRemark;
    }

    /**
     * Returns the meCountryAbrev
     *
     * @return string
     */
    public function getMeCountryAbrev()
    {
        return $this->meCountryAbrev;
    }
    /* wie getMeCountryAbrev aber falls nicht definier CH */
    public function getCountryIsoCode()
    {
        return $this->meCountryAbrev ?: 'CH';
    }
    public function getCountryPostalCode()
    {
        if ($this->meCountryAbrev == 'LI') {
            return 'FL';
        }
        return $this->meCountryAbrev ?: 'CH';
    }
    public function getCountry()
    {
        if ($this->country === null && $this->meCountryAbrev) {
            $countryRepository = GeneralUtility::makeInstance(CountryRepository::class);
            $this->country = $countryRepository->findOneByCnIso_2($this->meCountryAbrev);
        }
        return $this->country;
    }

    /**
     * Sets the meCountryAbrev
     *
     * @param string $meCountryAbrev
     */
    public function setMeCountryAbrev($meCountryAbrev): void
    {
        $this->meCountryAbrev = $meCountryAbrev;
    }

    /**
     * Returns the meTitel
     *
     * @return string
     */
    public function getMeTitel()
    {
        return $this->meTitel;
    }

    /**
     * Sets the meTitel
     *
     * @param string $meTitel
     */
    public function setMeTitel($meTitel): void
    {
        $this->meTitel = $meTitel;
    }


    /**
     * Returns the meSsmafpersonYear
     *
     * @return integer
     */
    public function getMeSsmafpersonYear()
    {
        return $this->meSsmafpersonYear;
    }

    /**
     * Sets the meSsmafpersonYear
     *
     * @param integer $meSsmafpersonYear
     */
    public function setMeSsmafpersonYear($meSsmafpersonYear): void
    {
        $this->meSsmafpersonYear = $meSsmafpersonYear;
    }

    /**
     * Returns the meDiplomName
     *
     * @return string
     */
    public function getMeDiplomName()
    {
        return $this->meDiplomName;
    }

    /**
     * Sets the meDiplomName
     *
     * @param string $meDiplomName
     */
    public function setMeDiplomName($meDiplomName): void
    {
        $this->meDiplomName = $meDiplomName;
    }

    /**
     * Returns the mePatentVorhanden
     *
     * @return boolean
     */
    public function getMePatentVorhanden()
    {
        return $this->mePatentVorhanden;
    }

    /**
     * Sets the mePatentVorhanden
     *
     * @param boolean $mePatentVorhanden
     */
    public function setMePatentVorhanden($mePatentVorhanden): void
    {
        $this->mePatentVorhanden = $mePatentVorhanden;
    }

    /**
     * Returns the boolean state of mePatentVorhanden
     *
     * @return boolean
     */
    public function isMePatentVorhanden()
    {
        return $this->mePatentVorhanden;
    }

    /**
     * Returns the mePatentYear
     *
     * @return integer
     */
    public function getMePatentYear()
    {
        return $this->mePatentYear;
    }

    /**
     * Sets the mePatentYear
     *
     * @param integer $mePatentYear
     */
    public function setMePatentYear($mePatentYear): void
    {
        $this->mePatentYear = $mePatentYear;
    }

    /**
     * Adds a Certificate
     */
    public function addMeCertificate(ContactCertificate $meCertificate): void
    {
        $this->meCertificates->attach($meCertificate);
    }

    /**
     * Removes a Certificate
     *
     * @param ContactCertificate $meCertificateToRemove The Certificate to be removed
     */
    public function removeMeCertificate(ContactCertificate $meCertificateToRemove): void
    {
        $this->meCertificates->detach($meCertificateToRemove);
    }

    /**
     * Returns the meCertificates
     *
     * @return ObjectStorage<ContactCertificate> $meCertificates
     */
    public function getMeCertificates()
    {
        return $this->meCertificates;
    }


    /**
     * Sets the meCertificates
     *
     * @param ObjectStorage<ContactCertificate> $meCertificates
     */
    public function setMeCertificates(ObjectStorage $meCertificates): void
    {
        $this->meCertificates = $meCertificates;
    }
    
    /**
     * Returns the frontendUser
     *
     * @return FrontendUser
     */
    public function getFrontendUser()
    {
        if ($this->frontendUser instanceof LazyLoadingProxy) {
            $this->frontendUser = $this->frontendUser->_loadRealInstance();
        }
        return $this->frontendUser;
    }

    /**
     * Sets the frontendUser
     */
    public function setFrontendUser(FrontendUser $frontendUser): void
    {
        $this->frontendUser = $frontendUser;
    }

    /**
     * Returns the meAccount
     *
     * @return string
     */
    public function getMeAccount()
    {
        return $this->meAccount;
    }

    /**
     * Sets the meAccount
     *
     * @param string $meAccount
     */
    public function setMeAccount($meAccount): void
    {
        $this->meAccount = $meAccount;
    }

    /**
     * Returns the mePassword
     *
     * @return string
     */
    public function getMePassword()
    {
        return $this->mePassword;
    }

    /**
     * Sets the mePassword
     *
     * @param string $mePassword
     */
    public function setMePassword($mePassword): void
    {
        $this->mePassword = $mePassword;
    }


    /**
     * Returns the meAmoid
     *
     * @return integer
     */
    public function getMeAmoid()
    {
        return $this->meAmoid > 0 ? $this->meAmoid : '';
    }

    /**
     * Sets the meAmoid
     *
     * @param integer $meAmoid
     */
    public function setMeAmoid($meAmoid): void
    {
        $this->meAmoid = $meAmoid;
    }

    /**
     * Returns the meAddressid
     *
     * @return integer
     */
    public function getMeAddressidForLetter($depth = 3)
    {
        if ($depth == 0) {
            die('too much recursion on meInvoiceTo or meFamily. Current: ' . $this->meAddressid . ' (' . $this->meLastname . ' ' . $this->meFirstname . ')');
        }
        if ($this->meInvoiceTo !== null) {
            return $this->meInvoiceTo->getMeAddressidForLetter($depth - 1);
        }
        if ($this->meFamily !== null) {
            return $this->meFamily->getMeAddressidForLetter($depth - 1);
        }
        return $this->meAddressid;
    }
    /**
     * Returns the meAddressid
     *
     * @return integer
     */
    public function getMeAddressid()
    {
        return $this->meAddressid;
    }
    public function getOwnNumber()
    {
        return $this->meAddressid;
    }
    public function getNumber()
    {
        return $this->meAddressid;
        //        return $this->uid;
        //return $this->meAddressid;
    }

    /**
     * Sets the meAddressid
     *
     * @param integer $meAddressid
     */
    public function setMeAddressid($meAddressid): void
    {
        $this->meAddressid = $meAddressid;
    }

    /**
     * Returns the meTitleNr
     *
     * @return integer
     */
    public function getMeTitleNr()
    {
        return $this->meTitleNr;
    }

    /**
     * Sets the meTitleNr
     *
     * @param integer $meTitleNr
     */
    public function setMeTitleNr($meTitleNr): void
    {
        $this->meTitleNr = $meTitleNr;
    }

    /**
     * Returns the meShortname
     *
     * @return string
     */
    public function getMeShortname()
    {
        return $this->meShortname;
    }
    public function getShortname()
    {
        return $this->meShortname;
    }

    /**
     * Sets the meShortname
     *
     * @param string $meShortname
     */
    public function setMeShortname($meShortname): void
    {
        $this->meShortname = $meShortname;
    }

    /**
     * Returns the meYearOfBirth
     *
     * @return integer
     */
    public function getMeYearOfBirth()
    {
        if ($this->meDateOfBirth !== null) {
            return $this->meDateOfBirth->format('Y');
        }
        return $this->meYearOfBirth;
    }

    /**
     * Sets the meYearOfBirth
     *
     * @param integer $meYearOfBirth
     */
    public function setMeYearOfBirth($meYearOfBirth): void
    {
        $this->meYearOfBirth = $meYearOfBirth;
    }

    /**
     * Returns the meErhaeltInvoice
     *
     * @return boolean
     */
    public function getMeErhaeltInvoice()
    {
        return $this->meErhaeltInvoice;
    }

    /**
     * Sets the meErhaeltInvoice
     *
     * @param boolean $meErhaeltInvoice
     */
    public function setMeErhaeltInvoice($meErhaeltInvoice): void
    {
        $this->meErhaeltInvoice = $meErhaeltInvoice;
    }

    /**
     * Returns the boolean state of meErhaeltInvoice
     *
     * @return boolean
     */
    public function isMeErhaeltInvoice()
    {
        return $this->meErhaeltInvoice;
    }

    /**
     * Returns the meComment
     *
     * @return string
     */
    public function getMeComment()
    {
        return $this->meComment;
    }

    /**
     * Sets the meComment
     *
     * @param string $meComment
     */
    public function setMeComment($meComment): void
    {
        $this->meComment = $meComment;
    }

    /**
     * Returns the meInvoicesadresse
     *
     * @return integer
     */
    public function getMeInvoicesadresse()
    {
        return $this->meInvoicesadresse;
    }

    /**
     * Sets the meInvoicesadresse
     *
     * @param integer $meInvoicesadresse
     */
    public function setMeInvoicesadresse($meInvoicesadresse): void
    {
        $this->meInvoicesadresse = $meInvoicesadresse;
    }

    /**
     * Returns the meDateOfBirth
     *
     * @return DateTime
     */
    public function getMeDateOfBirth()
    {
        return $this->meDateOfBirth;
    }

    /**
     * Sets the meDateOfBirth
     *
     * @param DateTime $meDateOfBirth
     */
    public function setMeDateOfBirth($meDateOfBirth): void
    {
        $this->meDateOfBirth = $meDateOfBirth;
    }





    /**
     * Returns the meVerstorben
     *
     * @return boolean
     */
    public function getMeVerstorben()
    {
        return $this->meVerstorben;
    }

    /**
     * Sets the meVerstorben
     *
     * @param boolean $meVerstorben
     */
    public function setMeVerstorben($meVerstorben): void
    {
        $this->meVerstorben = $meVerstorben;
    }

    /**
     * Returns the boolean state of meVerstorben
     *
     * @return boolean
     */
    public function isMeVerstorben()
    {
        return $this->meVerstorben;
    }




    /**
     * Returns the meDiplomJahr
     *
     * @return integer
     */
    public function getMeDiplomJahr()
    {
        return $this->meDiplomJahr;
    }

    /**
     * Sets the meDiplomJahr
     *
     * @param integer $meDiplomJahr
     */
    public function setMeDiplomJahr($meDiplomJahr): void
    {
        $this->meDiplomJahr = $meDiplomJahr;
    }

    /**
     * Returns the meStatus
     *
     * @return integer
     */
    public function getMeStatus()
    {
        return $this->meStatus;
    }

    /**
     * Sets the meStatus
     *
     * @param integer $meStatus
     */
    public function setMeStatus($meStatus): void
    {
        $this->meStatus = $meStatus;
    }

    /**
     * Returns the meTodestag
     *
     * @return DateTime
     */
    public function getMeTodestag()
    {
        return $this->meTodestag;
    }
    public function getActive()
    {
        $now = new DateTime();
        return $this->hidden == 0 && ($this->meTodestag === null || $this->meTodestag > $now) && $this->meVerstorben !== true;
    }

    /**
     * Sets the meTodestag
     *
     * @param DateTime $meTodestag
     */
    public function setMeTodestag($meTodestag): void
    {
        $this->meTodestag = $meTodestag;
    }


    /**
     * Returns the meStatusOrganisation
     *
     * @return string
     */
    public function getMeStatusOrganisation()
    {
        return $this->meStatusOrganisation;
    }

    /**
     * Sets the meStatusOrganisation
     *
     * @param string $meStatusOrganisation
     */
    public function setMeStatusOrganisation($meStatusOrganisation): void
    {
        $this->meStatusOrganisation = $meStatusOrganisation;
    }

    /**
     * Returns the meMailAlias
     *
     * @return string
     */
    public function getMeMailAlias()
    {
        return $this->meMailAlias;
    }

    /**
     * Sets the meMailAlias
     *
     * @param string $meMailAlias
     */
    public function setMeMailAlias($meMailAlias): void
    {
        $this->meMailAlias = $meMailAlias;
    }

    /**
     * Returns the meMailGeosuisse
     *
     * @return string
     */
    public function getMeMailGeosuisse()
    {
        return $this->meMailGeosuisse;
    }

    /**
     * Sets the meMailGeosuisse
     *
     * @param string $meMailGeosuisse
     */
    public function setMeMailGeosuisse($meMailGeosuisse): void
    {
        $this->meMailGeosuisse = $meMailGeosuisse;
    }

    /**
     * Returns the meMailIgs
     *
     * @return string
     */
    public function getMeMailIgs()
    {
        return $this->meMailIgs;
    }

    /**
     * Sets the meMailIgs
     *
     * @param string $meMailIgs
     */
    public function setMeMailIgs($meMailIgs): void
    {
        $this->meMailIgs = $meMailIgs;
    }

    /**
     * Returns the meExtraFirma
     *
     * @return string
     */
    public function getMeExtraFirma()
    {
        return $this->meExtraFirma;
    }

    /**
     * Sets the meExtraFirma
     *
     * @param string $meExtraFirma
     */
    public function setMeExtraFirma($meExtraFirma): void
    {
        $this->meExtraFirma = $meExtraFirma;
    }

    /**
     * Returns the meFirma
     *
     * @return string
     */
    public function getMeFirma()
    {
        return $this->meFirma;
    }

    /**
     * Sets the meFirma
     *
     * @param string $meFirma
     */
    public function setMeFirma($meFirma): void
    {
        $this->meFirma = $meFirma;
    }









    /**
     * Returns the meFirmaAddress
     *
     * @return string
     */
    public function getMeFirmaAddress()
    {
        return $this->meFirmaAddress;
    }

    /**
     * Sets the meFirmaAddress
     *
     * @param string $meFirmaAddress
     */
    public function setMeFirmaAddress($meFirmaAddress): void
    {
        $this->meFirmaAddress = $meFirmaAddress;
    }

    /**
     * Returns the meFirmaZip
     *
     * @return string
     */
    public function getMeFirmaZip()
    {
        return $this->meFirmaZip;
    }

    /**
     * Sets the meFirmaZip
     *
     * @param string $meFirmaZip
     */
    public function setMeFirmaZip($meFirmaZip): void
    {
        $this->meFirmaZip = $meFirmaZip;
    }

    /**
     * Returns the meFirmaCity
     *
     * @return string
     */
    public function getMeFirmaCity()
    {
        return $this->meFirmaCity;
    }

    /**
     * Sets the meFirmaCity
     *
     * @param string $meFirmaCity
     */
    public function setMeFirmaCity($meFirmaCity): void
    {
        $this->meFirmaCity = $meFirmaCity;
    }

    /**
     * Returns the meFirmaCountryAbrev
     *
     * @return string
     */
    public function getMeFirmaCountryAbrev()
    {
        return $this->meFirmaCountryAbrev;
    }

    /**
     * Sets the meFirmaCountryAbrev
     *
     * @param string $meFirmaCountryAbrev
     */
    public function setMeFirmaCountryAbrev($meFirmaCountryAbrev): void
    {
        $this->meFirmaCountryAbrev = $meFirmaCountryAbrev;
    }







    /**
     * Returns the meEmail
     *
     * @return string
     */
    public function getMeEmail()
    {
        return $this->meEmail;
    }

    /**
     * Sets the meEmail
     *
     * @param string $meEmail
     */
    public function setMeEmail($meEmail): void
    {
        $this->meEmail = $meEmail;
    }

    /**
     * Returns the phone
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Sets the phone
     *
     * @param string $phone
     */
    public function setPhone($phone): void
    {
        $this->phone = $phone;
    }

    /**
     * Returns the fax
     *
     * @return string
     */
    public function getFax()
    {
        return $this->fax;
    }

    /**
     * Sets the fax
     *
     * @param string $fax
     */
    public function setFax($fax): void
    {
        $this->fax = $fax;
    }

    /**
     * Returns the meUrl
     *
     * @return string
     */
    public function getMeUrl()
    {
        return $this->meUrl;
    }

    /**
     * Sets the meUrl
     *
     * @param string $meUrl
     */
    public function setMeUrl($meUrl): void
    {
        $this->meUrl = $meUrl;
    }

    /**
     * Returns the meImportId
     *
     * @return int
     */
    public function getMeImportId()
    {
        return $this->meImportId;
    }

    /**
     * Sets the meImportId
     *
     * @param int $meImportId
     */
    public function setMeImportId($meImportId): void
    {
        $this->meImportId = $meImportId;
    }

    /**
     * Returns the meImportSource
     *
     * @return string
     */
    public function getMeImportSource()
    {
        return $this->meImportSource;
    }

    /**
     * Sets the meImportSource
     *
     * @param string $meImportSource
     */
    public function setMeImportSource($meImportSource): void
    {
        $this->meImportSource = $meImportSource;
    }

    /**
     * Returns the meImportExternalId
     *
     * @return string
     */
    public function getMeImportExternalId()
    {
        return $this->meImportExternalId;
    }

    /**
     * Sets the meImportExternalId
     *
     * @param string $meImportExternalId
     */
    public function setMeImportExternalId($meImportExternalId): void
    {
        $this->meImportExternalId = $meImportExternalId;
    }


    /**
     * Returns the extraSorting
     *
     * @return integer
     */
    public function getExtraSorting()
    {
        return $this->extraSorting;
    }

    /**
     * Sets the extraSorting
     *
     * @param integer $extraSorting
     */
    public function setExtraSorting($extraSorting): void
    {
        $this->extraSorting = $extraSorting;
    }

    /**
     * Returns the meExtraText1
     *
     * @return string
     */
    public function getMeExtraText1()
    {
        return $this->meExtraText1;
    }

    /**
     * Sets the meExtraText1
     *
     * @param string $meExtraText1
     */
    public function setMeExtraText1($meExtraText1): void
    {
        $this->meExtraText1 = $meExtraText1;
    }


    /**
     * Returns the meExtraText2
     *
     * @return string
     */
    public function getMeExtraText2()
    {
        return $this->meExtraText2;
    }

    /**
     * Sets the meExtraText2
     *
     * @param string $meExtraText2
     */
    public function setMeExtraText2($meExtraText2): void
    {
        $this->meExtraText2 = $meExtraText2;
    }


    /**
     * Returns the meExtraText3
     *
     * @return string
     */
    public function getMeExtraText3()
    {
        return $this->meExtraText3;
    }

    /**
     * Sets the meExtraText3
     *
     * @param string $meExtraText3
     */
    public function setMeExtraText3($meExtraText3): void
    {
        $this->meExtraText3 = $meExtraText3;
    }

    /**
     * Returns the meExtraText4
     *
     * @return string
     */
    public function getMeExtraText4()
    {
        return $this->meExtraText4;
    }

    /**
     * Sets the meExtraText4
     *
     * @param string $meExtraText4
     */
    public function setMeExtraText4($meExtraText4): void
    {
        $this->meExtraText4 = $meExtraText4;
    }


    /**
     * Returns the meExtraText5
     *
     * @return string
     */
    public function getMeExtraText5()
    {
        return $this->meExtraText5;
    }

    /**
     * Sets the meExtraText5
     *
     * @param string $meExtraText5
     */
    public function setMeExtraText5($meExtraText5): void
    {
        $this->meExtraText5 = $meExtraText5;
    }




    /**
     * Returns the meExtraField1
     *
     * @return string
     */
    public function getMeExtraField1()
    {
        return $this->meExtraField1;
    }

    /**
     * Sets the meExtraField1
     *
     * @param string $meExtraField1
     */
    public function setMeExtraField1($meExtraField1): void
    {
        $this->meExtraField1 = $meExtraField1;
    }


    /**
     * Returns the meExtraField2
     *
     * @return string
     */
    public function getMeExtraField2()
    {
        return $this->meExtraField2;
    }

    /**
     * Sets the meExtraField2
     *
     * @param string $meExtraField2
     */
    public function setMeExtraField2($meExtraField2): void
    {
        $this->meExtraField2 = $meExtraField2;
    }


    /**
     * Returns the meExtraField3
     *
     * @return string
     */
    public function getMeExtraField3()
    {
        return $this->meExtraField3;
    }

    /**
     * Sets the meExtraField3
     *
     * @param string $meExtraField3
     */
    public function setMeExtraField3($meExtraField3): void
    {
        $this->meExtraField3 = $meExtraField3;
    }





    /**
     * Returns the meBildungspass
     *
     * @return boolean
     */
    public function getMeBildungspass()
    {
        return $this->meBildungspass;
    }

    /**
     * Sets the meBildungspass
     *
     * @param boolean $meBildungspass
     */
    public function setMeBildungspass($meBildungspass): void
    {
        $this->meBildungspass = $meBildungspass;
    }

    /**
     * Returns the boolean state of meBildungspass
     *
     * @return boolean
     */
    public function isMeBildungspass()
    {
        return $this->meBildungspass;
    }

    /**
     * Returns the meGeosummit
     *
     * @return boolean
     */
    public function getMeGeosummit()
    {
        return $this->meGeosummit;
    }

    /**
     * Sets the meGeosummit
     *
     * @param boolean $meGeosummit
     */
    public function setMeGeosummit($meGeosummit): void
    {
        $this->meGeosummit = $meGeosummit;
    }

    /**
     * Returns the boolean state of meGeosummit
     *
     * @return boolean
     */
    public function isMeGeosummit()
    {
        return $this->meGeosummit;
    }





    /**
     * Returns the meNewsletterTest
     *
     * @return boolean
     */
    public function getMeNewsletterTest()
    {
        return $this->meNewsletterTest;
    }

    /**
     * Sets the meNewsletterTest
     *
     * @param boolean $meNewsletterTest
     */
    public function setMeNewsletterTest($meNewsletterTest): void
    {
        $this->meNewsletterTest = $meNewsletterTest;
    }

    /**
     * Returns the boolean state of meNewsletterTest
     *
     * @return boolean
     */
    public function isMeNewsletterTest()
    {
        return $this->meNewsletterTest;
    }


    /**
     * Returns the meAddress2
     *
     * @return string
     */
    public function getMeAddress2()
    {
        return $this->meAddress2;
    }
    public function getAddress2()
    {
        return $this->meAddress2;
    }

    /**
     * Sets the meAddress2
     *
     * @param string $meAddress2
     */
    public function setMeAddress2($meAddress2): void
    {
        $this->meAddress2 = $meAddress2;
    }

    /**
     * Returns the meAddress3
     *
     * @return string
     */
    public function getMeAddress3()
    {
        return $this->meAddress3;
    }
    public function getAddress3()
    {
        return $this->meAddress3;
    }

    /**
     * Sets the meAddress3
     *
     * @param string $meAddress3
     */
    public function setMeAddress3($meAddress3): void
    {
        $this->meAddress3 = $meAddress3;
    }

    /**
     * Returns the meFirmaAddress2
     *
     * @return string
     */
    public function getMeFirmaAddress2()
    {
        return $this->meFirmaAddress2;
    }

    /**
     * Sets the meFirmaAddress2
     *
     * @param string $meFirmaAddress2
     */
    public function setMeFirmaAddress2($meFirmaAddress2): void
    {
        $this->meFirmaAddress2 = $meFirmaAddress2;
    }

    /**
     * Returns the meFirmaAddress3
     *
     * @return string
     */
    public function getMeFirmaAddress3()
    {
        return $this->meFirmaAddress3;
    }

    /**
     * Sets the meFirmaAddress3
     *
     * @param string $meFirmaAddress3
     */
    public function setMeFirmaAddress3($meFirmaAddress3): void
    {
        $this->meFirmaAddress3 = $meFirmaAddress3;
    }

    /**
     * Returns the meOk
     *
     * @return bool
     */
    public function getMeOk()
    {
        return $this->meOk;
    }

    /**
     * Sets the meOk
     *
     * @param bool $meOk
     */
    public function setMeOk($meOk): void
    {
        $this->meOk = $meOk;
    }

    /**
     * Returns the boolean state of meOk
     *
     * @return bool
     */
    public function isMeOk()
    {
        return $this->meOk;
    }

    /**
     * Returns the meProfession
     *
     * @return string
     */
    public function getMeProfession()
    {
        return $this->meProfession;
    }

    /**
     * Sets the meProfession
     *
     * @param string $meProfession
     */
    public function setMeProfession($meProfession): void
    {
        $this->meProfession = $meProfession;
    }


    /**
     * Returns the meBerufsbildner
     *
     * @return Person
     */
    public function getMeBerufsbildner()
    {
        return $this->meBerufsbildner;
    }

    /**
     * Sets the meBerufsbildner
     */
    public function setMeBerufsbildner(Person $meBerufsbildner = null): void
    {
        $this->meBerufsbildner = $meBerufsbildner;
    }

    /**
     * Returns the lernende (persons with meBerufsbildner=my.uid)
     *
     * @return Person
     */
    public function getLernende()
    {
        $personRepository = GeneralUtility::makeInstance(PersonRepository::class);
        return $personRepository->findBy([
            'meBerufsbildner' => $this->uid,
        ]);
    }


    /**
     * Returns the meLanguageid
     *
     * @return Language
     */
    public function getMeLanguageid()
    {
        if ($this->meLanguageid instanceof LazyLoadingProxy) {
            $this->meLanguageid = $this->meLanguageid->_loadRealInstance();
        }
        return $this->meLanguageid;
    }
    public function getLanguageCode()
    {
        $meLanguageid = $this->getMeLanguageid();
        if ($meLanguageid instanceof Language) {
            return $meLanguageid->getCode();
        }
        return 'de';
    }
    public function getLanguageCodeWithFallback(array $allowedLanguages = ['de', 'fr'])
    {
        $language = $this->getLanguageWithFallback($allowedLanguages);
        if ($language instanceof Language) {
            return $language->getCode();
        }
        return $allowedLanguages[0] ?? 'de';
    }
    
    public function getLanguageShort()
    {
        $meLanguageid = $this->getMeLanguageid();
        if ($meLanguageid instanceof Language) {
            return $meLanguageid->getShort();
        }
        return 'D';
    }
    public function getLanguage()
    {
        return $this->getMeLanguageid();
    }
    public function getLanguageWithFallback(array $languages)
    {
        $language = $this->getMeLanguageid();
        if ($language instanceof Language) {
            if (in_array($language->getCode(), $languages)) {
                return $language;
            }
        }
        return $this->getFallbackLanguage() ?? $languages[0] ?? $language;
    }
    public function getLanguageLocale()
    {
        $meLanguageid = $this->getMeLanguageid();
        if ($meLanguageid instanceof Language) {
            return $meLanguageid->getLgLocale();
        }
        return '';
    }
    /**
     * Returns the meLanguage
     *
     * @return Language
     */
    public function getMeLanguage()
    {
        return $this->getLanguageCode();//$this->meLanguageid->getLgShort();
    }

    /**
     * Sets the meLanguageid
     */
    public function setMeLanguageid(Language $meLanguageid = null): void
    {
        $this->meLanguageid = $meLanguageid;
    }



    /**
     * Returns the fallbackLanguage
     *
     * @return Language
     */
    public function getFallbackLanguage()
    {
        if ($this->fallbackLanguage instanceof LazyLoadingProxy) {
            $this->fallbackLanguage = $this->fallbackLanguage->_loadRealInstance();
        }
        return $this->fallbackLanguage;
    }

    /**
     * Sets the fallbackLanguage
     */
    public function setFallbackLanguage(Language $fallbackLanguage = null): void
    {
        $this->fallbackLanguage = $fallbackLanguage;
    }

    public function getFallbackLanguageLocale(array $allowedLanguages = ['de', 'fr'])
    {
        $fallbackLanguage = $this->getFallbackLanguage();
        if ($fallbackLanguage instanceof Language) {
            return $fallbackLanguage->getLgLocale();
        }
        return '';
    }

    /**
     * Returns the meAnredeId
     *
     * @return Anrede
     */
    public function getMeAnredeId()
    {
        return $this->meAnredeId;
    }

    public function getSex(): string
    {
        if ($this->meAnredeId == 1) {
            return 'm';
        }
        return $this->meAnredeId == 2 ? 'f' : 'd';
    }

    /**
     * Returns the meAnrede
     *
     * @return Anrede
     */
    public function getMeAnrede()
    {
        if (is_object($this->meAnredeId)) {
            return $this->meAnredeId->getAnName();
        }
        return null;
    }
    public function getAnredeId()
    {
        if (is_object($this->meAnredeId)) {
            return $this->meAnredeId->getUid();
        }
        return null;
    }

    /**
     * Sets the meAnredeId
     */
    public function setMeAnredeId(Anrede $meAnredeId = null): void
    {
        $this->meAnredeId = $meAnredeId;
    }

    /**
     * Returns the meKantonId
     *
     * @return Kanton
     */
    public function getMeKantonId()
    {
        if ($this->meKantonId instanceof LazyLoadingProxy) {
            $this->meKantonId->_loadRealInstance();
        }
        return $this->meKantonId;
    }
    public function getStateAbbreviation(): ?string
    {
        if (is_object($this->meKantonId)) {
            return $this->meKantonId->getKaAbkuerzung();
        }
        return null;
    }
    /**
     * Returns the meKantonId
     */
    public function getMeKanton(): ?string
    {
        return $this->getStateAbbreviation();
    }

    
    /**
     * Sets the meKantonId
     *
     * @param Kanton $meKantonId
     */
    public function setMeKantonId($meKantonId): void
    {
        $this->meKantonId = $meKantonId;
    }


    /**
     * Adds a Phonenumber
     */
    public function addMePhoneNumberId(Phonenumber $mePhoneNumberId): void
    {
        $this->mePhoneNumberId->attach($mePhoneNumberId);
    }

    /**
     * Removes a Phonenumber
     *
     * @param Phonenumber $mePhoneNumberIdToRemove The Phonenumber to be removed
     */
    public function removeMePhoneNumberId(Phonenumber $mePhoneNumberIdToRemove): void
    {
        $this->mePhoneNumberId->detach($mePhoneNumberIdToRemove);
    }

    /**
     * Returns the mePhoneNumberId
     *
     * @return ObjectStorage<Phonenumber> $mePhoneNumberId
     */
    public function getMePhoneNumberId()
    {
        return $this->mePhoneNumberId;
    }


    /**
     * Sets the mePhoneNumberId
     *
     * @param ObjectStorage<Phonenumber> $mePhoneNumberId
     */
    public function setMePhoneNumberId(ObjectStorage $mePhoneNumberId): void
    {
        $this->mePhoneNumberId = $mePhoneNumberId;
    }

    /**
     * Adds a Emailaddress
     */
    public function addMeEmailaddressId(Emailaddress $meEmailaddressId): void
    {
        $this->meEmailaddressId->attach($meEmailaddressId);
    }

    /**
     * Removes a Emailaddress
     *
     * @param Emailaddress $meEmailaddressIdToRemove The Emailaddress to be removed
     */
    public function removeMeEmailaddressId(Emailaddress $meEmailaddressIdToRemove): void
    {
        $this->meEmailaddressId->detach($meEmailaddressIdToRemove);
    }

    /**
     * Returns the meEmailaddressId
     *
     * @return ObjectStorage<Emailaddress> $meEmailaddressId
     */
    public function getMeEmailaddressId()
    {
        return $this->meEmailaddressId;
    }

    /**
     * Sets the meEmailaddressId
     *
     * @param ObjectStorage<Emailaddress> $meEmailaddressId
     */
    public function setMeEmailaddressId(ObjectStorage $meEmailaddressId): void
    {
        $this->meEmailaddressId = $meEmailaddressId;
    }

    /**
     * Adds a Messages
     */
    public function addMessages(Message $messages): void
    {
        $this->messages->attach($messages);
    }

    /**
     * Removes a Messages
     *
     * @param Message $messagesToRemove The Messages to be removed
     */
    public function removeMessages(Message $messagesToRemove): void
    {
        $this->messages->detach($messagesToRemove);
    }

    /**
     * Returns the messages
     *
     * @return ObjectStorage<Message> $messages
     */
    public function getMessages()
    {
        return $this->messages;
    }

    /**
     * Sets the messages
     *
     * @param ObjectStorage<Message> $messages
     */
    public function setMessages(ObjectStorage $messages): void
    {
        $this->messages = $messages;
    }








    /**
     * Adds a CategoryOrganisation
     */
    public function addOfCategoryOrganisationId(CategoryOrganisation $organisationCategory): void
    {
        $this->organisationCategory->attach($organisationCategory);
    }

    /**
     * Removes a CategoryOrganisation
     *
     * @param CategoryOrganisation $organisationCategoryToRemove The CategoryOrganisation to be removed
     */
    public function removeOfCategoryOrganisationId(CategoryOrganisation $organisationCategoryToRemove): void
    {
        $this->organisationCategory->detach($organisationCategoryToRemove);
    }


    /**
     * Returns first organisationCategory
     */
    public function getFirstCategoryOrganisation()
    {
        return $this->organisationCategory[0] ?? null;
    }


    /**
     * Returns the organisationCategory
     *
     * @return ObjectStorage<CategoryOrganisation> $organisationCategory
     */
    public function getOrganisationCategory()
    {
        return $this->organisationCategory;
    }
    public function hasCategoryOrganisation(int $categoryUid)
    {
        foreach ($this->organisationCategory as $cat) {
            if ($cat->getUid() == $categoryUid) {
                return true;
            }
        }
        return false;
    }

    /**
     * Sets the organisationCategory
     *
     * @param ObjectStorage<CategoryOrganisation> $organisationCategory
     */
    public function setOrganisationCategory(ObjectStorage $organisationCategory): void
    {
        $this->organisationCategory = $organisationCategory;
    }





    /**
     * Adds a Tag
     */
    public function addMeTagId(Tag $meTagId): void
    {
        $this->meTagId->attach($meTagId);
    }

    public function addTagIfNotContains(Tag $meTagId): void
    {
        if (!$this->meTagId->contains($meTagId)) {
            //$this->isModified = true;
            $this->meTagId->attach($meTagId);
        }
    }

    /**
     * Removes a Tag
     *
     * @param Tag $meTagIdToRemove The Tag to be removed
     */
    public function removeMeTagId(Tag $meTagIdToRemove): void
    {
        $this->meTagId->detach($meTagIdToRemove);
    }

    /**
     * Returns the meTagId
     *
     * @return ObjectStorage<Tag> $meTagId
     */
    public function getMeTagId()
    {
        return $this->meTagId;
    }

    /**
     * Sets the meTagId
     *
     * @param ObjectStorage<Tag> $meTagId
     */
    public function setMeTagId(ObjectStorage $meTagId): void
    {
        $this->meTagId = $meTagId;
    }










    /**
     * Returns the meAlter
     *
     * @return string
     */
    public function getMeAlter()
    {
        if ($this->meDateOfBirth) {
            $year = intval($this->meDateOfBirth->format('Y'));
        } else {
            $year = 0;
        }
        return intval(date('Y')) - $year;
    }
    public function getMeAlterWithYear()
    {
        if ($this->meDateOfBirth) {
            $year = intval($this->meDateOfBirth->format('Y'));
        } else {
            return null;
            /*
            if ($this->meYearOfBirth) {
                $year = $this->meYearOfBirth;
            }
            */
        }
        return $year > 1900 ? intval(date('Y')) - $year : '';
    }

    public function getAgeInYear()
    {
        return $this->getMeAlterWithYear();
    }

    /**
     * Returns Telefon by CatId
     *
     * @return string
     */
    public function getMePhoneNumberIdByCatId($phone_cat)
    {
        $personPhone = $this->mePhoneNumberId;
        foreach ($personPhone as $pn) {
            $pcat = $pn->getPnPhonecategoryid();
            if (is_object($pcat) && $pcat->getUid() == $phone_cat) {
                return $pn->getPnPhonenumber();
            }
        }
        return '';
    }


    /**
     * Returns Telefon G
     *
     * @return string
     */
    public function getMePhoneNumberIdGeschaeft()
    {
        return $this->getMePhoneNumberIdByCatId(2);
    }

    /**
     * Returns Telefon P
     *
     * @return string
     */
    public function getMePhoneNumberIdPrivate()
    {
        return $this->getMePhoneNumberIdByCatId(1);
    }
    public function getMePhoneNumberIdPrivat()
    {
        return $this->getMePhoneNumberIdByCatId(1);
    }
    /**
     * Returns Telefon M
     *
     * @return string
     */
    public function getMePhoneNumberIdMobile()
    {
        return $this->getMePhoneNumberIdByCatId(5);
    }
    /**
     * Returns Telefon Fax
     *
     * @return string
     */
    public function getMePhoneNumberIdFax()
    {
        return $this->getMePhoneNumberIdByCatId(4);
    }



    /**
     * Returns E-Mail by CatId
     *
     * @return string
     */
    public function getMeEmailaddressIdByCatId($cat)
    {
        $personEmail = $this->meEmailaddressId;
        foreach ($personEmail as $pn) {
            $pcat = $pn->getEaEmailcategoryid();
            if (is_object($pcat) && $pcat->getUid() == $cat) {
                return $pn->getEaEmailaddress();
            }
        }
        return '';
    }

    /**
     * Returns E-Mail IGS
     *
     * @return string
     */
    public function getMeEmailaddressIdIgs()
    {
        return $this->getMeEmailaddressIdByCatId(4);
    }
    /**
     * Returns E-Mail geosuisse
     *
     * @return string
     */
    public function getMeEmailaddressIdGeosuisse()
    {
        return $this->getMeEmailaddressIdByCatId(5);
    }
    /**
     * Returns E-Mail Privat
     *
     * @return string
     */
    public function getMeEmailaddressIdPrivat()
    {
        return $this->getMeEmailaddressIdByCatId(2);
    }
    /**
     * Returns E-Mail Geschaeft
     *
     * @return string
     */
    public function getMeEmailaddressIdGeschaeft()
    {
        return $this->getMeEmailaddressIdByCatId(3);
    }
    /**
     * Returns E-Mail Schule
     *
     * @return string
     */
    public function getMeEmailaddressIdSchule()
    {
        return $this->getMeEmailaddressIdByCatId(6);
    }

    /**
     * Returns Sort String
     */
    public function getMeSort(): string
    {
        return mb_substr((string) $this->getLastnameFirstnameSpace(), 0, 7) . mb_substr($this->getMeCity(), 0, 4);
    }

    /**
     * Returns Anrede/Geschlecht D,F,I (getLetterAddressAnredeSprache)
     */
    public function getLetterAddressSalutation(): string
    {
        $lang = $this->getLanguageCode();
        $anrede = $this->getMeAnredeId();
        if (is_object($anrede) && !$anrede->getHideInLetterAddress()) {
            return $anrede->getAnrede($lang);
        }
        return '';
    }
    public function getSalutationForLetter(): string
    {
        return $this->getLetterAddressSalutation();
    }
    public function getSalutation(): string
    {
        $lang = $this->getLanguageCode();
        $anrede = $this->getMeAnredeId();
        if (is_object($anrede)) {
            return $anrede->getAnrede($lang);
        }
        return '';
    }
    public function getSalutationFormal(): string
    {
        $lang = $this->getLanguageCode();
        $anrede = $this->getMeAnredeId();
        if (is_object($anrede)) {
            return $this->removeTagName($anrede->getLetterFormal($lang));
        }
        return '';
    }
    public function getSalutationInformal(): string
    {
        $lang = $this->getLanguageCode();
        $anrede = $this->getMeAnredeId();
        if (is_object($anrede)) {
            return $this->removeTagName($anrede->getLetterInformal($lang));
        }
        return '';
    }
    public function getSalutationLetterFormal(): string
    {
        $lang = $this->getLanguageCode();
        $anrede = $this->getMeAnredeId();
        if (is_object($anrede)) {
            return $this->replaceTagName($anrede->getLetterFormal($lang));
        }
        return '';
    }
    public function getSalutationLetterInformal(): string
    {
        $lang = $this->getLanguageCode();
        $anrede = $this->getMeAnredeId();
        if (is_object($anrede)) {
            return $this->replaceTagName($anrede->getLetterInformal($lang));
        }
        return '';
    }

    /**
     * Returns Anrede/Geschlecht D,F,I
     */
    public function getAnredeSprache(): string
    {
        $lang = $this->getLanguageCode();

        $anrede = $this->getMeAnredeId();
        if (is_object($anrede)) {
            return $anrede->getAnrede($lang);
        }
        return '';
    }


    /**
     * Returns Anrede/Geschlecht D+F
     */
    public function getAnredeDF(): string
    {
        $lang = $this->getLanguageCode();
        if ($lang != 'F' && $lang != 'FR' && $lang != 'fr') {
            $lang = 'D';
        }
        $anrede = $this->getMeAnredeId();
        if (is_object($this->meAnredeId)) {
            return $anrede->getAnrede($lang);
        }
        return '';
    }
    /**
     * Returns Anrede/Geschlecht D (bzw. Browser Sprache)
     */
    public function getAnrede(): string
    {
        $anrede = $this->getMeAnredeId();
        if (is_object($anrede)) {
            return $anrede->getAnrede($this->getLanguageCode());
        }
        return '';
    }




    /**
     * Returns the meIsBerufsbildner
     *
     * @return boolean
     */
    public function getMeIsBerufsbildner()
    {
        return $this->meIsBerufsbildner;
    }

    /**
     * Sets the meIsBerufsbildner
     *
     * @param boolean $meIsBerufsbildner
     */
    public function setMeIsBerufsbildner($meIsBerufsbildner): void
    {
        $this->meIsBerufsbildner = $meIsBerufsbildner;
    }

    /**
     * Returns the boolean state of meIsBerufsbildner
     *
     * @return boolean
     */
    public function isMeIsBerufsbildner()
    {
        return $this->meIsBerufsbildner;
    }



    /**
     * Returns the meIsLernende
     *
     * @return boolean
     */
    public function getMeIsLernende()
    {
        return $this->meIsLernende;
    }

    /**
     * Sets the meIsLernende
     *
     * @param boolean $meIsLernende
     */
    public function setMeIsLernende($meIsLernende): void
    {
        $this->meIsLernende = $meIsLernende;
    }

    /**
     * Returns the boolean state of meIsLernende
     *
     * @return boolean
     */
    public function isMeIsLernende()
    {
        return $this->meIsLernende;
    }

    /**
     * Returns the meKlasse
     *
     * @return string
     */
    public function getMeKlasse()
    {
        return $this->meKlasse;
    }

    /**
     * Sets the meKlasse
     *
     * @param string $meKlasse
     */
    public function setMeKlasse($meKlasse): void
    {
        $this->meKlasse = $meKlasse;
    }

    /**
     * Returns the meExternIdNamespace
     *
     * @return string
     */
    public function getMeExternIdNamespace()
    {
        return $this->meExternIdNamespace;
    }

    /**
     * Sets the meExternIdNamespace
     *
     * @param string $meExternIdNamespace
     */
    public function setMeExternIdNamespace($meExternIdNamespace): void
    {
        $this->meExternIdNamespace = $meExternIdNamespace;
    }

    /**
     * Returns the meExternId
     *
     * @return string
     */
    public function getMeExternId()
    {
        return $this->meExternId;
    }

    /**
     * Sets the meExternId
     *
     * @param string $meExternId
     */
    public function setMeExternId($meExternId): void
    {
        $this->meExternId = $meExternId;
    }


    /**
     * Returns the meBmTyp
     *
     * @return string
     */
    public function getMeBmTyp()
    {
        return $this->meBmTyp;
    }

    /**
     * Sets the meBmTyp
     *
     * @param string $meBmTyp
     */
    public function setMeBmTyp($meBmTyp): void
    {
        $this->meBmTyp = $meBmTyp;
    }


    /**
     * Returns the meHeimatort
     *
     * @return string
     */
    public function getMeHeimatort()
    {
        return $this->meHeimatort;
    }

    /**
     * Sets the meHeimatort
     *
     * @param string $meHeimatort
     */
    public function setMeHeimatort($meHeimatort): void
    {
        $this->meHeimatort = $meHeimatort;
    }


    /**
     * Returns the meLbTyp
     *
     * @return string
     */
    public function getMeLbTyp()
    {
        return $this->meLbTyp;
    }

    /**
     * Sets the meLbTyp
     *
     * @param string $meLbTyp
     */
    public function setMeLbTyp($meLbTyp): void
    {
        $this->meLbTyp = $meLbTyp;
    }


    /**
     * Returns the meBranche
     *
     * @return string
     */
    public function getMeBranche()
    {
        return $this->meBranche;
    }

    /**
     * Sets the meBranche
     *
     * @param string $meBranche
     */
    public function setMeBranche($meBranche): void
    {
        $this->meBranche = $meBranche;
    }




    /**
     * Returns Anrede ohne Name
     */
    public function getBriefanrede(): string
    {
        // evtl. noch Sprache rein

        $anrede = $this->getMeAnredeId();
        if (is_object($anrede)) {
            $anredeText = $anrede->getBriefanrede($this->getLanguageCode());
        } else {
            $anredeText = '';
        }
        $anredeBrief = $this->replaceTagName($anredeText);
        return mb_substr($anredeBrief, 0, 65);
    }
    
    public function getLetterSalutation()
    {
        return $this->getBriefanrede();
    }
    
    /**
     * Returns Anrede
     *
     * @return string
     */
    public function getBriefanredeDF()
    {
        // evtl. noch Sprache rein
        $lang = $this->getLanguageCode();
        if ($lang != 'F' && $lang != 'FR' && $lang != 'fr') {
            $lang = 'D';
        }
        $anrede = $this->getMeAnredeId();
        if (is_object($anrede)) {
            $anredeText = $anrede->getBriefanrede($lang);
        } else {
            $anredeText = '';
        }
        $anredeBrief = $this->replaceTagName($anredeText);
        return mb_substr($anredeBrief, 0, 65);
    }

    /**
     * Returns Anrede ohne Name
     *
     * @return string
     */
    public function getBriefanredeOhneName()
    {
        // evtl. noch Sprache rein

        $anrede = $this->getMeAnredeId();
        if (is_object($anrede)) {
            $anredeText = $anrede->getBriefanrede($this->getLanguageCode());
        } else {
            $anredeText = '';
        }
        $anredeBrief = $this->removeTagName($anredeText);
        return mb_substr($anredeBrief, 0, 65);
    }


    /**
     * Returns Anrede
     *
     * @return string
     */
    public function getBriefanredeOhneNameDF()
    {
        // evtl. noch Sprache rein
        $lang = $this->getLanguageCode();
        if ($lang != 'F' && $lang != 'FR' && $lang != 'fr') {
            $lang = 'D';
        }
        $anrede = $this->getMeAnredeId();
        if (is_object($anrede)) {
            $anredeText = $anrede->getBriefanrede($lang);
        } else {
            $anredeText = '';
        }

        $anredeBrief = $this->removeTagName($anredeText);
        return mb_substr($anredeBrief, 0, 65);
    }


    /**
     * Returns the meLehrbetrieb
     *
     * @return Organisation
     */
    public function getMeLehrbetrieb()
    {
        return $this->meLehrbetrieb;
    }

    /**
     * Sets the meLehrbetrieb
     *
     * @param Organisation $meLehrbetrieb
     */
    public function setMeLehrbetrieb($meLehrbetrieb): void
    {
        $this->meLehrbetrieb = $meLehrbetrieb;
    }



    public function getExtraBetragCurrentYear()
    {
        return 20.00;
    }
    public function getExtraBetragLastYear()
    {
        return 0;
        /*	  $eintritt = $this->getMeGeosuisseStart();
        if( !$eintritt || $eintritt < new \DateTime('2016-01-01') )
          return 20.00;
        else
          return 0;
        */
    }


    public function getEmail()
    {
        return $this->getMeEmail();
    }

    // FIBU: email to use for invoice mail
    public function getInvoiceEmail()
    {
        return $this->getMeEmail();
    }
    // FIBU: combine all invoices in one mail
    public function getOneInvoicePerMail(): ?bool
    {
        return false;
    }
    // FIBU: Extra subject for invoices
    public function getInvoiceMailSubject()
    {
        return null;
    }



    public function getSimilar()
    {
        $personRepository = GeneralUtility::makeInstance(PersonRepository::class);
        $personsRaw = $personRepository->findSimilar($this);
        return $this->similarAddErrors($personsRaw);
    }
    public function getSimilarWeak()
    {
        $personRepository = GeneralUtility::makeInstance(PersonRepository::class);
        $personsRaw = $personRepository->findSimilarWeak($this);
        return $this->similarAddErrors($personsRaw);
    }


    /**
     * Adds a ContactVerband
     */
    public function addMeContactVerband(ContactVerband $meContactVerband): void
    {
        $this->meContactVerband->attach($meContactVerband);
    }

    /**
     * Removes a ContactVerband
     *
     * @param ContactVerband $meContactVerbandToRemove The ContactVerband to be removed
     */
    public function removeMeContactVerband(ContactVerband $meContactVerbandToRemove): void
    {
        $this->meContactVerband->detach($meContactVerbandToRemove);
    }

    /**
     * Returns the meContactVerband
     *
     * @return ObjectStorage<ContactVerband> $meContactVerband
     */
    public function getMeContactVerband()
    {
        return $this->meContactVerband;
    }
    public function getContactVerbandByVerband(Verband $verband)
    {
        return $this->getContactVerbandById($verband->getUid());
    }
    public function getContactVerbandById($verbandId)
    {
        foreach ($this->meContactVerband as $mv) {
            //echo('mv='. $mv->getVerband()->getUid() . '==='. $verbandId);
            if ($mv->getVerband()->getUid() == $verbandId) {
                return $mv;
            }
        }
        return false;
    }
    /*
    public function getMeContactVerband5()
    {
        return $this->getMeContactVerbandById(5);
    }
    */
    /**
     * Sets the meContactVerband
     *
     * @param ObjectStorage<ContactVerband> $meContactVerband
     */
    public function setMeContactVerband(ObjectStorage $meContactVerband): void
    {
        $this->meContactVerband = $meContactVerband;
    }

    /**
     * Get the value of meBriefanrede
     *
     * @return string
     */
    public function getMeBriefanrede()
    {
        return $this->meBriefanrede;
    }

    /**
     * Set the value of meBriefanrede
     *
     * @param string $meBriefanrede
     *
     * @return self
     */
    public function setMeBriefanrede($meBriefanrede)
    {
        $this->meBriefanrede = $meBriefanrede;

        return $this;
    }

    /**
     * Get the value of meIsFamily
     *
     * @return boolean
     */
    public function getMeIsFamily()
    {
        return $this->meIsFamily;
    }

    /**
     * Set the value of meIsFamily
     *
     * @param boolean $meIsFamily
     *
     * @return self
     */
    public function setMeIsFamily($meIsFamily)
    {
        $this->meIsFamily = $meIsFamily;

        return $this;
    }

    /**
     * Get the value of meFamily
     *
     * @return Person
     */
    public function getMeFamily()
    {
        return $this->meFamily;
    }
    public function getFamilyMembers()
    {
        $personRepository = GeneralUtility::makeInstance(PersonRepository::class);
        return $personRepository->findFamilyMembers($this->meFamily, $this->uid);
    }

    /**
     * Set the value of meFamily
     *
     * @return self
     */
    public function setMeFamily(Person $meFamily = null)
    {
        $this->meFamily = $meFamily;

        return $this;
    }



    /**
     * Get the value of meInvoiceTo
     *
     * @return Person
     */
    public function getMeInvoiceTo()
    {
        return $this->meInvoiceTo;
    }
    public function getInvoiceToMembers()
    {
        $personRepository = GeneralUtility::makeInstance(PersonRepository::class);
        return $personRepository->findInvoiceToMembers($this->meInvoiceTo, $this->uid);
    }

    /**
     * Set the value of meInvoiceTo
     *
     * @return self
     */
    public function setMeInvoiceTo(Person $meInvoiceTo = null)
    {
        $this->meInvoiceTo = $meInvoiceTo;

        return $this;
    }



    /**
     * Get the value of meIsSammelinvoice
     *
     * @return boolean
     */
    public function getMeIsSammelinvoice()
    {
        return $this->meIsSammelinvoice;
    }

    /**
     * Set the value of meIsSammelinvoice
     *
     * @param boolean $meIsSammelinvoice
     *
     * @return self
     */
    public function setMeIsSammelinvoice($meIsSammelinvoice)
    {
        $this->meIsSammelinvoice = $meIsSammelinvoice;

        return $this;
    }

    /**
     * Generates a qr-code and returns the html for the image
     * @param int $size
     * @param char $error_level
     */
    public function getQrCode($size = 3, $error_level = 'L')
    {
        $text = 'http://www.panoramarundweg.ch/q/?p=' . $this->getMeAddressid();
        $cmd = '';
        $cmd .= 'qrencode ' . escapeshellarg($text) . ' -s ' . $size . ' -l ' . $error_level . ' -o ' . getcwd() . '/typo3temp/temp_' . md5($text . $size . $error_level) . '.png';
        system($cmd);
        return '<img src="' . ($_SERVER['HTTPS'] == 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/typo3temp/temp_' . md5($text . $size . $error_level) . '.png?url=' . $text . '&s=' . $size . '&l=' . $error_level . '" border="0" />';
    }
    public function getIsOrganisation()
    {
        return false;
    }
    public function getOrganisationName()
    {
        return '';
    }

    public function getContactTag()
    {
        return $this->contactTag;
    }
    public function setContactTag(ContactTag $contactTag): void
    {
        $this->contactTag = $contactTag;
    }

    public function getContactContactByOrganisation()
    {
        if ($this->contactContactByOrganisation === null && $this->getUid() > 0) {
            $contactContactRepository = GeneralUtility::makeInstance(ContactContactRepository::class);
            $contactContacts = $contactContactRepository->findBy([
                'organisation' => $this,
            ]);
            $this->contactContactByOrganisation = $contactContacts->toArray();
        }
        return $this->contactContactByOrganisation;
    }
    public function getContactContactByContact()
    {
        if ($this->contactContactByContact === null && $this->getUid() > 0) {
            $contactContactRepository = GeneralUtility::makeInstance(ContactContactRepository::class);
            $contactContacts = $contactContactRepository->findBy([
                'contact' => $this,
            ]);
            $this->contactContactByContact = $contactContacts->toArray();
        }
        return $this->contactContactByContact;
    }

    public function getContactContact()
    {
        if ($this->type == 'Organisation') {
            return $this->getContactContactByOrganisation();
        }
        return $this->getContactContactByContact();
    }

    /**
     * Get the value of mustReviewed
     *
     * @return boolean
     */
    public function getMustReviewed()
    {
        return $this->mustReviewed;
    }

    /**
     * Set the value of mustReviewed
     *
     * @param boolean $mustReviewed
     *
     * @return self
     */
    public function setMustReviewed($mustReviewed)
    {
        $this->mustReviewed = $mustReviewed;

        return $this;
    }


    /**
     * Get the value of hash
     *
     * @return string
     */
    public function getHash()
    {
        return $this->hash;
    }

    /**
     * Set the value of hash
     *
     * @param string $hash
     *
     * @return self
     */
    public function setHash($hash)
    {
        $this->hash = $hash;

        return $this;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        parent::initStorageObjects();
        $this->meCertificates = new ObjectStorage();
        $this->mePhoneNumberId = new ObjectStorage();
        $this->meEmailaddressId = new ObjectStorage();
        $this->messages = new ObjectStorage();
        $this->meTagId = new ObjectStorage();
        $this->meContactVerband = new ObjectStorage();
    }

    private function similarAddErrors($personsRaw)
    {
        $personsSimilar = [];
        foreach ($personsRaw as $m) {
            $isOk = $m->getEmail() == '' || $this->getEmail() == '' || $m->getEmail() == $this->getEmail();
            $errorAnrede = $m->getMeAnredeId() != $this->getMeAnredeId();
            $errorLanguage = $m->getMeLanguageid() != $this->getMeLanguageid();
            $error = $errorAnrede || $errorLanguage;
            if ($error) {
                $class = $isOk ? 'merge-error-ok' : 'merge-error-maybe';
                $class .= ' error';
            } else {
                $class = $isOk ? 'merge-ok' : 'merge-maybe';
            }
            $personsSimilar[] = [
                'person' => $m,
                'class' => $class,
                'error' => [
                    'found' => $error,
                    'anrede' => $errorAnrede,
                    'language' => $errorLanguage,
                ],
                'checked' => $isOk,
            ];
        }
        return $personsSimilar;
    }

    // public function getFrontendUserOwnerUids(int $frontendUserId, $acl = 0)
    // {
    //     $contactUids = [];
    //     if ($frontendUserId > 0) {
    //         $personRepository = GeneralUtility::makeInstance(PersonRepository::class);
    //         $contacts = $personRepository->findByFrontendUser($frontendUserId, true);
    //         if (!empty($contacts)) {
    //             foreach ($contacts as $contact) {
    //                 $contactUids[] = (int) $contact ['uid'];
    //             }
    //             //$ret['Person'] = $contactUids;
    //         }
    //     }
    //     if (!empty($contactUids)) {
    //         $contactContactRepository = GeneralUtility::makeInstance(ContactContactRepository::class);
    //         $relations = $contactContactRepository->findRelationByContact($contactUids, true);
    //         if (!empty($relations)) {
    //             foreach ($relations as $relation) {
    //                 if ($relation['acl'] >= $acl) {
    //                     $contactUids[] = (int) $relation ['organisation'];
    //                 }
    //             }
    //         }
    //     }
    //     return $contactUids;
    // }

    
    public function frontendUserHasAccess(int $frontendUserUid): bool
    {
        $contactContacts = $this->getContactContact();
        if (!empty($contactContacts)) {
            foreach ($contactContacts as $contactContact) {
                $contact = $contactContact->getContact();
                $frontendUser = $contact->getFrontendUser();
                if ($frontendUser->getUid() === $frontendUserUid) {
                    return true;
                }
            }
        }
        return false;
    }

    public function frontendUserHasPermissionRead(int $frontendUserId): bool
    {
        return $this->frontendUserHasAccess($frontendUserId);
    }

    public function frontendUserHasPermissionWrite(int $frontendUserId): bool
    {
        return $this->frontendUserHasAccess($frontendUserId);
        // $contactUids = $this->getFrontendUserOwnerUids($frontendUserId, 0);
        // if (!empty($contactUids) && in_array($object->getUid(), $contactUids)) {
        //     return true;
        // }
        // return false;
    }


}
