<?php

declare(strict_types=1);

namespace Internetgalerie\IgsCrm\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class ContactCertificate extends AbstractEntity
{
    /**
     * sorting
     *
     * @var integer
     */
    protected $sorting = 0;

    /**
     * certificateYear
     *
     * @var int
     */
    protected $certificateYear = null;

    /**
     * academy
     *
     * @var string
     */
    protected $academy = '';


    /**
     * certificate
     *
     * @var Certificate
     */
    protected $certificate = null;

    /**
     * contact
     *
     * @var Person
     */
    protected $contact = null;
 
    /**
     * Returns the sorting
     *
     * @return integer
     */
    public function getSorting()
    {
        return $this->sorting;
    }
 
    /**
     * Sets the sorting
     *
     * @param integer $sorting
     */
    public function setSorting($sorting): void
    {
        $this->sorting = $sorting;
    }
    /**
     * Returns the certificateYear
     *
     * @return int
     */

    /**
     * Returns the academy
     *
     * @return string
     */
    public function getAcademy()
    {
        return $this->academy;
    }
    
    public function getYearAcademy()
    {
        $ret = $this->certificateYear > 0 ? strval($this->certificateYear) : '';
        if ($this->academy) {
            return $ret . ($ret ? ' ' : '') . $this->academy;
        }
        return $ret;
    }
    public function getAcademyYear()
    {
        $ret = $this->certificateYear > 0 ? strval($this->certificateYear) : '';
        if ($this->academy) {
            return $this->academy . ($ret ? ' ' : '') . $ret;
        }
        return $ret;
    }

    /**
     * Sets the academy
     *
     * @param string $academy
     */
    public function setAcademy($academy): void
    {
        $this->academy = $academy;
    }

    public function getCertificateYear()
    {
        return $this->certificateYear;
    }

    /**
     * Sets the certificateYear
     */
    public function setCertificateYear(int $certificateYear = null): void
    {
        $this->certificateYear = $certificateYear;
    }
    /**
     * Returns the certificate
     *
     * @return Certificate
     */
    public function getCertificate()
    {
        return $this->certificate;
    }

    /**
     * Sets the certificate
     */
    public function setCertificate(Certificate $certificate): void
    {
        $this->certificate = $certificate;
    }

    /**
     * Returns the contact
     *
     * @return Person
     */
    public function getContact()
    {
        return $this->contact;
    }

    /**
     * Sets the contact
     */
    public function setContact(Person $contact): void
    {
        $this->contact = $contact;
    }
}
