<?php

declare(strict_types=1);

namespace Internetgalerie\IgsCrm\Domain\Model;

use DateTime;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class ContactContact extends AbstractEntity
{
    /**
     * active
     *
     * @var bool
     */
    protected $active = false;

    /**
     * startDate
     *
     * @var DateTime
     */
    protected $startDate = null;

    /**
     * endDate
     *
     * @var DateTime
     */
    protected $endDate = null;

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * acl
     *
     * @var int
     */
    protected $acl = 0;

    /**
     * contact
     *
     * @var Person
     */
    protected $contact = null;

    /**
     * organisation
     *
     * @var Person
     */
    protected $organisation = null;

    /**
     * relationType
     *
     * @var RelationType
     */
    protected $relationType = null;

    /**
     * relationFunction
     *
     * @var RelationFunction
     */
    protected $relationFunction = null;

    /**
     * Returns the active
     *
     * @return bool
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Sets the active
     */
    public function setActive(bool $active): void
    {
        $this->active = $active;
    }

    /**
     * Returns the boolean state of active
     *
     * @return bool
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * Returns the startDate
     *
     * @return DateTime
     */
    public function getStartDate()
    {
        return $this->startDate;
    }

    /**
     * Sets the startDate
     */
    public function setStartDate(DateTime $startDate = null): void
    {
        $this->startDate = $startDate;
    }

    /**
     * Returns the endDate
     *
     * @return DateTime
     */
    public function getEndDate()
    {
        return $this->endDate;
    }

    /**
     * Sets the endDate
     */
    public function setEndDate(DateTime $endDate = null): void
    {
        $this->endDate = $endDate;
    }

    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     */
    public function setTitle(string $title): void
    {
        $this->title = $title;
    }

    /**
     * Returns the acl
     *
     * @return int
     */
    public function getAcl()
    {
        return $this->acl;
    }

    /**
     * Sets the acl
     */
    public function setAcl(int $acl): void
    {
        $this->acl = $acl;
    }

    /**
     * Returns the contact
     *
     * @return Contact
     */
    public function getContact()
    {
        return $this->contact;
    }

    /**
     * Sets the contact
     */
    public function setContact(Contact $contact): void
    {
        $this->contact = $contact;
    }

    /**
     * Returns the organisation
     *
     * @return Contact
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }

    /**
     * Sets the organisation
     */
    public function setOrganisation(Contact $organisation): void
    {
        $this->organisation = $organisation;
    }

    /**
     * Returns the relationType
     *
     * @return RelationType
     */
    public function getRelationType()
    {
        return $this->relationType;
    }

    /**
     * Sets the relationType
     */
    public function setRelationType(RelationType $relationType = null): void
    {
        $this->relationType = $relationType;
    }

    /**
     * Returns the relationFunction
     *
     * @return RelationFunction
     */
    public function getRelationFunction()
    {
        return $this->relationFunction;
    }

    /**
     * Sets the relationFunction
     */
    public function setRelationFunction(RelationFunction $relationFunction = null): void
    {
        $this->relationFunction = $relationFunction;
    }
}
