<?php

namespace Internetgalerie\IgsCrm\Domain\Model;
use TYPO3\CMS\Core\Database\Connection;

use DateTime;
use Internetgalerie\IgsCrm\Domain\Repository\TagverbandRepository;
use PDO;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\Generic\LazyLoadingProxy;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class ContactVerband extends AbstractEntity
{
    /**
     * journal
     *
     * @var Zeitschrift
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $journal = null;

    /**
     * verband
     *
     * @var Verband
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $verband = null;

    /**
     * company
     *
     * @var Organisation
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $company = null;


    /**
     * organisationId
     *
     * @var Organisation
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $organisationId = null;

    /**
     * invoiceAddress
     *
     * @var Contact
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $invoiceAddress = null;

    /**
     * correspondenceAddress
     *
     * @var Contact
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $correspondenceAddress = null;

    /**
     * tags
     *
     * @var ObjectStorage<Tag>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $tags = null;

    /**
     * commissions
     *
     * @var ObjectStorage<Commission>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $commissions = null;

    /**
     * sektionen
     *
     * @var ObjectStorage<Sektion>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $sektionen = null;

    /**
     * categories
     *
     * @var ObjectStorage<Category>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $categories = null;

    /**
     * organisations
     *
     * @var ObjectStorage<Organisation>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $organisations = null;
    /**
     * active
     *
     * @var bool
     */
    protected $active = false;

    /**
     * startDate
     *
     * @var DateTime
     */
    protected $startDate = null;

    /**
     * endDate
     *
     * @var DateTime
     */
    protected $endDate = null;

    /**
     * journalEnd
     *
     * @var DateTime
     */
    protected $journalEnd = null;
    /**
     * journalFreiwillig
     *
     * @var bool
     */
    protected $journalFreiwillig = false;

    /**
     * journalIsFree1
     *
     * @var bool
     */
    protected $journalIsFree1 = false;

    /**
     * journalIsFree2
     *
     * @var bool
     */
    protected $journalIsFree2 = false;

    /**
     * extraTextfield1
     *
     * @var string
     */
    protected $extraTextfield1 = '';

    /**
     * extraTextfield2
     *
     * @var string
     */
    protected $extraTextfield2 = '';

    /**
     * extraTextfield3
     *
     * @var string
     */
    protected $extraTextfield3 = '';

    /**
     * extraTextarea1
     *
     * @var string
     */
    protected $extraTextarea1 = '';

    /**
     * extraTextarea2
     *
     * @var string
     */
    protected $extraTextarea2 = '';

    /**
     * extraTextarea3
     *
     * @var string
     */
    protected $extraTextarea3 = '';

    /**
     * importSource
     *
     * @var string
     */
    protected $importSource = '';
    
    /**
     * externalId
     *
     * @var string
     */
    protected $externalId = '';

    /**
     * address
     *
     * @var string
     */
    protected $address = '';

    /**
     * address2
     *
     * @var string
     */
    protected $address2 = '';

    /**
     * address3
     *
     * @var string
     */
    protected $address3 = '';

    /**
     * pobox
     *
     * @var string
     */
    protected $pobox = '';

    /**
     * zip
     *
     * @var string
     */
    protected $zip = '';

    /**
     * city
     *
     * @var string
     */
    protected $city = '';

    /**
     * email
     *
     * @var string
     */
    protected $email = '';

    /**
     * contact
     *
     * @var Contact
     */
    protected $contact = null;

    /**
     * mitgliedschaft
     *
     * @var Mitgliedschaft
     */
    protected $mitgliedschaft = null;


    /**
     * invoiceMode
     *
     * @var int
     */
    protected $invoiceMode = 0;

    /**
     * invoiceDeliveryMode
     *
     * @var int
     */
    protected $invoiceDeliveryMode = 0;

    /**
     * invoiceMail
     *
     * @var string
     */
    protected $invoiceMail;

    /**
     * invoiceMailSubject
     *
     * @var string
     */
    protected $invoiceMailSubject;

    /**
     * invoiceReference
     *
     * @var string
     */
    protected $invoiceReference;

    /**
     * invoiceDescription
     *
     * @var string
     */
    protected $invoiceDescription;

    /**
     * correspondenceMode
     *
     * @var int
     */
    protected $correspondenceMode = 0;

    /**
     * correspondenceDeliveryMode
     *
     * @var int
     */
    protected $correspondenceDeliveryMode = 0;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Returns the active
     *
     * @return bool
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Sets the active
     *
     * @param bool $active
     */
    public function setActive($active): void
    {
        $this->active = $active;
    }

    /**
     * Returns the boolean state of active
     *
     * @return bool
     */
    public function isActive()
    {
        return $this->active;
    }

    
    /**
     * Returns the startDate
     *
     * @return DateTime
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    public function getIsNew()
    {
        return !$this->getActive() || $this->startDate->format('Y') == date('Y');
    }

    public function getActiveWithDates(): bool
    {
        $now = new DateTime();
        return $this->active && ($this->startDate === null || $this->startDate <= $now) && ($this->endDate === null || $this->endDate > $now);
    }

    
    /**
     * Sets the startDate
     */
    public function setStartDate(DateTime $startDate = null): void
    {
        $this->startDate = $startDate;
    }

    /**
     * Returns the endDate
     *
     * @return DateTime
     */
    public function getEndDate()
    {
        return $this->endDate;
    }

    /**
     * Sets the endDate
     */
    public function setEndDate(DateTime $endDate = null): void
    {
        $this->endDate = $endDate;
    }

    /**
     * Returns the journal
     *
     * @return Zeitschrift
     */
    public function getJournal()
    {
        if ($this->journal instanceof LazyLoadingProxy) {
            $this->journal->_loadRealInstance();
        }
        return $this->journal;
    }

    /**
     * Sets the journal
     *
     * @param Zeitschrift $journal
     */
    public function setJournal($journal): void
    {
        $this->journal = $journal;
    }


    public function getJournalAmount()
    {
        // Existiert Betrag bei dieser Mitgliedschaft
        if ($this->mitgliedschaft && $this->mitgliedschaft->getBetragIsTotal()) {
            return 0;
        }
        $zeitschrift = $this->getJournal();
        if ($zeitschrift) {
            // Wird isFree1 verwendet und ist aktiv
            if ($this->journalIsFree1 && $this->verband->getTitleJournalIsFree1()) {
                return 0;
            }
            // Wird isFree1 verwendet und ist aktiv
            if ($this->journalIsFree2 && $this->verband->getTitleJournalIsFree2()) {
                return 0;
            }
            // journalEnd
            if ($this->isJournalActive()) {
                // @todo kann gelöscht werden journalFreiwillig
                /*
                if ($this->getJournalFreiwillig() && 0) {
                    return $zeitschrift->getBetrag();
                } else {
                */
                return $zeitschrift->getBetragWithAlter($this->contact->getMeAlterWithYear());
                //}
            }
            return 0;// Inaktives Journal
        }
        return 0;
    }
    public function getVerbandExtraBetragValue()
    {
        // Existiert Betrag bei dieser Mitgliedschaft
        if ($this->mitgliedschaft && $this->mitgliedschaft->getBetragIsTotal()) {
            return 0;
        }
        return $this->getVerband()
->getExtraBetragValue();
    }
    /**
     * Amount for membership for this contact
     */
    public function getMembershipAmount($period = null)
    {
        $mitgliedschaft = $this->getMitgliedschaft();
        if (!$mitgliedschaft) {
            return null;
        }
        return $mitgliedschaft->getAmountForContact($this->contact, $period);// @todo only if period is a year
    }


    /**
     * Returns the journalEnd
     *
     * @return DateTime
     */
    public function getJournalEnd()
    {
        return $this->journalEnd;
    }
    public function isJournalActive()
    {
        return $this->journalEnd === null || $this->journalEnd > new DateTime() || $this->journalEnd <= new DateTime(
            '1901-01-01'
        );
    }

    /**
     * Sets the journalEnd
     */
    public function setJournalEnd(DateTime $journalEnd = null): void
    {
        $this->journalEnd = $journalEnd;
    }

    /**
     * Returns the journalFreiwillig
     *
     * @return bool
     */
    public function getJournalFreiwillig()
    {
        return $this->journalFreiwillig;
    }

    /**
     * Sets the journalFreiwillig
     *
     * @param bool $journalFreiwillig
     */
    public function setJournalFreiwillig($journalFreiwillig): void
    {
        $this->journalFreiwillig = $journalFreiwillig;
    }

    /**
     * Returns the boolean state of journalFreiwillig
     *
     * @return bool
     */
    public function isJournalFreiwillig()
    {
        return $this->journalFreiwillig;
    }

    /**
     * Returns the journalIsFree1
     *
     * @return bool
     */
    public function getJournalIsFree1()
    {
        return $this->journalIsFree1;
    }

    /**
     * Sets the journalIsFree1
     *
     * @param bool $journalIsFree1
     */
    public function setJournalIsFree1($journalIsFree1): void
    {
        $this->journalIsFree1 = $journalIsFree1;
    }

    /**
     * Returns the boolean state of journalIsFree1
     *
     * @return bool
     */
    public function isJournalIsFree1()
    {
        return $this->journalIsFree1;
    }

    /**
     * Returns the journalIsFree2
     *
     * @return bool
     */
    public function getJournalIsFree2()
    {
        return $this->journalIsFree2;
    }

    /**
     * Sets the journalIsFree2
     *
     * @param bool $journalIsFree2
     */
    public function setJournalIsFree2($journalIsFree2): void
    {
        $this->journalIsFree2 = $journalIsFree2;
    }

    /**
     * Returns the boolean state of journalIsFree2
     *
     * @return bool
     */
    public function isJournalIsFree2()
    {
        return $this->journalIsFree2;
    }

    /**
     * Returns the extraTextfield1
     *
     * @return string
     */
    public function getExtraTextfield1()
    {
        return $this->extraTextfield1;
    }

    /**
     * Sets the extraTextfield1
     *
     * @param string $extraTextfield1
     */
    public function setExtraTextfield1($extraTextfield1): void
    {
        $this->extraTextfield1 = $extraTextfield1;
    }

    /**
     * Returns the extraTextfield2
     *
     * @return string
     */
    public function getExtraTextfield2()
    {
        return $this->extraTextfield2;
    }

    /**
     * Sets the extraTextfield2
     *
     * @param string $extraTextfield2
     */
    public function setExtraTextfield2($extraTextfield2): void
    {
        $this->extraTextfield2 = $extraTextfield2;
    }

    /**
     * Returns the extraTextfield3
     *
     * @return string
     */
    public function getExtraTextfield3()
    {
        return $this->extraTextfield3;
    }

    /**
     * Sets the extraTextfield3
     *
     * @param string $extraTextfield3
     */
    public function setExtraTextfield3($extraTextfield3): void
    {
        $this->extraTextfield3 = $extraTextfield3;
    }

    /**
     * Returns the extraTextarea1
     *
     * @return string
     */
    public function getExtraTextarea1()
    {
        return $this->extraTextarea1;
    }

    /**
     * Sets the extraTextarea1
     *
     * @param string $extraTextarea1
     */
    public function setExtraTextarea1($extraTextarea1): void
    {
        $this->extraTextarea1 = $extraTextarea1;
    }

    /**
     * Returns the extraTextarea2
     *
     * @return string
     */
    public function getExtraTextarea2()
    {
        return $this->extraTextarea2;
    }

    /**
     * Sets the extraTextarea2
     *
     * @param string $extraTextarea2
     */
    public function setExtraTextarea2($extraTextarea2): void
    {
        $this->extraTextarea2 = $extraTextarea2;
    }

    /**
     * Returns the extraTextarea3
     *
     * @return string
     */
    public function getExtraTextarea3()
    {
        return $this->extraTextarea3;
    }

    /**
     * Sets the extraTextarea3
     *
     * @param string $extraTextarea3
     */
    public function setExtraTextarea3($extraTextarea3): void
    {
        $this->extraTextarea3 = $extraTextarea3;
    }

    /**
     * Returns the importSource
     *
     * @return string
     */
    public function getImportSource()
    {
        return $this->importSource;
    }

    /**
     * Sets the importSource
     *
     * @param string $importSource
     */
    public function setImportSource($importSource): void
    {
        $this->importSource = $importSource;
    }

    
    /**
     * Returns the externalId
     *
     * @return string
     */
    public function getExternalId()
    {
        return $this->externalId;
    }

    /**
     * Sets the externalId
     *
     * @param string $externalId
     */
    public function setExternalId($externalId): void
    {
        $this->externalId = $externalId;
    }


    /**
     * Returns the address
     *
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * Sets the address
     *
     * @param string $address
     */
    public function setAddress($address): void
    {
        $this->address = $address;
    }

    /**
     * Returns the address2
     *
     * @return string
     */
    public function getAddress2()
    {
        return $this->address2;
    }

    /**
     * Sets the address2
     *
     * @param string $address2
     */
    public function setAddress2($address2): void
    {
        $this->address2 = $address2;
    }

    /**
     * Returns the address3
     *
     * @return string
     */
    public function getAddress3()
    {
        return $this->address3;
    }

    /**
     * Sets the address3
     *
     * @param string $address3
     */
    public function setAddress3($address3): void
    {
        $this->address3 = $address3;
    }

    /**
     * Returns the pobox
     *
     * @return string
     */
    public function getPobox()
    {
        return $this->pobox;
    }

    /**
     * Sets the pobox
     *
     * @param string $pobox
     */
    public function setPobox($pobox): void
    {
        $this->pobox = $pobox;
    }

    /**
     * Returns the zip
     *
     * @return string
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * Sets the zip
     *
     * @param string $zip
     */
    public function setZip($zip): void
    {
        $this->zip = $zip;
    }

    /**
     * Returns the city
     *
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * Sets the city
     *
     * @param string $city
     */
    public function setCity($city): void
    {
        $this->city = $city;
    }

    /**
     * Returns the email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Sets the email
     *
     * @param string $email
     */
    public function setEmail($email): void
    {
        $this->email = $email;
    }

    /**
     * Returns the contact
     *
     * @return Contact
     */
    public function getContact()
    {
        return $this->contact;
    }
    public function getPerson()
    {
        return $this->contact;
    }

    /**
     * Sets the contact
     */
    public function setContact(Contact $contact): void
    {
        $this->contact = $contact;
    }

    /**
     * Returns the verband
     *
     * @return Verband
     */
    public function getVerband()
    {
        if ($this->verband instanceof LazyLoadingProxy) {
            $this->verband = $this->verband->_loadRealInstance();
        }
        return $this->verband;
    }
    public function getTenant()
    {
        return $this->getVerband();
    }
    /**
     * Sets the verband
     */
    public function setVerband(Verband $verband): void
    {
        $this->verband = $verband;
    }

    /**
     * Returns the mitgliedschaft
     *
     * @return Mitgliedschaft
     */
    public function getMitgliedschaft()
    {
        return $this->mitgliedschaft;
    }
    public function getMembership()
    {
        return $this->mitgliedschaft;
    }

    /**
     * Sets the mitgliedschaft
     */
    public function setMitgliedschaft(Mitgliedschaft $mitgliedschaft = null): void
    {
        $this->mitgliedschaft = $mitgliedschaft;
    }

    /**
     * Returns the company
     *
     * @return Organisation
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Sets the company
     */
    public function setCompany(Organisation $company): void
    {
        $this->company = $company;
    }
    
    /**
     * Returns the invoiceMode
     *
     * @return int
     */
    public function getInvoiceMode()
    {
        return $this->invoiceMode;
    }

    /**
     * Sets the invoiceMode
     *
     * @param int $invoiceMode
     */
    public function setInvoiceMode($invoiceMode): void
    {
        $this->invoiceMode = $invoiceMode;
    }
    
    public function getInvoiceDeliveryMode(): int
    {
        return $this->invoiceDeliveryMode;
    }

    public function setInvoiceDeliveryMode(int $invoiceDeliveryMode): void
    {
        $this->invoiceDeliveryMode = $invoiceDeliveryMode;
    }
    
    /**
     * Returns the invoiceMail
     *
     * @return string
     */
    public function getInvoiceMail()
    {
        return $this->invoiceMail;
    }

    /**
     * Sets the invoiceMail
     */
    public function setInvoiceMail(string $invoiceMail): void
    {
        $this->invoiceMail = $invoiceMail;
    }
    
    /**
     * Returns the invoiceMailSubject
     *
     * @return string
     */
    public function getInvoiceMailSubject()
    {
        return $this->invoiceMailSubject;
    }

    /**
     * Sets the invoiceMailSubject
     */
    public function setInvoiceMailSubject(string $invoiceMailSubject): void
    {
        $this->invoiceMailSubject = $invoiceMailSubject;
    }
    
    /**
     * Returns the invoiceReference
     *
     * @return string
     */
    public function getInvoiceReference()
    {
        return $this->invoiceReference;
    }

    /**
     * Sets the invoiceReference
     */
    public function setInvoiceReference(string $invoiceReference): void
    {
        $this->invoiceReference = $invoiceReference;
    }

    
    /**
     * Returns the invoiceDescription
     */
    public function getInvoiceDescription(): ?string
    {
        return $this->invoiceDescription;
    }

    /**
     * Sets the invoiceDescription
     */
    public function setInvoiceDescription(string $invoiceDescription): void
    {
        $this->invoiceDescription = $invoiceDescription;
    }

    
    /**
     * Returns the invoiceAddress
     *
     * @return Contact
     */
    public function getInvoiceAddress()
    {
        if ($this->invoiceAddress instanceof LazyLoadingProxy) {
            $this->invoiceAddress->_loadRealInstance();
        }
        return $this->invoiceAddress;
    }

    public function getCombinedInvoiceAddress()
    {
        if ($this->invoiceMode == 1) {
            return $this->getOrganisationId();
        }
        return $this->getInvoiceAddress() ?? $this->getContact();
    }
    public function getCombinedInvoiceAddressUsed()
    {
        if ($this->invoiceMode == 1) {
            return $this->verband->getTitleOrganisationId() ?: 'Extra Organisation';
        }
        if ($this->getInvoiceAddress()) {
            return 'Rechnungsadresse';
        }
        $contact = $this->getContact();
        return $contact ? $contact->getType() : '';
    }

    /**
     * Sets the invoiceAddress
     */
    public function setInvoiceAddress(Contact $invoiceAddress = null): void
    {
        $this->invoiceAddress = $invoiceAddress;
    }









    /**
     * Returns the correspondenceMode
     *
     * @return int
     */
    public function getCorrespondenceMode()
    {
        return $this->correspondenceMode;
    }

    /**
     * Sets the correspondenceMode
     *
     * @param int $correspondenceMode
     */

    public function setCorrespondenceMode($correspondenceMode): void
    {
        $this->correspondenceMode = $correspondenceMode;
    }

    /**
     * Returns the correspondenceAddress
     *
     * @return Contact
     */
    public function getCorrespondenceAddress()
    {
        if ($this->correspondenceAddress instanceof LazyLoadingProxy) {
            $this->correspondenceAddress->_loadRealInstance();
        }
        return $this->correspondenceAddress;
    }
    
    public function getCombinedCorrespondenceAddress()
    {
        if ($this->correspondenceMode == 1) {
            return $this->getOrganisationId();
        }
        return $this->getCorrespondenceAddress() ?? $this->getContact();
    }
    public function getCombinedCorrespondenceAddressUsed()
    {
        if ($this->correspondenceMode == 1) {
            return $this->verband->getTitleOrganisationId() ?: 'Extra Organisation';
        }
        if ($this->getCorrespondenceAddress()) {
            return 'Korrespondenzadresse';
        }
        $contact = $this->getContact();
        return $contact ? $contact->getType() : '';
    }

    /**
     * Sets the correspondenceAddress
     */
    public function setCorrespondenceAddress(Contact $correspondenceAddress = null): void
    {
        $this->correspondenceAddress = $correspondenceAddress;
    }

    public function getCorrespondenceDeliveryMode(): int
    {
        return $this->correspondenceDeliveryMode;
    }

    public function setCorrespondenceDeliveryMode(int $correspondenceDeliveryMode): void
    {
        $this->correspondenceDeliveryMode = $correspondenceDeliveryMode;
    }

    
    /**
     * Adds a Tag
     */
    public function addTag(Tag $tag): void
    {
        $this->tags->attach($tag);
    }
    public function addTagIfNotContains(Tag $tag): void
    {
        if (!$this->tags->contains($tag)) {
            $this->tags->attach($tag);
        }
    }

    /**
     * Removes a Tag
     *
     * @param Tag $tagToRemove The Tag to be removed
     */
    public function removeTag(Tag $tagToRemove): void
    {
        $this->tags->detach($tagToRemove);
    }

    /**
     * Returns the tags
     *
     * @return ObjectStorage<Tag> $tags
     */
    public function getTags()
    {
        return $this->tags;
    }
    public function getTagIds()
    {
        $tagIds = [];
        foreach ($this->tags as $tag) {
            $tagIds[] = $tag->getUid();
        }
        return $tagIds;
    }
    public function hasTag(Tag $tag)
    {
        foreach ($this->tags as $t) {
            if ($t->getUid() == $tag->getUid()) {
                return true;
            }
        }
        return false;
    }
    /**
     * Sets the tags
     *
     * @param ObjectStorage<Tag> $tags
     */
    public function setTags(ObjectStorage $tags): void
    {
        $this->tags = $tags;
    }

    /**
     * Adds a Commission
     */
    public function addCommission(Commission $commission): void
    {
        $this->commissions->attach($commission);
    }

    /**
     * Removes a Commission
     *
     * @param Commission $commissionToRemove The Commission to be removed
     */
    public function removeCommission(Commission $commissionToRemove): void
    {
        $this->commissions->detach($commissionToRemove);
    }

    /**
     * Returns the commissions
     *
     * @return ObjectStorage<Commission> $commissions
     */
    public function getCommissions()
    {
        return $this->commissions;
    }

    /**
     * Sets the commissions
     *
     * @param ObjectStorage<Commission> $commissions
     */
    public function setCommissions(ObjectStorage $commissions): void
    {
        $this->commissions = $commissions;
    }

    /**
     * Adds a Sektion
     */
    public function addSektionen(Sektion $sektionen): void
    {
        $this->sektionen->attach($sektionen);
    }

    /**
     * Removes a Sektion
     *
     * @param Sektion $sektionenToRemove The Sektion to be removed
     */
    public function removeSektionen(Sektion $sektionenToRemove): void
    {
        $this->sektionen->detach($sektionenToRemove);
    }

    /**
     * Returns the sektionen
     *
     * @return ObjectStorage<Sektion> $sektionen
     */
    public function getSektionen()
    {
        return $this->sektionen;
    }

    /**
     * Sets the sektionen
     *
     * @param ObjectStorage<Sektion> $sektionen
     */
    public function setSektionen(ObjectStorage $sektionen): void
    {
        $this->sektionen = $sektionen;
    }

    /**
     * Adds a Category
     */
    public function addCategory(Category $category): void
    {
        $this->categories->attach($category);
    }

    /**
     * Removes a Category
     *
     * @param Category $categoryToRemove The Category to be removed
     */
    public function removeCategory(Category $categoryToRemove): void
    {
        $this->categories->detach($categoryToRemove);
    }

    /**
     * Returns the categories
     *
     * @return ObjectStorage<Category> $categories
     */
    public function getCategories()
    {
        // remove hidden categories
        $categories = [];
        foreach ($this->categories as $category) {
            if ($category->getUid() > 0) {
                $categories[] = $category;
            }
        }
        return $categories;
        //return $this->categories;
    }

    /**
     * Sets the categories
     *
     * @param ObjectStorage<Category> $categories
     */
    public function setCategories(ObjectStorage $categories): void
    {
        $this->categories = $categories;
    }

    /**
     * Returns the organisationId
     *
     * @return Organisation
     */
    public function getOrganisationId()
    {
        if ($this->organisationId instanceof LazyLoadingProxy) {
            $this->organisationId->_loadRealInstance();
        }
        return $this->organisationId;
    }

    /**
     * Sets the organisationId
     */
    public function setOrganisationId(Organisation $organisationId = null): void
    {
        $this->organisationId = $organisationId;
    }

    /**
     * Adds a Organisation
     */
    public function addOrganisation(Organisation $organisation): void
    {
        $this->organisations->attach($organisation);
    }
 
    /**
     * Removes a Organisation
     *
     * @param Organisation $organisationToRemove The Organisation to be removed
     */
    public function removeOrganisation(Organisation $organisationToRemove): void
    {
        $this->organisations->detach($organisationToRemove);
    }
 
    /**
     * Returns the organisations
     *
     * @return ObjectStorage<Organisation> $organisations
     */
    public function getOrganisations()
    {
        return $this->organisations;
    }
 
    /**
     * Sets the organisations
     *
     * @param ObjectStorage<Organisation> $organisations
     */
    public function setOrganisations(ObjectStorage $organisations): void
    {
        $this->organisations = $organisations;
    }

    

    public function getTagsVerband()
    {
        $tagverbandRepository = GeneralUtility::makeInstance(TagverbandRepository::class);
        return $tagverbandRepository->findBy([
            'verband' => $this->getVerband(),
        ]);
    }

    public function getTagsUids()
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            'tx_igscrm_contactverband_tag_mm'
        );
        $result = $queryBuilder
                 ->select('uid_foreign')
                 ->from('tx_igscrm_contactverband_tag_mm')
                 ->where(
                     $queryBuilder->expr()->eq('uid_local', $queryBuilder->createNamedParameter(
                         $this->getUid(),
                         Connection::PARAM_INT
                     ))
                 )
                 ->executeQuery();
        $uids = [];
        while ($row = $result->fetchAssociative()) {
            $uids[$row['uid_foreign']] = $row['uid_foreign'];
        }
        return $uids;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->tags = new ObjectStorage();
        $this->commissions = new ObjectStorage();
        $this->sektionen = new ObjectStorage();
        $this->categories = new ObjectStorage();
        $this->organisations = new ObjectStorage();
    }
}
