<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Export extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * className
     *
     * @var string
     */
    protected $className = '';

    /**
     * functionName
     *
     * @var string
     */
    protected $functionName = '';

    /**
     * filename
     *
     * @var string
     */
    protected $filename = '';

    /**
     * fields
     *
     * @var string
     */
    protected $fields = '';

    /**
     * config
     *
     * @var string
     */
    protected $config = '';

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the className
     *
     * @return string
     */
    public function getClassName()
    {
        return $this->className;
    }

    /**
     * Sets the className
     *
     * @param string $className
     */
    public function setClassName($className): void
    {
        $this->className = $className;
    }

    /**
     * Returns the functionName
     *
     * @return string
     */
    public function getFunctionName()
    {
        return $this->functionName;
    }

    /**
     * Sets the functionName
     *
     * @param string $functionName
     */
    public function setFunctionName($functionName): void
    {
        $this->functionName = $functionName;
    }

    /**
     * Returns the filename
     *
     * @return string
     */
    public function getFilename()
    {
        return $this->filename;
    }

    /**
     * Sets the filename
     *
     * @param string $filename
     */
    public function setFilename($filename): void
    {
        $this->filename = $filename;
    }

    /**
     * Returns the fields
     *
     * @return string
     */
    public function getFields()
    {
        return $this->fields;
    }
    public function getFieldsArray()
    {
        return parse_ini_string($this->fields);
    }

    /**
     * Sets the fields
     *
     * @param string $fields
     */
    public function setFields($fields): void
    {
        $this->fields = $fields;
    }

    /**
     * Returns the config
     *
     * @return string
     */
    public function getConfig()
    {
        return $this->config;
    }
    public function getConfigArray()
    {
        $defaultConfig = [
            'jahr' => 0,
            'showEmail' => 1,
            'showAnrede' => 1,
            'showInvoice' => 1,
            'limitLength' => 0, // keine Limitierung
        ];

        return array_merge($defaultConfig, parse_ini_string($this->config));
    }

    /**
     * Sets the config
     *
     * @param string $config
     */
    public function setConfig($config): void
    {
        $this->config = $config;
    }
}
