<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser as IgFrontendUser;
use Internetgalerie\IgsCrm\Domain\Repository\ContactRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class FrontendUser extends IgFrontendUser
{
    
    /**
     * crmSettingsPrinterMarginTop
     *
     * @var int
     */
    protected $crmSettingsPrinterMarginTop;

    /**
     * crmSettingsCustomCss
     *
     * @var string
     */
    protected $crmSettingsCustomCss;

    /**
     * crmVerbandUids
     *
     * @var string
     */
    protected $crmVerbandUids;

    /**
     * crmDefaultGroup
     *
     * @var int
     */
    protected $crmDefaultGroup;


    
    /**
     * Returns the crmSettingsPrinterMarginTop
     *
     * @return int
     */
    public function getCrmSettingsPrinterMarginTop()
    {
        return $this->crmSettingsPrinterMarginTop;
    }

    /**
     * Sets the crmSettingsPrinterMarginTop
     *
     * @param int $crmSettingsPrinterMarginTop
     */
    public function setCrmSettingsPrinterMarginTop($crmSettingsPrinterMarginTop): void
    {
        $this->crmSettingsPrinterMarginTop = $crmSettingsPrinterMarginTop;
    }

    /**
     * Returns the crmSettingsCustomCss
     *
     * @return string
     */
    public function getCrmSettingsCustomCss()
    {
        return $this->crmSettingsCustomCss;
    }

    /**
     * Sets the crmSettingsCustomCss
     *
     * @param string $crmSettingsCustomCss
     */
    public function setCrmSettingsCustomCss($crmSettingsCustomCss): void
    {
        $this->crmSettingsCustomCss = $crmSettingsCustomCss;
    }

    /**
     * Returns the crmVerbandUids
     *
     * @return string
     */
    public function getCrmVerbandUids()
    {
        return $this->crmVerbandUids;
    }

    /**
     * Sets the crmVerbandUids
     *
     * @param string $crmVerbandUids
     */
    public function setCrmVerbandUids($crmVerbandUids): void
    {
        $this->crmVerbandUids = $crmVerbandUids;
    }


    /**
     * Returns the crmDefaultGroup
     *
     * @return string
     */
    public function getCrmDefaultGroup()
    {
        return $this->crmDefaultGroup;
    }

    /**
     * Sets the crmDefaultGroup
     *
     * @param string $crmDefaultGroup
     */
    public function setCrmDefaultGroup($crmDefaultGroup): void
    {
        $this->crmDefaultGroup = $crmDefaultGroup;
    }
    

    /**
     * Returns the contact of this frontendUser
     */
    public function getContact(): ?Contact
    {
        $contacts = $this->getContacts();
        return empty($contacts) ? null : $contacts[0];
    }


    /**
     * Returns the contact of this frontendUser
     *
     * @return array
     */
    public function getContacts()
    {
        $this->contactRepository = GeneralUtility::makeInstance(ContactRepository::class);
        return $this->contactRepository->findByFrontendUser($this->uid);
    }
}
