<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use Internetgalerie\IgCrmTemplate\Domain\Model\TemplateObjectInterface;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use Internetgalerie\IgsCrm\Domain\Repository\OrganisationRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class Invoice extends \Ig\IgFibu\Domain\Model\Invoice implements TemplateObjectInterface
{
    /**
     * mitgliedschaft
     *
     * @var int
     */
    protected $mitgliedschaft = null;

    /**
     * Returns the mitgliedschaft
     *
     * @return int mitgliedschaft
     */
    public function getMitgliedschaft()
    {
        if ($this->mitgliedschaft === null) {
            $items = $this->getInvoiceItems();
            $this->mitgliedschaft = 0;
            if (!empty($items)) {
                foreach ($items as $item) {
                    if ($item instanceof InvoiceItemMembership) {
                        $membership = $item->getMembership();
                        if ($membership) {
                            $this->mitgliedschaft = $membership;
                            break;
                        }
                    }
                }
            }
        }
        return $this->mitgliedschaft;
    }
    public function getTemplateMainTag(): ?int
    {
        return $this->getMitgliedschaft();
    }
    public function getTemplateSubTag(): ?int
    {
        return $this->getStatus()
->getUid();
    }
    
    public function getMitgliedschaftObject()
    {
        if ($this->mitgliedschaft == 0) {
            return null;
        }
        $mitgliedschaftRepository = GeneralUtility::makeInstance(MitgliedschaftRepository::class);
        return $mitgliedschaftRepository->findOneBy([
            'uid' => $this->mitgliedschaft,
        ]);
    }
    
    /**
     * Sets the mitgliedschaft
     *
     * @param  int $mitgliedschaft
     */
    public function setMitgliedschaft($mitgliedschaft): void
    {
        $this->mitgliedschaft = $mitgliedschaft;
    }

    public function getInvoiceItemsByCostCenterCode(string $costcenterCode)
    {
        $items = [];
        foreach ($this->getInvoiceItems() as $invoiceitem) {
            $itemCostcenter = $invoiceitem->getCostCenter();
            if ($itemCostcenter && $itemCostcenter->getCode() == $costcenterCode) {
                $costcenter = $itemCostcenter;
                $items[] = $invoiceitem;
            }
        }
        return $items;
    }
    
    /**
     * Returns the sub1Text
     *
     * @return string
     */
    public function getSub1Text()
    {
        $items = $this->getInvoiceItemsByCostCenterCode('Mitgliedschaft');
        if (empty($items)) {
            return '';
        }
        return $items[0]->getDescription();
    }


    /**
     * Returns the sub1Inkl
     *
     * @return float
     */
    public function getSub1Inkl()
    {
        $items = $this->getInvoiceItemsByCostCenterCode('Mitgliedschaft');
        if (empty($items)) {
            return '';
        }
        return $items[0]->getAmount();
    }

    /**
     * Returns the sub2Text
     *
     * @return string
     */
    public function getSub2Text()
    {
        $items = $this->getInvoiceItemsByCostCenterCode('Abo');
        if (empty($items)) {
            return '';
        }
        return $items[0]->getDescription();
    }


    /**
     * Returns the sub2Inkl
     *
     * @return float
     */
    public function getSub2Inkl()
    {
        $items = $this->getInvoiceItemsByCostCenterCode('Abo');
        if (empty($items)) {
            return '';
        }
        return $items[0]->getAmount();
    }

    public function getRawFilialen()
    {
        if ($this->rawFilialen === null) {
            $this->organisationRepository = GeneralUtility::makeInstance(OrganisationRepository::class);
            $this->rawFilialen = $this->organisationRepository->findRawFilialenActive(
                $this->getDebitor()->getUid(),
                $this->getVerband()->getUid()
            );
        }
        return $this->rawFilialen;
    }
    
    public function getFilialenAsText()
    {
        $filialen = '';
        //$meficcFilialen = $this->getFilialen();
        foreach ($this->getRawFilialen() as $f) {
            if ($filialen) {
                $filialen .= ', ';
            }
            $filialen .= $f['me_companyname'] . ' ' . $f['me_zip'] . ' ' . $f['me_city'];
            //$filialen .= $f->getMeCompanyname() . ' ' . $f->getMeZip() . ' ' . $f->getMeCity();
        }
        return $filialen;
    }
}
