<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use Ig\IgFibu\Domain\Model\InvoiceInterface;
use Ig\IgFibu\Domain\Model\InvoiceItem;
use Internetgalerie\IgsCrm\Domain\Repository\ZeitschriftRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class InvoiceItemJournal extends InvoiceItem
{
    /**
     * journal
     *
     * @var int
     */
    protected $journal;
    
    /**
     * set local text to false (default is true)
     *
     * @var bool
     */
    protected $isLocalText = false;

    /**
     * creates a new invoiceItem
     *
     * @return InvoiceItemJournal
     */
    public static function create(ContactVerband $contactVerband, string $period = null)
    {
        // @todo get journal with dates/active
        $journal = $contactVerband->getJournal();
        // has a journal
        if (!$journal instanceof Zeitschrift) {
            return null;
        }
        // is journal active
        if (!$contactVerband->isJournalActive()) {
            return null;
        }
        
        $invoiceitem = GeneralUtility::makeInstance(self::class);
        $client = $contactVerband->getVerband();
        if ($period !== null) {
            $invoiceitem->setPeriod($period);
        }
        if ($journal instanceof Zeitschrift) {
            $invoiceitem->setJournal($journal->getUid());
            $amount = $contactVerband->getJournalAmount(); // get amount
            $invoiceitem->setTotalByClient($client, $amount);
        }
        $invoiceitem->setDefaultCostCenter($client->getUid());
        $invoiceitem->calculate();

        //$invoiceitem->replaceAndSetDescription($journal->getInvoicestext()); // period must be set
        return $invoiceitem;
    }
    /*
    public function setDefaultCostCenter(int $mandantUid)
    {
        $costCenterRepository = GeneralUtility::makeInstance(CostCenterRepository::class);

        $costCenter = $costCenterRepository->findForVerbandType($mandantUid, self::class);
        if ($costCenter !== null) {
            $this->setCostCenter($costCenter);
        }
    }
    */


    public function setLocalByInvoice(InvoiceInterface $invoice): void
    {
        $client = $invoice->getVerband();
        $contact = $invoice->getDebitor();
        $journal = $this->getJournalObject();

        // set amount, tax for journal
        $amount = $journal->getBetragWithAlter($contact->getMeAlterWithYear());
        $this->setTotalByClient($client, $amount);

        // set cost center for this invoice item
        $this->setDefaultCostCenter($client->getUid());

        // set description text from membership, period...
        $this->calculate();
    }

    
    /**
     * Returns the journal
     *
     * @return int journal
     */
    public function getJournal()
    {
        return $this->journal;
    }
    public function getJournalObject()
    {
        if ($this->journal == 0) {
            return null;
        }
        $zeitschriftRepository = GeneralUtility::makeInstance(ZeitschriftRepository::class);
        return $zeitschriftRepository->findOneBy([
            'uid' => $this->journal,
        ]);
    }
    
    /**
     * Sets the journal
     *
     * @param  int $journal
     */
    public function setJournal($journal): void
    {
        $this->journal = $journal;
    }

    
    public function getObjectDescription()
    {
        $journal = $this->getJournalObject();
        if (is_object($journal)) {
            return str_replace('{period}', $this->getPeriod(), $journal->getInvoicestext());
        }
        return $this->journal;
    }

    public function calculate(): void
    {
        if (!$this->isLocalText) {
            $this->replaceAndSetDescription($this->getObjectDescription());
        }
    }
}
