<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use Ig\IgFibu\Domain\Model\InvoiceInterface;
use Ig\IgFibu\Domain\Model\InvoiceItem;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class InvoiceItemMembership extends InvoiceItem
{
    /**
     * membership
     *
     * @var int
     */
    protected $membership;

    /**
     * set local text to false (default is true)
     *
     * @var bool
     */
    protected $isLocalText = false;

    /**
     * creates a new invoiceItem
     *
     * @return InvoiceItemMembership
     */
    public static function create(ContactVerband $contactVerband, string $period = null)
    {
        // @todo get membership with dates/active
        $membership = $contactVerband->getMitgliedschaft();
        // has membership
        if (!$membership instanceof Mitgliedschaft) {
            return null;
        }
        $invoiceitem = GeneralUtility::makeInstance(self::class);
        $verband = $contactVerband->getVerband();
        $contact = $contactVerband->getContact();

        if ($period !== null) {
            $invoiceitem->setPeriod($period);
        }
        if ($membership instanceof Mitgliedschaft) {
            $invoiceitem->setMembership($membership->getUid());
            $amount = $membership->getAmountForContact($contact, $period);
            $invoiceitem->setTotalByClient($verband, $amount);
        }

        $invoiceitem->setDefaultCostCenter($verband->getUid());
        $invoiceitem->calculate();


        return $invoiceitem;
    }

    
    public function setLocalByInvoice(InvoiceInterface $invoice): void
    {
        $client = $invoice->getVerband();
        $contact = $invoice->getDebitor();

        // set amount, tax for membership
        $membership = $this->getMembershipObject();
        if ($membership instanceof Mitgliedschaft) {
            $amount = $membership->getAmountForContact($contact, $this->period);
            $this->setTotalByClient($client, $amount);
        }

        // set cost center for this invoice item
        $this->setDefaultCostCenter($client->getUid());

        // set description text from membership, period...
        $this->calculate();
    }

    /**
     * Returns the membership
     *
     * @return int membership
     */
    public function getMembership()
    {
        return $this->membership;
    }
    public function getMembershipObject()
    {
        if ($this->membership == 0) {
            return null;
        }
        $mitgliedschaftRepository = GeneralUtility::makeInstance(MitgliedschaftRepository::class);
        return $mitgliedschaftRepository->findOneBy([
            'uid' => $this->membership,
        ]);
    }
    
    /**
     * Sets the membership
     *
     * @param  int $membership
     */
    public function setMembership($membership): void
    {
        $this->membership = $membership;
    }
    
    public function getObjectDescription()
    {
        $membership = $this->getMembershipObject();
        if (is_object($membership)) {
            return $membership->getInvoicestext();
        }
        return $this->description;
    }

    public function calculate(): void
    {
        if (!$this->isLocalText) {
            $this->replaceAndSetDescription($this->getObjectDescription());
        }
    }
}
