<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use Internetgalerie\IgsCrm\Domain\Repository\KursteilnehmerRepository;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Kurse extends AbstractEntity
{
    /**
     * kuName
     *
     * @var string
     */
    protected $kuName = '';

    /**
     * kuNameFr
     *
     * @var string
     */
    protected $kuNameFr = '';

    /**
     * kuFussnote
     *
     * @var boolean
     */
    protected $kuFussnote = false;

    /**
     * kuKursmodule
     *
     * @var ObjectStorage<Kursmodule>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    protected $kuKursmodule = null;

    /**
     * kuArt
     *
     * @var Kursart
     */
    protected $kuArt = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Returns the kuName
     *
     * @return string
     */
    public function getKuName()
    {
        return $this->kuName;
    }

    /**
     * Sets the kuName
     *
     * @param string $kuName
     */
    public function setKuName($kuName): void
    {
        $this->kuName = $kuName;
    }

    /**
     * Returns the kuNameFr
     *
     * @return string
     */
    public function getKuNameFr()
    {
        return $this->kuNameFr;
    }

    /**
     * Sets the kuNameFr
     *
     * @param string $kuNameFr
     */
    public function setKuNameFr($kuNameFr): void
    {
        $this->kuNameFr = $kuNameFr;
    }

    /**
     * Returns the kuFussnote
     *
     * @return boolean
     */
    public function getKuFussnote()
    {
        return $this->kuFussnote;
    }

    /**
     * Sets the kuFussnote
     *
     * @param boolean $kuFussnote
     */
    public function setKuFussnote($kuFussnote): void
    {
        $this->kuFussnote = $kuFussnote;
    }

    /**
     * Returns the boolean state of kuFussnote
     *
     * @return boolean
     */
    public function isKuFussnote()
    {
        return $this->kuFussnote;
    }

    /**
     * Adds a Kursmodule
     */
    public function addKuKursmodule(Kursmodule $kuKursmodule): void
    {
        $this->kuKursmodule->attach($kuKursmodule);
    }

    /**
     * Removes a Kursmodule
     *
     * @param Kursmodule $kuKursmoduleToRemove The Kursmodule to be removed
     */
    public function removeKuKursmodule(Kursmodule $kuKursmoduleToRemove): void
    {
        $this->kuKursmodule->detach($kuKursmoduleToRemove);
    }

    /**
     * Returns the kuKursmodule
     *
     * @return ObjectStorage<Kursmodule> $kuKursmodule
     */
    public function getKuKursmodule()
    {
        return $this->kuKursmodule;
    }

    /**
     * Sets the kuKursmodule
     *
     * @param ObjectStorage<Kursmodule> $kuKursmodule
     */
    public function setKuKursmodule(ObjectStorage $kuKursmodule): void
    {
        $this->kuKursmodule = $kuKursmodule;
    }

    /**
     * Returns the kuArt
     *
     * @return Kursart
     */
    public function getKuArt()
    {
        return $this->kuArt;
    }

    /**
     * Sets the kuArt
     */
    public function setKuArt(Kursart $kuArt): void
    {
        $this->kuArt = $kuArt;
    }

    /**
     * Returns the Anzahl Teilnehmer
     *
     * @return integer Anzahl Teilnehmer
     */
    public function getAnzahlTeilnehmer()
    {
        $repository = GeneralUtility::makeInstance(KursteilnehmerRepository::class);
        return $repository->countByKtKurse($this->getUid());
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->kuKursmodule = new ObjectStorage();
    }
}
