<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use DateTime;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Kursteilnehmer extends AbstractEntity
{
    /**
     * ktStartdatum
     *
     * @var DateTime
     */
    protected $ktStartdatum = null;

    /**
     * ktEnddatum
     *
     * @var DateTime
     */
    protected $ktEnddatum = null;

    /**
     * ktDauer
     *
     * @var string
     */
    protected $ktDauer = '';

    /**
     * ktPerson
     *
     * @var Person
     */
    protected $ktPerson = null;

    /**
     * ktKurse
     *
     * @var Kurse
     */
    protected $ktKurse = null;

    /**
     * ktKursmodule
     *
     * @var ObjectStorage<Kursmodule>
     */
    protected $ktKursmodule = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    /**
     * Returns the ktStartdatum
     *
     * @return DateTime
     */
    public function getKtStartdatum()
    {
        return $this->ktStartdatum;
    }

    /**
     * Sets the ktStartdatum
     *
     * @param DateTime $ktStartdatum
     */
    public function setKtStartdatum($ktStartdatum): void
    {
        $this->ktStartdatum = $ktStartdatum;
    }

    /**
     * Returns the ktEnddatum
     *
     * @return DateTime
     */
    public function getKtEnddatum()
    {
        return $this->ktEnddatum;
    }

    /**
     * Sets the ktEnddatum
     *
     * @param DateTime $ktEnddatum
     */
    public function setKtEnddatum($ktEnddatum): void
    {
        $this->ktEnddatum = $ktEnddatum;
    }

    /**
     * Returns the ktDauer
     *
     * @return string
     */
    public function getKtDauer()
    {
        return $this->ktDauer;
    }

    /**
     * Sets the ktDauer
     *
     * @param string $ktDauer
     */
    public function setKtDauer($ktDauer): void
    {
        $this->ktDauer = $ktDauer;
    }

    /**
     * Returns the ktPerson
     *
     * @return Person
     */
    public function getKtPerson()
    {
        return $this->ktPerson;
    }

    /**
     * Sets the ktPerson
     */
    public function setKtPerson(Person $ktPerson): void
    {
        $this->ktPerson = $ktPerson;
    }

    /**
     * Returns the ktKurse
     *
     * @return Kurse
     */
    public function getKtKurse()
    {
        return $this->ktKurse;
    }

    /**
     * Sets the ktKurse
     */
    public function setKtKurse(Kurse $ktKurse): void
    {
        $this->ktKurse = $ktKurse;
    }

    /**
     * Adds a Kursmodule
     */
    public function addKtKursmodule(Kursmodule $ktKursmodule): void
    {
        $this->ktKursmodule->attach($ktKursmodule);
    }

    /**
     * Removes a Kursmodule
     *
     * @param Kursmodule $ktKursmoduleToRemove The Kursmodule to be removed
     */
    public function removeKtKursmodule(Kursmodule $ktKursmoduleToRemove): void
    {
        $this->ktKursmodule->detach($ktKursmoduleToRemove);
    }

    /**
     * Returns the ktKursmodule
     *
     * @return ObjectStorage<Kursmodule> $ktKursmodule
     */
    public function getKtKursmodule()
    {
        return $this->ktKursmodule;
    }

    /**
     * Sets the ktKursmodule
     *
     * @param ObjectStorage<Kursmodule> $ktKursmodule
     */
    public function setKtKursmodule(ObjectStorage $ktKursmodule): void
    {
        $this->ktKursmodule = $ktKursmodule;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->ktKursmodule = new ObjectStorage();
    }
}
