<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use Internetgalerie\IgCrmTemplate\Domain\Model\LanguageInterface;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Language extends AbstractEntity implements LanguageInterface
{
    /**
     * lgName
     *
     * @var string
     */
    protected $lgName = '';

    /**
     * lgShort
     *
     * @var string
     */
    protected $lgShort = '';

    /**
     * lgCode
     *
     * @var string
     */
    protected $lgCode = '';

    /**
     * lgLocale
     *
     * @var string
     */
    protected $lgLocale = '';

    public function __toString(): string
    {
        return $this->getLgName();
    }
    
    /**
     * Returns the lgName
     *
     * @return string
     */
    public function getLgName()
    {
        return $this->lgName;
    }
    public function getName()
    {
        return $this->lgName;
    }

    /**
     * Sets the lgName
     *
     * @param string $lgName
     */
    public function setLgName($lgName): void
    {
        $this->lgName = $lgName;
    }

    /**
     * Returns the lgShort
     *
     * @return string
     */
    public function getLgShort()
    {
        return $this->lgShort;
    }
    public function getShort()
    {
        return $this->lgShort;
    }

    /**
     * Sets the lgShort
     *
     * @param string $lgShort
     */
    public function setLgShort($lgShort): void
    {
        $this->lgShort = $lgShort;
    }


    /**
     * Returns the lgCode
     *
     * @return string
     */
    public function getLgCode()
    {
        return $this->lgCode;
    }
    public function getLanguageKey()
    {
        return $this->lgCode;
    }
    public function getCode()
    {
        return $this->lgCode;
    }
    public function getCodeForProperty()
    {
        return ucfirst($this->lgCode);
    }

    /**
     * Sets the lgCode
     *
     * @param string $lgCode
     */
    public function setLgCode($lgCode): void
    {
        $this->lgCode = $lgCode;
    }
    
    /**
     * Returns the lgLocale
     *
     * @return string
     */
    public function getLgLocale()
    {
        return $this->lgLocale;
    }
    public function getLocale()
    {
        return $this->lgLocale;
    }

    /**
     * Sets the lgLocale
     *
     * @param string $lgLocale
     */
    public function setLgLocale($lgLocale): void
    {
        $this->lgLocale = $lgLocale;
    }
}
