<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use DateTime;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Message extends AbstractEntity
{
    /**
     * tstamp
     *
     * @var DateTime
     */
    protected $tstamp = null;

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * content
     *
     * @var string
     */
    protected $content = '';

    /**
     * createDate
     *
     * @var DateTime
     */
    protected $createDate = null;

    /**
     * message is attatched to this contact
     *
     * @var int
     */
    protected $contact = null;

    /**
     * Returns the last change timestamp
     *
     * @return DateTime
     */
    public function getTstamp()
    {
        return $this->tstamp;
    }
    
    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     */
    public function setTitle($title): void
    {
        $this->title = $title;
    }

    /**
     * Returns the content
     *
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * Sets the content
     *
     * @param string $content
     */
    public function setContent($content): void
    {
        $this->content = $content;
    }

    /**
     * Returns the createDate
     *
     * @return DateTime
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }

    /**
     * Sets the createDate
     */
    public function setCreateDate(DateTime $createDate = null): void
    {
        $this->createDate = $createDate;
    }
    /**
     * Returns the contact
     *
     * @return string
     */
    public function getContact()
    {
        return $this->contact;
    }

    /**
     * Sets the contact
     *
     * @param string $contact
     */
    public function setContact($contact): void
    {
        $this->contact = $contact;
    }
}
