<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Mitgliedschaft extends AbstractEntity
{
    /**
     * verband
     *
     * @var Verband
     */
    public $verband = null;


    /**
     * card
     *
     * @var Card
     */
    public $card = null;

    /**
     * preise
     *
     * @var ObjectStorage<Preise>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    public $preise = null;

    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * code
     *
     * @var string
     */
    protected $code = '';

    /**
     * limit_to_type
     *
     * @var string
     */
    protected $limitToType = '';

    /**
     * mgBetrag
     *
     * @var string
     */
    protected $betrag = '';

    /**
     * betragIsTotal
     *
     * @var boolean
     */
    protected $betragIsTotal = false;


    /**
     * invoicestext
     *
     * @var string
     */
    protected $invoicestext = '';

    /**
     * noPerson
     *
     * @var boolean
     */
    protected $noPerson = false;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }
    public function __toString(): string
    {
        return $this->getName();
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Sets the code
     *
     * @param string $code
     */
    public function setCode($code): void
    {
        $this->code = $code;
    }

    /**
     * Returns the limitToType
     *
     * @return string
     */
    public function getLimitToType()
    {
        return $this->limitToType;
    }

    /**
     * Sets the limitToType
     *
     * @param string $limitToType
     */
    public function setLimitToType($limitToType): void
    {
        $this->limitToType = $limitToType;
    }

    /**
     * Returns the betrag
     *
     * @return string
     */
    public function getBetrag()
    {
        return $this->betrag;
    }
    /**
     * get amount for contact for given year (amount is depending of age of contact in given year)
     *
     * @param Contact $contact Contact for age and gender
     * @param int $year year to calculate age
     * @return amount
     */
    public function getAmountForContact(
        Contact $contact,
        int $year = null
    ) {
        $addYear = $year === null ? 0 : $year - date('Y');
        $alterWithYear = $contact->getMeAlterWithYear() + $addYear;
        return $this->getBetragWithAlter($alterWithYear, $contact->getAnredeId());
    }

    public function getBetragWithAlter($alterInJahre, $anrede)
    {
        if (intval($alterInJahre) <= 0) {
            return $this->betrag;
        }
        $ret = $this->betrag;
        if (!empty($this->getPreise())) {
            foreach ($this->getPreise() as $preis) {
                //echo('test: ' . $preis->getAlterInJahrVon() .'==='. $alterInJahre .' , '.  $preis->getAnrede() . '==='.$anrede .'<br />');
                if ($preis->getAlterInJahrVon() <= $alterInJahre && $preis->getAlterInJahrBis() >= $alterInJahre) {
                    if ($preis->getAnrede() == $anrede) {
                        return $preis->getBetrag();
                    } elseif ($preis->getAnrede() == 0) {
                        $ret = $preis->getBetrag();
                    }
                }
            }
        }
        return $ret;
    }

    /**
     * Sets the betrag
     *
     * @param string $betrag
     */
    public function setBetrag($betrag): void
    {
        $this->betrag = $betrag;
    }

    /**
     * Returns the betragIsTotal
     *
     * @return boolean
     */
    public function getBetragIsTotal()
    {
        return $this->betragIsTotal;
    }

    /**
     * Sets the betragIsTotal
     *
     * @param boolean $betragIsTotal
     */
    public function setBetragIsTotal($betragIsTotal): void
    {
        $this->betragIsTotal = $betragIsTotal;
    }



    /**
     * Returns the noPerson
     *
     * @return boolean
     */
    public function getNoPerson()
    {
        return $this->noPerson;
    }

    /**
     * Sets the noPerson
     *
     * @param boolean $noPerson
     */
    public function setNoPerson($noPerson): void
    {
        $this->noPerson = $noPerson;
    }



    /**
     * Returns the invoicestext
     *
     * @return string
     */
    public function getInvoicestext()
    {
        return $this->invoicestext;
    }
    public function getInvoicestextWithAlter($alterInJahre)
    {
        if (intval($alterInJahre) <= 0) {
            return $this->invoicestext;
        }
        if (!empty($this->getPreise())) {
            foreach ($this->getPreise() as $preis) {
                if ($preis->getAlterInJahrVon() <= $alterInJahre && $preis->getAlterInJahrBis() >= $alterInJahre) {
                    return $preis->getInvoicestext() ?? $this->invoicestext;
                }
            }
        }
        return $this->invoicestext;
    }

    /**
     * Sets the invoicestext
     *
     * @param string $invoicestext
     */
    public function setInvoicestext($invoicestext): void
    {
        $this->invoicestext = $invoicestext;
    }


    /**
     * Returns the verband
     *
     * @return Verband
     */
    public function getVerband()
    {
        return $this->verband;
    }

    /**
     * Sets the verband
     */
    public function setVerband(Verband $verband): void
    {
        $this->verband = $verband;
    }
    /**
     * Adds a Preise
     */
    public function addPreise(Preise $preise): void
    {
        $this->preise->attach($preise);
    }

    /**
     * Removes a Preise
     *
     * @param Preise $preiseToRemove The Preise to be removed
     */
    public function removePreise(Preise $preiseToRemove): void
    {
        $this->preise->detach($preiseToRemove);
    }

    /**
     * Returns the preise
     *
     * @return ObjectStorage<Preise> $preise
     */
    public function getPreise()
    {
        return $this->preise;
    }

    /**
     * Sets the preise
     *
     * @param ObjectStorage<Preise> $preise
     */
    public function setPreise(ObjectStorage $preise): void
    {
        $this->preise = $preise;
    }

    /**
     * Get the value of card
     *
     * @return Card
     */
    public function getCard()
    {
        return $this->card;
    }

    /**
     * Set the value of card
     *
     * @return self
     */
    public function setCard(Card $card = null)
    {
        $this->card = $card;

        return $this;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->preise = new ObjectStorage();
    }
}
