<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use Internetgalerie\IgsCrm\Domain\Repository\ContactVerbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\OrganisationRepository;
use Internetgalerie\IgsCrm\Domain\Repository\PersonRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\LazyLoadingProxy;
use TYPO3\CMS\Extbase\Persistence\QueryResultInterface;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class Organisation extends Contact
{
    /**
     * Hauptverantwortliche Person
     *
     * @var Person
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $meRespPersonid = null;


    /**
     * ofParentid
     *
     * @var \Internetgalerie\IgsCrm\Domain\Model\Organisation
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $parent = null;

    /**
     * organisationRepository
     *
     * @var OrganisationRepository
     */
    public $organisationRepository = null;

    /**
     * meCompanyname
     *
     * @var string
     */
    protected $meCompanyname = '';

    /**
     * bfsUid
     *
     * @var string
     */
    protected $bfsUid = '';

    /**
     * ofMap
     *
     * @var string
     */
    protected $meMap = '';

    /**
     * ofNoEmployees
     *
     * @var boolean
     */
    protected $meNoEmployees = false;


    /**
     * isLehrbetrieb
     *
     * @var boolean
     */
    protected $isLehrbetrieb = false;

    /**
     * ofBbf
     *
     * @var boolean
     */
    protected $meBbf = false;

    /**
     * @var array
     */
    protected $contactVerband = null;
    /**
     * @var array
     */
    protected $contactVerbandByOrganisationId = null;
    protected ?array $rawFilialen = null;
    protected ?QueryResultInterface $filialen = null;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        parent::__construct();
        //$this->initStorageObjects();
        $this->filialen = null;
        $this->rawFilialen = null;
    }

    public function __toString(): string
    {
        return $this->getMeCompanyname() . ' (' . $this->getMeCity() . ')';
    }
    
    /**
     * @todo if v11 is dropped
     */
    public function injectOrganisationRepository(OrganisationRepository $organisationRepository): void
    {
        $this->organisationRepository = $organisationRepository;
    }
    public function getOrganisationRepository()
    {
        if ($this->organisationRepository === null) {
            $this->organisationRepository = GeneralUtility::makeInstance(OrganisationRepository::class);
        }
        return $this->organisationRepository;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    /*
    protected function initStorageObjects()
    {
        $this->organisationCategory = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        parent::initStorageObjects();
    }
    public function getClass()
    {
        return self::class;
    }
    */
    /**
     * Returns the ofCompanyname
     *
     * @return string
     */
    public function getMeCompanyname()
    {
        return $this->meCompanyname;
    }
    public function getCompanyname()
    {
        return $this->meCompanyname;
    }

    public function getShortnameCompanyname()
    {
        return $this->meShortname ?: $this->meCompanyname;
    }

    /**
     * Sets the ofCompanyname
     *
     * @param string $meCompanyname
     */
    public function setMeCompanyname($meCompanyname): void
    {
        $this->meCompanyname = $meCompanyname;
    }

    public function getQrDebitorAdresse()
    {
        return [
            'name' => $this->getCompanyname(),
            'address' => $this->getAddress(),
            'zip' => $this->getZip(),
            'city' => $this->getCity(),
            'country' => $this->getCountryPostalCode(),
        ];
    }

    /**
     * Returns the bfsUid
     *
     * @return string
     */
    public function getBfsUid()
    {
        return $this->bfsUid;
    }

    /**
     * Sets the bfsUid
     *
     * @param string $bfsUid
     */
    public function setBfsUid($bfsUid): void
    {
        $this->bfsUid = $bfsUid;
    }

    public function getMeStreet()
    {
        return $this->meAddress;
    }

    /**
     * Returns the ofCity
     *
     * @return string
     */
    public function getMeMap()
    {
        return $this->meMap;
    }
    public function getLatitude()
    {
        $latLon = explode(',', $this->meMap);
        return count($latLon) == 2 ? $latLon[0] : null;
    }
    public function getLongitude()
    {
        $latLon = explode(',', $this->meMap);
        return count($latLon) == 2 ? $latLon[1] : null;
    }

    /**
     * Sets the ofMap
     *
     * @param string $meMap
     */
    public function setMeMap($meMap): void
    {
        $this->meMap = $meMap;
    }
    /**
     * Returns the ofAddressid
     *
     * @return integer
     */
    /*
    public function getMeAddressidFibu()
    {
        //return $this->meAddressid % 100000;
        return 800000 + $this->meAddressid % 100000;
    }
    */
    /**
     * Returns the ofNoEmployees
     *
     * @return boolean
     */
    public function getMeNoEmployees()
    {
        return $this->meNoEmployees;
    }

    /**
     * Sets the ofNoEmployees
     *
     * @param boolean $meNoEmployees
     */
    public function setMeNoEmployees($meNoEmployees): void
    {
        $this->meNoEmployees = $meNoEmployees;
    }

    /**
     * Returns the boolean state of ofNoEmployees
     *
     * @return boolean
     */
    public function isOfNoEmployees()
    {
        return $this->meNoEmployees;
    }


    /**
     * Returns the isLehrbetrieb
     *
     * @return boolean
     */
    public function getIsLehrbetrieb()
    {
        return $this->isLehrbetrieb;
    }
    /**
     * Returns the isLehrbetrieb
     *
     * @return boolean
     */
    public function getIsLehrbetriebWithNiederlassungen()
    {
        if ($this->isLehrbetrieb) {
            return $this->isLehrbetrieb;
        }
        $meficcFilialen = $this->getOrganisationRepository()
->findFilialen($this->getUid());
        foreach ($meficcFilialen as $f) {
            if ($f->isLehrbetrieb) {
                return $f->isLehrbetrieb;
            }
        }

        if ($this->getParent()) {
            if ($this->parent->getIsLehrbetrieb()) {
                return $this->parent->getIsLehrbetrieb();
            }
            $meficcFilialen = $this->getOrganisationRepository()
->findFilialen($this->parent->getUid());
            foreach ($meficcFilialen as $f) {
                if ($f->isLehrbetrieb) {
                    return $f->isLehrbetrieb;
                }
            }
        }

        return false;
    }

    /**
     * Sets the isLehrbetrieb
     *
     * @param boolean $isLehrbetrieb
     */
    public function setIsLehrbetrieb($isLehrbetrieb): void
    {
        $this->isLehrbetrieb = $isLehrbetrieb;
    }

    /**
     * Returns the boolean state of isLehrbetrieb
     *
     * @return boolean
     */
    public function isIsLehrbetrieb()
    {
        return $this->isLehrbetrieb;
    }

    /**
     * Returns the ofBbf
     *
     * @return boolean
     */
    public function getMeBbf()
    {
        return $this->meBbf;
    }
    public function getBbf()
    {
        return $this->meBbf;
    }

    /**
     * Sets the ofBbf
     *
     * @param boolean $meBbf
     */
    public function setMeBbf($meBbf): void
    {
        $this->meBbf = $meBbf;
    }

    /**
     * Returns the boolean state of ofBbf
     *
     * @return boolean
     */
    public function isOfBbf()
    {
        return $this->meBbf;
    }

    /**
     * Returns the ofRespPersonid
     *
     * @return Person
     */
    public function getMeRespPersonid()
    {
        if ($this->meRespPersonid instanceof LazyLoadingProxy) {
            $this->meRespPersonid->_loadRealInstance();
        }
        return $this->meRespPersonid;
    }
    public function getContactPerson()
    {
        return $this->getMeRespPersonid();
    }

    
    public function getLanguageCode()
    {
        $language = $this->getLanguage();
        if ($language instanceof Language) {
            return $language->getCode();
        }
        return 'de';
        /*
        if ($this->getMeRespPersonid() instanceof \Internetgalerie\IgsCrm\Domain\Model\Person) {
            $meLanguageid= $this->meRespPersonid->getMeLanguageid();
            if ($meLanguageid instanceof \Internetgalerie\IgsCrm\Domain\Model\Language) {
                return $meLanguageid->getCode();
            }
        }
        return 'de';
         */
    }
    /**
     * Sets the ofRespPersonid
     */
    public function setMeRespPersonid(Person $meRespPersonid = null): void
    {
        $this->meRespPersonid = $meRespPersonid;
    }

    /**
     * Returns the ofParentid
     *
     * @return \Internetgalerie\IgsCrm\Domain\Model\Organisation
     */
    public function getParent()
    {
        if ($this->parent instanceof LazyLoadingProxy) {
            $this->parent->_loadRealInstance();
        }
        return $this->parent;
    }

    /**
     * Sets the ofParentid
     *
     * @param \Internetgalerie\IgsCrm\Domain\Model\Organisation $parent
     */
    public function setParent($parent): void
    {
        $this->parent = $parent;
    }

    /**
     * Returns the filialen as String
     *
     * @return string Filialen Liste als String
     */
    public function getFilialenAsText()
    {
        $filialen = '';
        foreach ($this->getRawFilialen() as $f) {
            if ($filialen) {
                $filialen .= ', ';
            }
            $filialen .= $f['me_companyname'] . ' ' . $f['me_zip'] . ' ' . $f['me_city'];
            //$filialen .= $f->getMeCompanyname() . ' ' . $f->getMeZip() . ' ' . $f->getMeCity();
        }
        return $filialen;
    }
    public function getFilialen()
    {
        if ($this->filialen === null) {
            $this->filialen = $this->getOrganisationRepository()
->findFilialen($this->getUid());
        }
        return $this->filialen;
    }
    public function getRawFilialen()
    {
        if ($this->rawFilialen === null) {
            $this->rawFilialen = $this->getOrganisationRepository()
->findRawFilialen($this->getUid());
        }
        return $this->rawFilialen;
    }


    /**
     * Returns all memeber including members of  filialen as String
     *
     * @return string Filialen Liste als String
     */
    public function getResponsilbleMembersAsText()
    {
        // Uids aller Filialen und Hauptsitze holen
        $organisation_uids = [];
        $ofRespPersonids = [];

        $hauptsitz = $this->getParent() ?: $this;
        $filialen = $this->getRawFilialen();
        
        $organisation_uids[] = $hauptsitz->getUid();
        //$ofRespPersonids[] = $hauptsitz->getMeRespPersonid();
        foreach ($filialen as $f) {
            $organisation_uids[] = $f['uid'];
        }

        $personRepository = GeneralUtility::makeInstance(PersonRepository::class);
        $persons = $personRepository->findIgsOrganisation(
            $organisation_uids,
            $ofRespPersonids
        ); // alle zugeordneten Mitglieder und Verantwortliche (Hauptsitz + Filialen)
        // Namensliste der Personen fuer Ausgabe bilden
        $ret = '';
        $personAnzahl = count($persons);
        if ($personAnzahl > 0) {
            if ($personAnzahl == 1) {
                $ret = LocalizationUtility::translate('geosuisse.letter.einzelmitgliedschaft', 'igs_crm') . ' ';
            } else {
                $ret = LocalizationUtility::translate('geosuisse.letter.einzelmitgliedschaften', 'igs_crm') . ' ';
            }
            $c = 0;
            foreach ($persons as $m) {
                $c++;
                if ($c > 1) {
                    if ($personAnzahl == $c) {
                        $ret .= ' ' . LocalizationUtility::translate('geosuisse.letter.und', 'igs_crm') . ' ';
                    } else {
                        $ret .= ', ';
                    }
                }
                $ret .= $m->getMeFirstname() . ' ' . $m->getMeLastname();
            }
        }
        return $ret;
    }
    
    /**
     * Returns Sort String
     */
    public function getMeSort(): string
    {
        return mb_substr($this->meCompanyname, 0, 7) . mb_substr($this->getMeCity(), 0, 4);
    }

    public function getContactVerband()
    {
        if ($this->contactVerband === null && $this->getUid() > 0) {
            $contactVerbandRepository = GeneralUtility::makeInstance(ContactVerbandRepository::class);
            $contactVerbands = $contactVerbandRepository->findBy([
                'invoiceAddress' => $this,
            ]);
            $this->contactVerband = $contactVerbands->toArray();
        }

        return $this->contactVerband;
    }
    public function getContactVerbandByOrganisationId()
    {
        if ($this->contactVerbandByOrganisationId === null && $this->getUid() > 0) {
            $contactVerbandRepository = GeneralUtility::makeInstance(ContactVerbandRepository::class);
            $contactVerbands = $contactVerbandRepository->findBy([
                'organisationId' => $this,
            ]);
            $this->contactVerbandByOrganisationId = $contactVerbands->toArray();
        }

        return $this->contactVerbandByOrganisationId;
    }
    public function getContactVerbandByOrganisations()
    {
        if ($this->contactVerbandByOrganisations === null && $this->getUid() > 0) {
            $contactVerbandRepository = GeneralUtility::makeInstance(ContactVerbandRepository::class);
            $contactVerbands = $contactVerbandRepository->findForOrganisation($this->getUid());
            $this->contactVerbandByOrganisations = $contactVerbands->toArray();
        }

        return $this->contactVerbandByOrganisations;
    }

    /**
     * Get the value of name
     *
     * @return string
     */
    public function getName()
    {
        return $this->meCompanyname;
    }
    public function getOrganisationName()
    {
        return $this->meCompanyname;
    }
    /**
     * Set the value of name
     *
     * @param string $name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }
    public function getNumber()
    {
        return $this->uid;
        //return 800000 + $this->meAddressid % 100000;
    }
    public function getIsOrganisation()
    {
        return true;
    }
}
