<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use Internetgalerie\IgsCrm\Domain\Repository\TagFieldRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Tag extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * hasRoles
     *
     * @var bool
     */
    protected $hasRoles = '';
    

    /**
     * usergroup
     *
     * @var string
     */
    protected $usergroup = '';

    /**
     * verband
     *
     * @var Verband
     */
    protected $verband = null;
    
    /**
     * tagverband
     *
     * @var Tagverband
     */
    protected $tagverband = null;
    
    public function __toString(): string
    {
        return $this->getName();
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the hasRoles
     *
     * @return bool
     */
    public function getHasRoles()
    {
        return $this->hasRoles;
    }

    /**
     * Sets the hasRoles
     *
     * @param bool $hasRoles
     */
    public function setHasRoles($hasRoles): void
    {
        $this->hasRoles = $hasRoles;
    }
    public function getTextfields()
    {
        if ($this->tagFields === null) {
            $tagFieldRepository = GeneralUtility::makeInstance(TagFieldRepository::class);
            $this->tagFields = $tagFieldRepository->findBy([
                'tag' => $this,
            ]);
        }
        return $this->tagFields;
    }

    /**
     * Returns the usergroup
     *
     * @return string
     */
    public function getUsergroup()
    {
        return $this->usergroup;
    }

    /**
     * Sets the usergroup
     *
     * @param string $usergroup
     */
    public function setUsergroup($usergroup): void
    {
        $this->usergroup = $usergroup;
    }

    /**
     * Returns the verband
     *
     * @return Verband
     */
    public function getVerband()
    {
        return $this->verband;
    }

    /**
     * Sets the verband
     */
    public function setVerband(Verband $verband): void
    {
        $this->verband = $verband;
    }

    /**
     * Returns the tagverband
     *
     * @return Tagverband
     */
    public function getTagverband()
    {
        return $this->tagverband;
    }

    /**
     * Sets the tagverband
     */
    public function setTagverband(Tagverband $tagverband): void
    {
        $this->tagverband = $tagverband;
    }
}
