<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class TagField extends AbstractEntity
{
    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * sorting
     *
     * @var integer
     */
    protected $sorting = 0;

    /**
     * fieldNumber
     *
     * @var integer
     */
    protected $fieldNumber = 0;

    /**
     * isTranslated
     *
     * @var boolean
     */
    protected $isTranslated = false;

    /**
     * tag
     *
     * @var Tag
     */
    protected $tag = null;

    public function __toString(): string
    {
        $str = $this->getTitle();
        return $str;
    }


    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     */
    public function setTitle($title): void
    {
        $this->title = $title;
    }


    /**
     * Returns the fieldNumber
     *
     * @return integer
     */
    public function getFieldNumber()
    {
        return $this->fieldNumber;
    }
 
    /**
     * Sets the fieldNumber
     *
     * @param integer $fieldNumber
     */
    public function setFieldNumber($fieldNumber): void
    {
        $this->fieldNumber = $fieldNumber;
    }
    
    /**
     * Returns the sorting
     *
     * @return integer
     */
    public function getSorting()
    {
        return $this->sorting;
    }
 
    /**
     * Sets the sorting
     *
     * @param integer $sorting
     */
    public function setSorting($sorting): void
    {
        $this->sorting = $sorting;
    }


    /**
     * Get the value of isTranslated
     *
     * @return boolean
     */
    public function getIsTranslated()
    {
        return $this->isTranslated;
    }

    /**
     * Set the value of isTranslated
     *
     * @param boolean $isTranslated
     *
     * @return self
     */
    public function setIsTranslated($isTranslated): void
    {
        $this->isTranslated = $isTranslated;
    }

    
    /**
     * Returns the tag
     *
     * @return Tag
     */
    public function getTag()
    {
        return $this->tag;
    }

    /**
     * Sets the tag
     */
    public function setTag(Tag $tag): void
    {
        $this->tag = $tag;
    }
}
