<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use Internetgalerie\IgsCrm\Domain\Repository\TagRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Tagverband extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * verband
     *
     * @var Verband
     */
    protected $verband = null;

    /**
     * tagRepository
     *
     * @var TagRepository
     */
    protected $tagRepository = null;

    public function __toString(): string
    {
        $str = $this->getName();
        return $str;
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the verband
     *
     * @return Verband
     */
    public function getVerband()
    {
        return $this->verband;
    }

    /**
     * Sets the verband
     */
    public function setVerband(Verband $verband): void
    {
        $this->verband = $verband;
    }

    public function getTags()
    {
        if ($this->tagRepository === null) {
            $this->tagRepository = GeneralUtility::makeInstance(TagRepository::class);
        }
        return $this->tagRepository->findBy([
            'tagverband' => $this->getUid(),
        ]);
    }


    public function getTagsWithNone()
    {
        if ($this->tagRepository === null) {
            $this->tagRepository = GeneralUtility::makeInstance(TagRepository::class);
        }
        $tags = [];
        foreach ($this->tagRepository->findBy([
            'tagverband' => $this->getUid(),
        ]) as $tag) {
            $tags[$tag->getUid()] = $tag->getName();
        }
        $tags[-$this->getUid()] = '-- Ohne Kategorie ---';
        return $tags;
    }
}
