<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\Generic\LazyLoadingProxy;

class Translate extends AbstractEntity
{
    /**
     * verband
     *
     * @var Verband
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $verband = null;
    
    /**
     * Kommunikationssprache
     *
     * @var Language
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $crmLanguage = null;

    /**
     * textKey
     *
     * @var string
     */
    protected $textKey = '';

    /**
     * textValue
     *
     * @var string
     */
    protected $textValue = '';

    
    /**
     * Returns the verband
     *
     * @return Verband
     */
    public function getVerband()
    {
        if ($this->verband instanceof LazyLoadingProxy) {
            $this->verband = $this->verband->_loadRealInstance();
        }
        return $this->verband;
    }

    /**
     * Sets the verband
     */
    public function setVerband(Verband $verband): void
    {
        $this->verband = $verband;
    }

    /**
     * Returns the crmLanguage
     *
     * @return Language
     */
    public function getCrmLanguage()
    {
        if ($this->crmLanguage instanceof LazyLoadingProxy) {
            $this->crmLanguage = $this->crmLanguage->_loadRealInstance();
        }
        return $this->crmLanguage;
    }

    /**
     * Sets the crmLanguage
     */
    public function setCrmLanguage(Language $crmLanguage = null): void
    {
        $this->crmLanguage = $crmLanguage;
    }
    
    /**
     * Returns the textKey
     *
     * @return string
     */
    public function getTextKey()
    {
        return $this->textKey;
    }

    /**
     * Sets the textKey
     *
     * @param string $textKey
     */
    public function setTextKey($textKey): void
    {
        $this->textKey = $textKey;
    }

    
    /**
     * Returns the textValue
     *
     * @return string
     */
    public function getTextValue()
    {
        return $this->textValue;
    }

    /**
     * Sets the textValue
     *
     * @param string $textValue
     */
    public function setTextValue($textValue): void
    {
        $this->textValue = $textValue;
    }
}
