<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use Internetgalerie\IgAcl\Domain\Model\AbstractEntityWithAcl;
use Ig\IgFibu\Domain\Model\ClientInterface;
use Ig\IgFibu\ReferenceFormatter\DefaultReferenceFormatter;
use Ig\IgFibu\TaxBehavior;
use Internetgalerie\IgCrmTemplate\Domain\Model\AddressInterface;
use Internetgalerie\IgCrmTemplate\Domain\Model\TenantInterface;
use Internetgalerie\IgCrmTemplate\Domain\Repository\TemplateLetterRepository;
use Internetgalerie\IgCrmTemplate\Domain\Repository\TranslateRepository;
use Internetgalerie\IgsCrm\Domain\Repository\CardRepository;
use Internetgalerie\IgsCrm\Domain\Repository\CategoryRepository;
use Internetgalerie\IgsCrm\Domain\Repository\MitgliedschaftRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagRepository;
use Internetgalerie\IgsCrm\Domain\Repository\TagverbandRepository;
use Internetgalerie\IgsCrm\Domain\Repository\ZeitschriftRepository;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Persistence\QueryResultInterface;
use SourceBroker\T3api\Annotation as T3api;
use SourceBroker\T3api\Annotation\Serializer\Exclude;

/**
 * @T3api\ApiResource(
 *     collectionOperations={
 *          "get"={
 *              "path"="/tenants",
 *              "normalizationContext"={
 *                  "groups"={"api_get_collection_igcrm_tenant"}
 *              },
 *          },
 *     },
 *     itemOperations={
 *          "get"={
 *              "path"="/tenants/{id}",
 *              "security"="frontend.user.isLoggedIn",
 *          }
 *     },
 *     attributes={
 *          "pagination_client_enabled"=true,
 *          "pagination_items_per_page"=20,
 *          "maximum_items_per_page"=100,
 *          "pagination_client_items_per_page"=true,
 *          "persistence"={
 *              "storagePid"="2006",
 *              "recursive"=1
 *          }
 *     }
 * )
 */

class Verband extends AbstractEntityWithAcl implements AddressInterface, ClientInterface, TenantInterface
{
    /**
     * exports
     *
     * @var ObjectStorage<Export>
     * @Exclude
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    #[TYPO3\CMS\Extbase\Annotation\ORM\Lazy]
    public $exports = null;

    /**
     * parent
     *
     * @var Verband
     */
    protected $parent = null;

    /**
     * @T3api\Serializer\Groups({
     *     "api_get_collection_igcrm_tenant",
     *     "api_get_item_igcrm_tenant",
     * })
     */
    protected int $sorting = 0;
    protected string $pathUids = '';
    /**
     * @T3api\Serializer\Groups({
     *     "api_get_collection_igcrm_tenant",
     *     "api_get_item_igcrm_tenant",
     * })
     */
    protected string $name = '';
    /**
     * @T3api\Serializer\Groups({
     *     "api_get_collection_igcrm_tenant",
     *     "api_get_item_igcrm_tenant",
     * })
     */
    protected string $nameHr = '';
    protected string $nameFibu = '';
    protected string $nameDe = '';
    protected string $nameFr = '';
    protected string $nameIt = '';
    protected string $nameEn = '';
    protected string $addon = '';
    protected string $bfsUid = '';
    protected string $email = '';
    protected string $url = '';
    protected string $bankingCustomerIdentification = '';
    protected string $iban = '';
    protected string $qrIban = '';
    protected string $bankName = '';
    protected string $bankZipCity = '';
    protected string $bankKonto = '';
    protected string $mwstNr = '';
    protected string $invoiceFromEmail = '';
    protected string $invoiceFromName = '';
    protected string $invoiceTestEmail = '';
    protected string $invoiceBccEmail = '';
    protected ?int $invoicePeriodeLengthInMonth = null;
    protected string $invoiceText = '';
    protected bool $useOwnAddressNumber = false;
    protected string $invoiceCss = '';

    /**
     * taxBehavior (0 = inkl., 1 = exkl)
     */
    protected ?int $taxBehavior = null;
    protected ?float $taxRate = null;
    protected bool $usePp = false;
    protected string $exportConfig = '';

    protected ?FileReference $logo = null;

    protected ?int $logoWidth = null;

    /**
     * logoMail
     *
     * @var FileReference
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    protected $logoMail = null;


    protected ?int $logoMailWidth = null;

    protected string $street = '';
    protected string $streetNumber = '';
    protected string $address2 = '';
    protected string $address3 = '';
    protected string $zip = '';
    protected string $countryIsoCode = '';
    protected string $city = '';
    protected string $cityDe = '';
    protected string $cityFr = '';
    protected string $cityIt = '';
    protected string $cityEn = '';
    protected string $phone = '';

    /**
     * languages
     *
     * @var ObjectStorage<Language>
     */
    protected $languages;
    protected string $editJs = '';
    protected string $editCss = '';
    protected string $templateName = '';
    protected string $titleExtraTextfield1 = '';
    protected string $titleExtraTextfield2 = '';
    protected string $titleExtraTextfield3 = '';
    protected string $titleExtraTextarea1 = '';
    protected string $titleExtraTextarea2 = '';
    protected string $titleExtraTextarea3 = '';
    protected string $titleExternalId = '';
    protected string $titleTags = '';
    protected string $titleCommissions = '';
    protected string $titleCategories = '';
    protected int $veteranenAlter = 0;
    protected int $alterskategorieMode = 0;
    protected int $journalMode = 0;
    protected int $invoiceMode = 0;
    protected string $personUidAttribute = '';
    protected string $titleOrganisationId = '';
    protected string $titleJournalIsFree1 = '';
    protected string $titleJournalIsFree2 = '';
    protected string $invoiceBaseText = '';
    protected string $extraBetragTitle = '';
    protected float $extraBetragValue = 0.0;
    protected bool $testDates = false;
    protected bool $showInvoiceAddress = true;
    protected string $senderLine = '';
    protected string $postClientId = '';
    protected string $postClientSecret = '';
    protected string $postFrankingLicense = '';

    /**
     * @Exclude
     */
    protected ?CategoryRepository $categoryRepository = null;

    /**
     * @Exclude
     */
    protected ?TagRepository $tagRepository = null;

    /**
     * @Exclude
     */
    protected ?TagverbandRepository $tagverbandRepository = null;

    /**
     * @Exclude
     */
    protected ?MitgliedschaftRepository $mitgliedschaftRepository = null;

    /**
     * @Exclude
     */
    protected ?QueryResultInterface $mitgliedschaftenExclude = null;

    /**
     * @Exclude
     */
    protected ?QueryResultInterface $templateLetters = null;

    /**
     * @Exclude
     */
    protected array $templateLetter = [];

    /**
     * @Exclude
     */
    protected ?QueryResultInterface $translates = null;

    /**
     * @Exclude
     */
    protected ?QueryResultInterface $cards = null;
    /**
     * @Exclude
     */
    protected ?ZeitschriftRepository $zeitschriftRepository = null;


    
    /**
     * __construct
     */
    public function __construct()
    {
        parent::__construct();
        $this->languages = new ObjectStorage();
        $this->exports = new ObjectStorage();
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    public function __toString(): string
    {
        return $this->getName();
    }
    public function getType()
    {
        return 'Verband';
    }

    public function getNumber()
    {
        return $this->uid;
    }

    /**
     * Returns the parent
     *
     * @return Verband
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Sets the parent
     */
    public function setParent(self $parent = null): void
    {
        $this->parent = $parent;
    }

    /**
     * Returns the sorting
     *
     * @return integer
     */
    public function getSorting()
    {
        return $this->sorting;
    }

    /**
     * Sets the sorting
     *
     * @param integer $sorting
     */
    public function setSorting($sorting): void
    {
        $this->sorting = $sorting;
    }

    /**
     * Returns the pathUids
     *
     * @return string
     */
    public function getPathUids()
    {
        return $this->pathUids;
    }

    /**
     * Sets the pathUids
     *
     * @param string $pathUids
     */
    public function setPathUids($pathUids): void
    {
        $this->pathUids = $pathUids;
    }

    public function getBreadcrumb()
    {
        $breadcrumb = [];
        $pathVerband = $this;
        $limit = 10;
        do {
            $limit--;
            $breadcrumb[] = $pathVerband;
            $pathVerband = $pathVerband->getParent();
        } while ($pathVerband && $limit > 0);
        return array_reverse($breadcrumb);
    }
    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the nameHr
     *
     * @return string
     */
    public function getNameHr()
    {
        return $this->nameHr;
    }


    /**
     * Sets the nameHr
     *
     * @param string $nameHr
     */
    public function setNameHr($nameHr): void
    {
        $this->nameHr = $nameHr;
    }

    /**
     * Returns the nameFibu
     *
     * @return string
     */
    public function getNameFibu()
    {
        return $this->nameFibu;
    }

    /**
     * Sets the nameFibu
     *
     * @param string $nameFibu
     */
    public function setNameFibu($nameFibu): void
    {
        $this->nameFibu = $nameFibu;
    }


    public function getOrganisationName()
    {
        return $this->nameHr;
    }
    public function getOrganisationNameFibu()
    {
        return $this->nameFibu ?: $this->nameHr;
    }


    /**
     * Returns the nameDe
     *
     * @return string
     */
    public function getNameDe()
    {
        return $this->nameDe;
    }

    /**
     * Sets the nameDe
     *
     * @param string $nameDe
     */
    public function setNameDe($nameDe): void
    {
        $this->nameDe = $nameDe;
    }
    /**
     * Returns the nameFr
     *
     * @return string
     */
    public function getNameFr()
    {
        return $this->nameFr;
    }

    /**
     * Sets the nameFr
     *
     * @param string $nameFr
     */
    public function setNameFr($nameFr): void
    {
        $this->nameFr = $nameFr;
    }

    /**
     * Returns the nameIt
     *
     * @return string
     */
    public function getNameIt()
    {
        return $this->nameIt;
    }

    /**
     * Sets the nameIt
     *
     * @param string $nameIt
     */
    public function setNameIt($nameIt): void
    {
        $this->nameIt = $nameIt;
    }

    /**
     * Returns the nameEn
     *
     * @return string
     */
    public function getNameEn()
    {
        return $this->nameEn;
    }

    /**
     * Sets the nameEn
     *
     * @param string $nameEn
     */
    public function setNameEn($nameEn): void
    {
        $this->nameEn = $nameEn;
    }
    public function getNameLocale()
    {
        $languageId = GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect('language', 'id');
        return match ($languageId) {
            1 => $this->nameEn ?: $this->nameHr,
            2 => $this->nameFr ?: $this->nameHr,
            3 => $this->nameIt ?: $this->nameHr,
            default => $this->nameDe ?: $this->nameHr,
        };
    }

    /**
     * Returns the bfsUid
     *
     * @return string
     */
    public function getBfsUid()
    {
        return $this->bfsUid;
    }

    /**
     * Sets the bfsUid
     *
     * @param string $bfsUid
     */
    public function setBfsUid($bfsUid): void
    {
        $this->bfsUid = $bfsUid;
    }

    /**
     * Returns the email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Sets the email
     *
     * @param string $email
     */
    public function setEmail($email): void
    {
        $this->email = $email;
    }

    /**
     * E-Mail for FIBU adddress interface
     */
    public function getInvoiceEmail()
    {
        return $this->email;
    }

    /**
     * Returns the url
     *
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * Sets the url
     *
     * @param string $url
     */
    public function setUrl($url): void
    {
        $this->url = $url;
    }

    /**
     * Returns the bankingCustomerIdentification
     *
     * @return string
     */
    public function getBankingCustomerIdentification()
    {
        return $this->bankingCustomerIdentification;
    }

    /**
     * Sets the bankingCustomerIdentification
     *
     * @param string $bankingCustomerIdentification
     */
    public function setBankingCustomerIdentification($bankingCustomerIdentification): void
    {
        $this->bankingCustomerIdentification = $bankingCustomerIdentification;
    }

    /**
     * Returns the iban
     *
     * @return string
     */
    public function getIban()
    {
        return $this->iban;
    }

    /**
     * Sets the iban
     *
     * @param string $iban
     */
    public function setIban($iban): void
    {
        $this->iban = $iban;
    }

    /**
     * Returns the qrIban
     *
     * @return string
     */
    public function getQrIban()
    {
        return $this->qrIban;
    }

    /**
     * Sets the qrIban
     *
     * @param string $qrIban
     */
    public function setQrIban($qrIban): void
    {
        $this->qrIban = $qrIban;
    }

    /**
     * Returns the bankName
     *
     * @return string
     */
    public function getBankName()
    {
        return $this->bankName;
    }

    /**
     * Sets the bankName
     *
     * @param string $bankName
     */
    public function setBankName($bankName): void
    {
        $this->bankName = $bankName;
    }

    /**
     * Returns the bankZipCity
     *
     * @return string
     */
    public function getBankZipCity()
    {
        return $this->bankZipCity;
    }

    /**
     * Sets the bankZipCity
     *
     * @param string $bankZipCity
     */
    public function setBankZipCity($bankZipCity): void
    {
        $this->bankZipCity = $bankZipCity;
    }

    /**
     * Returns the bankKonto
     *
     * @return string
     */
    public function getBankKonto()
    {
        return $this->bankKonto;
    }

    /**
     * Sets the bankKonto
     *
     * @param string $bankKonto
     */
    public function setBankKonto($bankKonto): void
    {
        $this->bankKonto = $bankKonto;
    }


    /**
     * Returns the mwstNr
     *
     * @return string
     */
    public function getMwstNr()
    {
        return $this->mwstNr;
    }

    /**
     * Sets the mwstNr
     *
     * @param string $mwstNr
     */
    public function setMwstNr($mwstNr): void
    {
        $this->mwstNr = $mwstNr;
    }


    /**
     * Returns the invoiceFromName
     *
     * @return string
     */
    public function getInvoiceFromName()
    {
        return $this->invoiceFromName;
    }

    /**
     * Sets the invoiceFromName
     *
     * @param string $invoiceFromName
     */
    public function setInvoiceFromName($invoiceFromName): void
    {
        $this->invoiceFromName = $invoiceFromName;
    }

    /**
     * Returns the invoiceFromEmail
     *
     * @return string
     */
    public function getInvoiceFromEmail()
    {
        return $this->invoiceFromEmail;
    }

    /**
     * Sets the invoiceFromEmail
     *
     * @param string $invoiceFromEmail
     */
    public function setInvoiceFromEmail($invoiceFromEmail): void
    {
        $this->invoiceFromEmail = $invoiceFromEmail;
    }

    /**
     * Returns the invoiceTestEmail
     *
     * @return string
     */
    public function getInvoiceTestEmail()
    {
        return $this->invoiceTestEmail;
    }

    /**
     * Sets the invoiceTestEmail
     *
     * @param string $invoiceTestEmail
     */
    public function setInvoiceTestEmail($invoiceTestEmail): void
    {
        $this->invoiceTestEmail = $invoiceTestEmail;
    }

    /**
     * Returns the invoiceBccEmail
     *
     * @return string
     */
    public function getInvoiceBccEmail()
    {
        return $this->invoiceBccEmail;
    }

    /**
     * Sets the invoiceBccEmail
     *
     * @param string $invoiceBccEmail
     */
    public function setInvoiceBccEmail($invoiceBccEmail): void
    {
        $this->invoiceBccEmail = $invoiceBccEmail;
    }
    
    /**
     * Returns the invoicePeriodeLengthInMonth
     *
     * @return int
     */
    public function getInvoicePeriodeLengthInMonth()
    {
        return $this->invoicePeriodeLengthInMonth;
    }

    /**
     * Sets the invoicePeriodeLengthInMonth
     *
     * @param int $invoicePeriodeLengthInMonth
     */
    public function setInvoicePeriodeLengthInMonth($invoicePeriodeLengthInMonth): void
    {
        $this->invoicePeriodeLengthInMonth = $invoicePeriodeLengthInMonth;
    }


    /**
     * Returns the invoiceText
     *
     * @return string
     */
    public function getInvoiceText()
    {
        return $this->invoiceText;
    }

    /**
     * Sets the invoiceText
     *
     * @param string $invoiceText
     */
    public function setInvoiceText($invoiceText): void
    {
        $this->invoiceText = $invoiceText;
    }

    public function getUseOwnAddressNumber(): bool
    {
        return $this->useOwnAddressNumber;
    }

    public function setUseOwnAddressNumber(bool $useOwnAddressNumber): void
    {
        $this->useOwnAddressNumber = $useOwnAddressNumber;
    }
    
    /**
     * Returns the exportConfig
     *
     * @return string
     */
    public function getExportConfig()
    {
        return $this->exportConfig;
    }
    /**
     * Returns the exportConfig
     *
     * @return object
     */
    public function getExportConfigObject()
    {
        return json_decode($this->exportConfig);
    }

    /**
     * Sets the exportConfig
     *
     * @param string $exportConfig
     */
    public function setExportConfig($exportConfig): void
    {
        $this->exportConfig = $exportConfig;
    }

    /**
     * Returns the logo
     */
    public function getLogo(): ?FileReference
    {
        return $this->logo;
    }

    /**
     * Sets the logo
     */
    public function setLogo(?FileReference $logo = null): void
    {
        $this->logo = $logo;
    }



    /**
     * Returns the logoWidth
     *
     * @return ?int $logoWidth
     */
    public function getLogoWidth()
    {
        return $this->logoWidth ?: null;
    }

    /**
     * Sets the logoWidth
     */
    public function setLogoWidth(int $logoWidth = null): void
    {
        $this->logoWidth = $logoWidth;
    }


    /**
     * Returns the logoMail
     *
     * @return FileReference
     */
    public function getLogoMail()
    {
        return $this->logoMail;
    }

    /**
     * Sets the logoMail
     */
    public function setLogoMail(FileReference $logoMail = null): void
    {
        $this->logoMail = $logoMail;
    }

    /**
     * Returns the logoMailWidth
     *
     * @return ?int $logoMailWidth
     */
    public function getLogoMailWidth()
    {
        return $this->logoMailWidth ?: null;
    }

    /**
     * Sets the logoMailWidth
     */
    public function setLogoMailWidth(int $logoMailWidth = null): void
    {
        $this->logoMailWidth = $logoMailWidth;
    }


    /**
     * Returns the street
     *
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * Sets the street
     *
     * @param string $street
     */
    public function setStreet($street): void
    {
        $this->street = $street;
    }

    /**
     * Returns the streetNumber
     *
     * @return string
     */
    public function getStreetNumber()
    {
        return $this->streetNumber;
    }

    /**
     * Sets the streetNumber
     *
     * @param string $streetNumber
     */
    public function setStreetNumber($streetNumber): void
    {
        $this->streetNumber = $streetNumber;
    }
    public function getAddress()
    {
        return $this->street . ($this->streetNumber ? ' ' . $this->streetNumber : '');
    }

    /**
     * Returns the address2
     *
     * @return string
     */
    public function getAddress2()
    {
        return $this->address2;
    }

    /**
     * Sets the address2
     *
     * @param string $address2
     */
    public function setAddress2($address2): void
    {
        $this->address2 = $address2;
    }

    /**
     * Returns the address3
     *
     * @return string
     */
    public function getAddress3()
    {
        return $this->address3;
    }

    /**
     * Sets the address3
     *
     * @param string $address3
     */
    public function setAddress3($address3): void
    {
        $this->address3 = $address3;
    }

    /**
     * Returns the countryIsoCode
     *
     * @return string
     */
    public function getCountryIsoCode()
    {
        return $this->countryIsoCode;
    }
    public function getCountryPostalCode()
    {
        return $this->countryIsoCode == 'LI' ? 'FL' : $this->countryIsoCode;
    }

    /**
     * Sets the countryIsoCode
     *
     * @param string $countryIsoCode
     */
    public function setCountryIsoCode($countryIsoCode): void
    {
        $this->countryIsoCode = $countryIsoCode;
    }

    /**
     * Returns the zip
     *
     * @return string
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * Sets the zip
     *
     * @param string $zip
     */
    public function setZip($zip): void
    {
        $this->zip = $zip;
    }

    /**
     * Returns the city
     *
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * Sets the city
     *
     * @param string $city
     */
    public function setCity($city): void
    {
        $this->city = $city;
    }

    /**
     * Returns the cityDe
     *
     * @return string
     */
    public function getCityDe()
    {
        return $this->cityDe;
    }

    /**
     * Sets the cityDe
     *
     * @param string $cityDe
     */
    public function setCityDe($cityDe): void
    {
        $this->cityDe = $cityDe;
    }

    /**
     * Returns the cityFr
     *
     * @return string
     */
    public function getCityFr()
    {
        return $this->cityFr;
    }

    /**
     * Sets the cityFr
     *
     * @param string $cityFr
     */
    public function setCityFr($cityFr): void
    {
        $this->cityFr = $cityFr;
    }

    /**
     * Returns the cityIt
     *
     * @return string
     */
    public function getCityIt()
    {
        return $this->cityIt;
    }

    /**
     * Sets the cityIt
     *
     * @param string $cityIt
     */
    public function setCityIt($cityIt): void
    {
        $this->cityIt = $cityIt;
    }
    /**
     * Returns the cityEn
     *
     * @return string
     */
    public function getCityEn()
    {
        return $this->cityEn;
    }

    /**
     * Sets the cityEn
     *
     * @param string $cityEn
     */
    public function setCityEn($cityEn): void
    {
        $this->cityEn = $cityEn;
    }

    public function getCityLocale()
    {
        $languageId = GeneralUtility::makeInstance(Context::class)->getPropertyFromAspect('language', 'id');
        return match ($languageId) {
            1 => $this->cityEn ?: $this->city,
            2 => $this->cityFr ?: $this->city,
            3 => $this->cityIt ?: $this->city,
            default => $this->cityDe ?: $this->city,
        };
    }

    /**
     * Returns the phone
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Sets the phone
     *
     * @param string $phone
     */
    public function setPhone($phone): void
    {
        $this->phone = $phone;
    }

    /**
     * Sets the languages. Keep in mind that the property is called "languages"
     * although it can hold several languages.
     *
     * @param ObjectStorage<Language> $languages
     */
    public function setLanguages(ObjectStorage $languages): void
    {
        /*
        foreach ($languages as $language) {
            var_dump($language);
        }die('a');
        */
        $this->languages = $languages;
    }

    /**
     * Adds a languages to the frontend user
     */
    public function addLanguages(Language $languages): void
    {
        $this->languages->attach($languages);
    }

    /**
     * Adds a Language to language (if not already exists)
     */
    public function addLanguagesIfNotContains(Language $languages): void
    {
        if (!$this->languages->contains($languages)) {
            $this->languages->attach($languages);
        }
    }

    /**
     * Removes a languages from the frontend user
     */
    public function removeLanguages(Language $languages): void
    {
        $this->languages->detach($languages);
    }

    /**
     * Returns the languages
     *
     * @return ObjectStorage<Language> An object storage containing the languages
     */
    public function getLanguages()
    {
        return $this->languages;
    }









    /**
     * Returns the editJs
     *
     * @return string
     */
    public function getEditJs()
    {
        return $this->editJs;
    }

    /**
     * Sets the editJs
     *
     * @param string $editJs
     */
    public function setEditJs($editJs): void
    {
        $this->editJs = $editJs;
    }

    /**
     * Returns the editCss
     *
     * @return string
     */
    public function getEditCss()
    {
        return $this->editCss;
    }

    /**
     * Sets the editCss
     *
     * @param string $editCss
     */
    public function setEditCss($editCss): void
    {
        $this->editCss = $editCss;
    }

    /**
     * Returns the templateName
     *
     * @return string
     */
    public function getTemplateName()
    {
        return $this->templateName;
    }

    /**
     * Sets the templateName
     *
     * @param string $templateName
     */
    public function setTemplateName($templateName): void
    {
        $this->templateName = $templateName;
    }
    /**
     * Returns the titleExtraTextfield1
     *
     * @return string
     */
    public function getTitleExtraTextfield1()
    {
        return $this->titleExtraTextfield1;
    }

    /**
     * Sets the titleExtraTextfield1
     *
     * @param string $titleExtraTextfield1
     */
    public function setTitleExtraTextfield1($titleExtraTextfield1): void
    {
        $this->titleExtraTextfield1 = $titleExtraTextfield1;
    }

    /**
     * Returns the titleExtraTextfield2
     *
     * @return string
     */
    public function getTitleExtraTextfield2()
    {
        return $this->titleExtraTextfield2;
    }

    /**
     * Sets the titleExtraTextfield2
     *
     * @param string $titleExtraTextfield2
     */
    public function setTitleExtraTextfield2($titleExtraTextfield2): void
    {
        $this->titleExtraTextfield2 = $titleExtraTextfield2;
    }

    /**
     * Returns the titleExtraTextfield3
     *
     * @return string
     */
    public function getTitleExtraTextfield3()
    {
        return $this->titleExtraTextfield3;
    }

    /**
     * Sets the titleExtraTextfield3
     *
     * @param string $titleExtraTextfield3
     */
    public function setTitleExtraTextfield3($titleExtraTextfield3): void
    {
        $this->titleExtraTextfield3 = $titleExtraTextfield3;
    }

    /**
     * Returns the titleExtraTextarea1
     *
     * @return string
     */
    public function getTitleExtraTextarea1()
    {
        return $this->titleExtraTextarea1;
    }

    /**
     * Sets the titleExtraTextarea1
     *
     * @param string $titleExtraTextarea1
     */
    public function setTitleExtraTextarea1($titleExtraTextarea1): void
    {
        $this->titleExtraTextarea1 = $titleExtraTextarea1;
    }

    /**
     * Returns the titleExtraTextarea2
     *
     * @return string
     */
    public function getTitleExtraTextarea2()
    {
        return $this->titleExtraTextarea2;
    }

    /**
     * Sets the titleExtraTextarea2
     *
     * @param string $titleExtraTextarea2
     */
    public function setTitleExtraTextarea2($titleExtraTextarea2): void
    {
        $this->titleExtraTextarea2 = $titleExtraTextarea2;
    }

    /**
     * Returns the titleExtraTextarea3
     *
     * @return string
     */
    public function getTitleExtraTextarea3()
    {
        return $this->titleExtraTextarea3;
    }

    /**
     * Sets the titleExtraTextarea3
     *
     * @param string $titleExtraTextarea3
     */
    public function setTitleExtraTextarea3($titleExtraTextarea3): void
    {
        $this->titleExtraTextarea3 = $titleExtraTextarea3;
    }

    /**
     * Returns the titleExternalId
     *
     * @return string
     */
    public function getTitleExternalId()
    {
        return $this->titleExternalId;
    }

    /**
     * Sets the titleExternalId
     *
     * @param string $titleExternalId
     */
    public function setTitleExternalId($titleExternalId): void
    {
        $this->titleExternalId = $titleExternalId;
    }

    /**
     * Returns the titleTags
     *
     * @return string
     */
    public function getTitleTags()
    {
        return $this->titleTags;
    }

    /**
     * Sets the titleTags
     *
     * @param string $titleTags
     */
    public function setTitleTags($titleTags): void
    {
        $this->titleTags = $titleTags;
    }

    /**
     * Returns the titleCommissions
     *
     * @return string
     */
    public function getTitleCommissions()
    {
        return $this->titleCommissions;
    }

    /**
     * Sets the titleCommissions
     *
     * @param string $titleCommissions
     */
    public function setTitleCommissions($titleCommissions): void
    {
        $this->titleCommissions = $titleCommissions;
    }

    /**
     * Returns the titleCategories
     *
     * @return string
     */
    public function getTitleCategories()
    {
        return $this->titleCategories;
    }

    /**
     * Sets the titleCategories
     *
     * @param string $titleCategories
     */
    public function setTitleCategories($titleCategories): void
    {
        $this->titleCategories = $titleCategories;
    }

    /**
     * Returns the veteranenAlter
     *
     * @return int
     */
    public function getVeteranenAlter()
    {
        return $this->veteranenAlter;
    }

    /**
     * Sets the veteranenAlter
     *
     * @param int $veteranenAlter
     */
    public function setVeteranenAlter($veteranenAlter): void
    {
        $this->veteranenAlter = $veteranenAlter;
    }

    /**
     * Returns the alterskategorieMode
     *
     * @return int
     */
    public function getAlterskategorieMode()
    {
        return $this->alterskategorieMode;
    }

    /**
     * Sets the alterskategorieMode
     *
     * @param int $alterskategorieMode
     */
    public function setAlterskategorieMode($alterskategorieMode): void
    {
        $this->alterskategorieMode = $alterskategorieMode;
    }

    /**
     * Returns the journalMode
     *
     * @return int
     */
    public function getJournalMode()
    {
        return $this->journalMode;
    }

    /**
     * Sets the journalMode
     *
     * @param int $journalMode
     */
    public function setJournalMode($journalMode): void
    {
        $this->journalMode = $journalMode;
    }

    /**
     * Returns the invoiceMode
     *
     * @return int
     */
    public function getInvoiceMode()
    {
        return $this->invoiceMode;
    }

    /**
     * Sets the invoiceMode
     *
     * @param int $invoiceMode
     */
    public function setInvoiceMode($invoiceMode): void
    {
        $this->invoiceMode = $invoiceMode;
    }






    /**
     * Returns the personUidAttribute
     *
     * @return string
     */
    public function getPersonUidAttribute()
    {
        return $this->personUidAttribute;
    }

    /**
     * Sets the personUidAttribute
     *
     * @param string $personUidAttribute
     */
    public function setPersonUidAttribute($personUidAttribute): void
    {
        $this->personUidAttribute = $personUidAttribute;
    }




    /**
     * Returns the titleOrganisationId
     *
     * @return string
     */
    public function getTitleOrganisationId()
    {
        return $this->titleOrganisationId;
    }

    /**
     * Sets the titleOrganisationId
     *
     * @param string $titleOrganisationId
     */
    public function setTitleOrganisationId($titleOrganisationId): void
    {
        $this->titleOrganisationId = $titleOrganisationId;
    }

    /**
     * Returns the titleJournalIsFree1
     *
     * @return string
     */
    public function getTitleJournalIsFree1()
    {
        return $this->titleJournalIsFree1;
    }

    /**
     * Sets the titleJournalIsFree1
     *
     * @param string $titleJournalIsFree1
     */
    public function setTitleJournalIsFree1($titleJournalIsFree1): void
    {
        $this->titleJournalIsFree1 = $titleJournalIsFree1;
    }

    /**
     * Returns the titleJournalIsFree2
     *
     * @return string
     */
    public function getTitleJournalIsFree2()
    {
        return $this->titleJournalIsFree2;
    }

    /**
     * Sets the titleJournalIsFree2
     *
     * @param string $titleJournalIsFree2
     */
    public function setTitleJournalIsFree2($titleJournalIsFree2): void
    {
        $this->titleJournalIsFree2 = $titleJournalIsFree2;
    }


    /**
     * Returns the invoiceBaseText
     *
     * @return string
     */
    public function getInvoiceBaseText()
    {
        return $this->invoiceBaseText;
    }

    /**
     * Sets the invoiceBaseText
     *
     * @param string $invoiceBaseText
     */
    public function setInvoiceBaseText($invoiceBaseText): void
    {
        $this->invoiceBaseText = $invoiceBaseText;
    }



    /**
     * Returns the extraBetragTitle
     *
     * @return string
     */
    public function getExtraBetragTitle()
    {
        return $this->extraBetragTitle;
    }

    /**
     * Sets the extraBetragTitle
     *
     * @param string $extraBetragTitle
     */
    public function setExtraBetragTitle($extraBetragTitle): void
    {
        $this->extraBetragTitle = $extraBetragTitle;
    }

    /**
     * Returns the extraBetragValue
     *
     * @return float
     */
    public function getExtraBetragValue()
    {
        return $this->extraBetragValue;
    }

    /**
     * Sets the extraBetragValue
     *
     * @param float $extraBetragValue
     */
    public function setExtraBetragValue($extraBetragValue): void
    {
        $this->extraBetragValue = $extraBetragValue;
    }


    /**
     * Returns the testDates
     *
     * @return boolean
     */
    public function getTestDates()
    {
        return $this->testDates;
    }

    /**
     * Sets the testDates
     *
     * @param boolean $testDates
     */
    public function setTestDates($testDates): void
    {
        $this->testDates = $testDates;
    }

    /**
     * Returns the boolean state of testDates
     *
     * @return boolean
     */
    public function isTestDates()
    {
        return $this->testDates;
    }


    /**
     * Returns the showInvoiceAddress
     *
     * @return boolean
     */
    public function getShowInvoiceAddress()
    {
        return $this->showInvoiceAddress;
    }

    /**
     * Sets the showInvoiceAddress
     *
     * @param boolean $showInvoiceAddress
     */
    public function setShowInvoiceAddress($showInvoiceAddress): void
    {
        $this->showInvoiceAddress = $showInvoiceAddress;
    }

    /**
     * Returns the boolean state of showInvoiceAddress
     *
     * @return boolean
     */
    public function isShowInvoiceAddress()
    {
        return $this->showInvoiceAddress;
    }

    /**
     * Adds a Export
     */
    public function addExport(Export $export): void
    {
        $this->exports->attach($export);
    }

    /**
     * Removes a Export
     *
     * @param Export $exportToRemove The Export to be removed
     */
    public function removeExport(Export $exportToRemove): void
    {
        $this->exports->detach($exportToRemove);
    }

    /**
     * Returns the exports
     *
     * @return ObjectStorage<Export> $exports
     */
    public function getExports()
    {
        return $this->exports;
    }

    /**
     * Sets the exports
     *
     * @param ObjectStorage<Export> $exports
     */
    public function setExports(ObjectStorage $exports): void
    {
        $this->exports = $exports;
    }


    public function getCategories()
    {
        if ($this->categoryRepository === null) {
            $this->categoryRepository = GeneralUtility::makeInstance(CategoryRepository::class);
        }
        return $this->categoryRepository->findBy([
            'verband' => $this,
        ]);
    }
    public function getTags()
    {
        if ($this->tagRepository === null) {
            $this->tagRepository = GeneralUtility::makeInstance(TagRepository::class);
        }
        return $this->tagRepository->findBy([
            'verband' => $this,
        ]);
    }

    public function getJournals()
    {
        if ($this->zeitschriftRepository === null) {
            $this->zeitschriftRepository = GeneralUtility::makeInstance(ZeitschriftRepository::class);
        }
        return $this->zeitschriftRepository->findBy([
            'verband' => $this,
        ]);
    }

    public function getTagsverband()
    {
        if ($this->tagverbandRepository === null) {
            $this->tagverbandRepository = GeneralUtility::makeInstance(TagverbandRepository::class);
        }
        return $this->tagverbandRepository->findBy([
            'verband' => $this,
        ]);
    }

    public function getMitgliedschaften()
    {
        if ($this->mitgliedschaftRepository === null) {
            $this->mitgliedschaftRepository = GeneralUtility::makeInstance(MitgliedschaftRepository::class);
        }
        return $this->mitgliedschaftRepository->findBy([
            'verband' => $this,
        ]);
    }

    /**
     * Get the value of invoiceCss
     *
     * @return string
     */
    public function getInvoiceCss()
    {
        return $this->invoiceCss;
    }

    /**
     * Set the value of invoiceCss
     *
     * @param string $invoiceCss
     *
     * @return self
     */
    public function setInvoiceCss($invoiceCss)
    {
        $this->invoiceCss = $invoiceCss;
    }

    public function getTaxRate(): float
    {
        return $this->taxRate;
    }
    public function getMwst()
    {
        return $this->taxRate;
    }

    public function setTaxRate(float $taxRate): void
    {
        $this->taxRate = $taxRate;
    }

    /**
     * Returns the taxBehavior
     *
     * @return int
     */
    public function getTaxBehavior()
    {
        return $this->taxBehavior;
    }
    public function getTaxBehaviorIsInkl()
    {
        return $this->taxBehavior === TaxBehavior::INCLUSIVE;
    }
    public function getTaxBehaviorIsExkl()
    {
        return $this->taxBehavior === TaxBehavior::EXCLUSIVE;
    }
    public function getTaxBehaviorIsExempt()
    {
        return $this->taxBehavior === TaxBehavior::EXEMPT;
    }
    public function getTaxBehaviorIsUnspecified()
    {
        return $this->taxBehavior === null;
    }

    /**
     * Sets the taxBehavior
     */
    public function setTaxBehavior(int $taxBehavior = null): void
    {
        $this->taxBehavior = $taxBehavior;
    }
    public function getUsePp(): bool
    {
        return $this->usePp;
    }

    public function setUsePp(bool $usePp): void
    {
        $this->usePp = $usePp;
    }

    public function getMitgliedschaftenExclude()
    {
        if ($this->mitgliedschaftenExclude === null) {
            $mitgliedschaftRepository = GeneralUtility::makeInstance(MitgliedschaftRepository::class);
            $this->mitgliedschaftenExclude = $mitgliedschaftRepository->findByVerbandExcludedStatistik(
                $this->getUid(),
                1
            );
        }
        return $this->mitgliedschaftenExclude;
    }

    public function getCards()
    {
        if ($this->cards === null) {
            $cardRepository = GeneralUtility::makeInstance(CardRepository::class);
            $this->cards = $cardRepository->findBy([
                'verband' => $this->getUid(),
            ]);
        }
        return $this->cards;
    }
    
    public function getTemplateLetters()
    {
        if ($this->templateLetters === null) {
            $templateLetterRepository = GeneralUtility::makeInstance(TemplateLetterRepository::class);
            $this->templateLetters = $templateLetterRepository->findBy([
                'tenantId' => $this->getUid(),
            ]);
        }
        return $this->templateLetters;
    }

    public function getTemplateLetterFavorites()
    {
        $templateLetterRepository = GeneralUtility::makeInstance(TemplateLetterRepository::class);
        return $templateLetterRepository->findFavoritesByVerbandType($this->getUid(), 'Letter', null);
    }


    //public function getTemplateLetter(string $templateType, string $objectType, \Internetgalerie\IgsCrm\Domain\Model\Language $crmLanguage = null, Invoice $invoice = null)
    /*
    public function getTemplateLetter(string $templateType, Contact $contact, Invoice $invoice = null)
    {
        $objectType = $contact->getType();
        $crmLanguage = $contact->getLanguageWithFallback(['de', 'fr']);
        if ($invoice !== null) {
            $mitgliedschaftUid = $invoice->getMitgliedschaft();
        } else {
            $mitgliedschaftUid = 0;
        }
        CrmTranslate::setVerband($this->uid);
        if ($crmLanguage instanceof \Internetgalerie\IgsCrm\Domain\Model\Language) {
            $crmLanguageUid = $crmLanguage->getUid();
            if (isset($this->templateLetter[$templateType][$objectType][$crmLanguageUid][$mitgliedschaftUid])) {
                CrmTranslate::setCrmLanguage($crmLanguageUid);
                return $this->templateLetter[$templateType][$objectType][$crmLanguageUid][$mitgliedschaftUid];
            }
        } else {
            $crmLanguageUid = 0;
        }
        CrmTranslate::setCrmLanguage($crmLanguageUid);
        if (!isset($this->templateLetter[$templateType])) {
            $this->templateLetter[$templateType] = [];
        }
        if (!isset($this->templateLetter[$templateType][$objectType])) {
            $this->templateLetter[$templateType][$objectType] = [];
        }
        if (!isset($this->templateLetter[$templateType][$objectType][$crmLanguageUid])) {
            $this->templateLetter[$templateType][$objectType][$crmLanguageUid] = [];
        }
        $templateLetterRepository = GeneralUtility::makeInstance(TemplateLetterRepository::class);
        $template = null;

        if ($mitgliedschaftUid) {
            $template = $templateLetterRepository->findOneByVerbandTypeLanguageMainTag($this->uid, $templateType, $invoice, $objectType, $crmLanguageUid, $mitgliedschaftUid);
            if ($template === null) {
                $template = $templateLetterRepository->findOneByVerbandTypeLanguageMainTag($this->uid, $templateType, $invoice, $objectType, null, $mitgliedschaftUid);
            }
        }
        if ($template === null) {
            if (isset($this->templateLetter[$templateType][$objectType][$crmLanguageUid]['0'])) {
                $template = $this->templateLetter[$templateType][$objectType][$crmLanguageUid]['0'];
            } else {
                $template = $templateLetterRepository->findOneByVerbandTypeLanguage($this->uid, $templateType, $invoice, $objectType, $crmLanguageUid);
                if ($template === null) {
                    $template = $templateLetterRepository->findOneByVerbandTypeLanguage($this->uid, $templateType, $invoice, $objectType, null);
                }
            }
        }
        if ($template === null) {
            echo '<h1>Error: No template found</h1>';
            echo 'Verband: ' . $this->getName() . ' ('.$this->uid.')<br />';
            echo 'Template Type: ' . $templateType .'<br />';
            if ($invoice) {
                $invoiceType = $invoice->getType();
                $invoiceStatus = $invoice->getStatus() ? $invoice->getStatus()->getTitle() : '';
                echo 'Invoice Type: ' . $invoiceType .'<br />';
                echo 'Invoice Status: ' . $invoiceStatus .'<br />';
            }
            echo 'Object Type: ' . $objectType .'<br />';
            echo 'CRM Sprache: ' . $crmLanguageUid .'<br />';
            echo 'Mitgliedschaft: ' . ($mitgliedschaftUid ?? '[[ohne]]') .'<br />';
            exit(0);
        }
        $this->templateLetter[$templateType][$objectType][$crmLanguageUid][$mitgliedschaftUid] = $template;
        return $this->templateLetter[$templateType][$objectType][$crmLanguageUid][$mitgliedschaftUid];
    }
     */
    public function getTranslates()
    {
        if ($this->translates === null) {
            $translateRepository = GeneralUtility::makeInstance(TranslateRepository::class);
            $this->translates = $translateRepository->findBy([
                'tenantId' => $this->getUid(),
            ]);
            //var_dump($this->translates->count(), $this->getUid());exit(0);
        }
        return $this->translates;
    }
    public function getReferenceFormatterClass(): string
    {
        return DefaultReferenceFormatter::class;
    }
    
    public function getLanguageCode()
    {
        return 'de';
    }
    public function setAddon(string $addon): void
    {
        $this->addon = $addon;
    }
    
    public function getAddon()
    {
        return $this->addon;
    }
    public function getPoboxText()
    {
        return '';
    }
    public function getIsOrganisation()
    {
        return true;
    }

    /**
     * Get the value of senderLine
     *
     * @return string
     */
    public function getSenderLine()
    {
        return $this->senderLine;
    }

    /**
     * Set the value of senderLine
     *
     * @param string $senderLine
     *
     * @return self
     */
    public function setSenderLine($senderLine)
    {
        $this->senderLine = $senderLine;
    }
    public function getPostClientId()
    {
        return $this->postClientId;
    }
    public function setPostClientId($postClientId)
    {
        $this->postClientId = $postClientId;
    }

    public function getPostClientSecret()
    {
        return $this->postClientSecret;
    }
    public function setPostClientSecret($postClientSecret)
    {
        $this->postClientSecret = $postClientSecret;
    }


    public function getPostFrankingLicense()
    {
        return $this->postFrankingLicense;
    }
    public function setPostFrankingLicense($postFrankingLicense)
    {
        $this->postFrankingLicense = $postFrankingLicense;
    }

/**
     * Initializes all ObjectStorage properties
     */
    protected function initStorageObjects()
    {
        parent::initStorageObjects();
        $this->exports ??= new ObjectStorage();
        $this->languages ??= new ObjectStorage();
    }
}
