<?php

namespace Internetgalerie\IgsCrm\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Zeitschrift extends AbstractEntity
{
    /**
     * verband
     *
     * @var Verband
     */
    public $verband = null;

    /**
     * preise
     *
     * @var ObjectStorage<Preise>
     */
    #[TYPO3\CMS\Extbase\Annotation\ORM\Cascade([
        'value' => 'remove',
    ])]
    public $preise = null;
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * betrag
     *
     * @var float
     */
    protected $betrag = 0.0;

    /**
     * __construct
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }
    public function __toString(): string
    {
        return $this->getName();
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the betrag
     *
     * @return float
     */
    public function getBetrag()
    {
        return $this->betrag;
    }


    public function getBetragWithAlter($alterInJahre)
    {
        if (intval($alterInJahre) <= 0) {
            return $this->betrag;
        }
        foreach ($this->getPreise() as $preis) {
            if ($preis->getAlterInJahrVon() <= $alterInJahre && $preis->getAlterInJahrBis() >= $alterInJahre) {
                return $preis->getBetrag();
            }
        }
        return $this->betrag;
    }

    /**
     * Sets the betrag
     *
     * @param float $betrag
     */
    public function setBetrag($betrag): void
    {
        $this->betrag = $betrag;
    }

    /**
     * Returns the verband
     *
     * @return Verband
     */
    public function getVerband()
    {
        return $this->verband;
    }

    /**
     * Sets the verband
     */
    public function setVerband(Verband $verband): void
    {
        $this->verband = $verband;
    }

    /**
     * Adds a Preise
     */
    public function addPreise(Preise $preise): void
    {
        $this->preise->attach($preise);
    }

    /**
     * Removes a Preise
     *
     * @param Preise $preiseToRemove The Preise to be removed
     */
    public function removePreise(Preise $preiseToRemove): void
    {
        $this->preise->detach($preiseToRemove);
    }

    /**
     * Returns the preise
     *
     * @return ObjectStorage<Preise> $preise
     */
    public function getPreise()
    {
        return $this->preise;
    }

    /**
     * Sets the preise
     *
     * @param ObjectStorage<Preise> $preise
     */
    public function setPreise(ObjectStorage $preise): void
    {
        $this->preise = $preise;
    }
    public function getNamePrice()
    {
        return $this->name . ' (CHF' . number_format($this->betrag, 2) . ')';
    }
    public function getInvoicestext()
    {
        return $this->name;
    }

    /**
     * Initializes all ObjectStorage properties
     * Do not modify this method!
     * It will be rewritten on each save in the extension builder
     * You may modify the constructor of this class instead
     */
    protected function initStorageObjects()
    {
        $this->preise = new ObjectStorage();
    }
}
