<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use Internetgalerie\IgsCrm\Utility\ConfUtility;
use Internetgalerie\IgsCrm\Utility\SecurityUtility;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * abstrace crm repository for acls
 */
abstract class AbstractCrmRepository extends Repository
{
    protected static $requiredRole = 'crm';
    /**
     * confUtility
     *
     * @var ConfUtility
     */
    protected $confUtility = null;


    /**
     * securityUtility
     *
     * @var SecurityUtility
     */
    protected $securityUtility = null;


    /**
     * use acl for queries
     *
     * @var bool
     */
    protected $useAcl = true;

    /**
     * security token
     *
     * @var string
     */
    protected $token = null;
    

    /**
     * Inject the ConfUtility (for checking access to objects)
     */
    public function injectConfUtility(ConfUtility $confUtility): void
    {
        $this->confUtility = $confUtility;
    }

    /**
     * Inject the SecurityUtility (for checking access to objects)
     */
    public function injectSecurityUtility(SecurityUtility $securityUtility): void
    {
        $this->securityUtility = $securityUtility;
    }

    public function getToken()
    {
        return $this->token;
    }
    public function setToken(bool $token)
    {
        $this->setUseAcl(false);
        return $this->token = $token;
    }
    
    public function getUseAcl()
    {
        return $this->useAcl;
    }
    public function setUseAcl(bool $useAcl)
    {
        return $this->useAcl = $useAcl;
    }
    
    public function getQueryConstraintsWithAcl($query)
    {
        $constraints = [];
        if (!$this->useAcl) {
            return $constraints;
        }
        if (!$this->securityUtility->hasRoleAdmin(self::$requiredRole)) {
            $orConstraints = [$query->equals('aclOwner', $this->securityUtility->getFrontendUserId())];
            foreach ($this->securityUtility->getFrontendUserGroupIds() as $userGroupId) {
                // is inSet / "FIND_IN_SET(" . (int) $userGroupId . " ,acl_read_groups)"
                $orConstraints[] = $query->contains('aclReadGroups', $userGroupId);
                /*
                  // alternatic
                  $orConstraints[] =  $query->like('aclReadGroups', $userGroupId .',%'); // am Anfang
                  $orConstraints[] =  $query->like('aclReadGroups', .'%,'$userGroupId.',%'); // in der Mitte
                  $orConstraints[] =  $query->like('aclReadGroups', '%,' . $userGroupId); // am schluss
                 */
            }
            //var_dump($orConstraints);exit(0);
            if (!empty($orConstraints)) {
                $constraints[] = $query->logicalOr(...$orConstraints);
            }

            //$constraints[] = $query->in('aclWriteGroups', $this->securityUtility->getFrontendUserGroupIds());
        }
        return $constraints;
    }
    public function getQueryBuilderConstraintsWithAcl($queryBuilder)
    {
        $constraints = [];
        if (!$this->securityUtility->hasRoleAdmin(self::$requiredRole)) {
            $frontendUserGroupIds = $this->securityUtility->getFrontendUserGroupIds();

            $orConstraints = [
                $queryBuilder->expr()
                    ->eq('acl_owner', $this->securityUtility->getFrontendUserId()),
            ];
            foreach ($this->securityUtility->getFrontendUserGroupIds() as $userGroupId) {
                //$orConstraints[] =  "FIND_IN_SET(" . (int) $userGroupId . " ,acl_write_groups)";
                $orConstraints[] = $queryBuilder->expr()->inSet('acl_read_groups', $userGroupId);
            }
            //var_dump($orConstraints);exit(0);
            if (!empty($orConstraints)) {
                $constraints[] = $queryBuilder->expr()->or(...$orConstraints);
            }

        }
        return $constraints;
    }
}
