<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;

/**
 * The repository for Anredes
 */
class AnredeRepository extends AbstractCrmRepository
{
    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    public function findBySearch(array $search)
    {
        $query = $this->createQuery();

        if (!empty($search)) {
            $searchwordConstraints = [];
            if ($search['searchword']) {
                $searchwords = explode(' ', (string) $search['searchword']);

                foreach ($searchwords as $searchword) {
                    $searchwordConstraints[] = $query->logicalOr(
                        $query->like('anName', '%' . $searchword . '%'),
                        $query->like('anNameFr', '%' . $searchword . '%'),
                        $query->like('anNameIt', '%' . $searchword . '%'),
                        $query->like('letterFormalDe', '%' . $searchword . '%'),
                        $query->like('letterFormalFr', '%' . $searchword . '%'),
                        $query->like('letterFormalIt', '%' . $searchword . '%')
                    );
                }
            }

            if (!empty($searchwordConstraints)) {
                $query->matching($query->logalAnd($searchwordConstraints));
            }
        }

        return $query->execute(true);
    }
}
