<?php

namespace Internetgalerie\IgsCrm\Domain\Repository;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

/**
 * The repository for Tagverband
 */
class ApiRepository extends Repository
{
    protected $defaultOrderings = [
        'name' => QueryInterface::ORDER_ASCENDING,
    ];
    public function initializeObject(): void
    {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(false);
        $this->setDefaultQuerySettings($querySettings);
    }

    public function getRawByApiKey(string $apiKey)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            'tx_igscrm_domain_model_api'
        );
        $queryBuilder
            ->select('verband', 'acl')
            ->from('tx_igscrm_domain_model_api')
            ->where($queryBuilder->expr() ->eq('api_key', $queryBuilder->createNamedParameter($apiKey)));
        $res = $queryBuilder->executeQuery();
        return $res->fetchAssociative() ?: [];
    }
}
